/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.tools.StaticResources;

public class AttributeHelper {
    public static final String PRINT_FIELD = "PrintField";
    public static final String LAYOUT = "Layout";
    public static final String LIST = "List";
    public static final String NONE = "None";

    public static String getListNumbering(COSObject simpleCosObject) {
        return AttributeHelper.getNameAttributeValue(simpleCosObject, ASAtom.LIST_NUMBERING, LIST, NONE, true);
    }

    public static String getNoteType(COSObject simpleCosObject) {
        return AttributeHelper.getNameAttributeValue(simpleCosObject, ASAtom.NOTE_TYPE, "FENote", NONE, false);
    }

    public static Long getColSpan(COSObject simpleCosObject) {
        return AttributeHelper.getIntegerAttributeValue(simpleCosObject, ASAtom.COL_SPAN, "Table", 1L);
    }

    public static Long getRowSpan(COSObject simpleCosObject) {
        return AttributeHelper.getIntegerAttributeValue(simpleCosObject, ASAtom.ROW_SPAN, "Table", 1L);
    }

    public static String getScope(COSObject simpleCosObject) {
        return AttributeHelper.getNameAttributeValue(simpleCosObject, ASAtom.SCOPE, "Table", null, false);
    }

    public static String getRole(COSObject simpleCosObject) {
        return AttributeHelper.getNameAttributeValue(simpleCosObject, ASAtom.ROLE, PRINT_FIELD, null, false);
    }

    public static COSArray getBBox(COSObject simpleCosObject) {
        return AttributeHelper.getArrayAttributeValue(simpleCosObject, ASAtom.BBOX, LAYOUT, null);
    }

    public static COSArray getArrayAttributeValue(COSObject simpleCosObject, ASAtom attributeName, String O, COSArray defaultValue) {
        COSObject object = AttributeHelper.getAttributeValue(simpleCosObject, attributeName, O, COSObjType.COS_ARRAY);
        if (object.getType() == COSObjType.COS_ARRAY) {
            return (COSArray)object.getDirectBase();
        }
        return defaultValue;
    }

    private static String getNameAttributeValue(COSObject simpleCosObject, ASAtom attributeName, String O, String defaultValue, boolean isInheritable) {
        COSObject parent;
        COSObject object = AttributeHelper.getAttributeValue(simpleCosObject, attributeName, O, COSObjType.COS_NAME);
        if (object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        if (isInheritable && (parent = simpleCosObject.getKey(ASAtom.P)) != null) {
            return AttributeHelper.getNameAttributeValue(parent, attributeName, O, defaultValue, true);
        }
        return defaultValue;
    }

    private static Long getIntegerAttributeValue(COSObject simpleCosObject, ASAtom attributeName, String O, Long defaultValue) {
        COSObject object = AttributeHelper.getAttributeValue(simpleCosObject, attributeName, O, COSObjType.COS_INTEGER);
        if (object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return defaultValue;
    }

    private static COSObject getAttributeValue(COSObject simpleCosObject, ASAtom attributeName, String O, COSObjType type) {
        COSObject attributeValue;
        block5: {
            attributeValue = AttributeHelper.getAttributeObject(simpleCosObject.getKey(ASAtom.A), attributeName, O, type);
            if (attributeValue != null) break block5;
            COSObject className = simpleCosObject.getKey(ASAtom.C);
            COSObject classMap = StaticResources.getDocument().getStructTreeRoot().getClassMap();
            if (className != null && classMap != null) {
                if (className.getType() == COSObjType.COS_NAME) {
                    attributeValue = AttributeHelper.getAttributeObject(classMap.getKey(className.getName()), attributeName, O, type);
                } else if (className.getType() == COSObjType.COS_ARRAY) {
                    for (COSObject entry : (COSArray)className.getDirectBase()) {
                        if (entry != null && entry.getType() == COSObjType.COS_NAME && (attributeValue = AttributeHelper.getAttributeObject(classMap.getKey(entry.getName()), attributeName, O, type)) != null) break;
                    }
                }
            }
        }
        return attributeValue != null ? attributeValue : COSObject.getEmpty();
    }

    private static COSObject getAttributeObject(COSObject attributeObject, ASAtom attributeName, String O, COSObjType type) {
        COSObject value;
        if (attributeObject == null) {
            return null;
        }
        if (attributeObject.getType() == COSObjType.COS_ARRAY) {
            for (COSObject object : (COSArray)attributeObject.getDirectBase()) {
                COSObject value2 = AttributeHelper.getAttributeObject(object, attributeName, O);
                if (value2.getType() != type) continue;
                return value2;
            }
        }
        return (value = AttributeHelper.getAttributeObject(attributeObject, attributeName, O)).getType() == type ? value : null;
    }

    private static COSObject getAttributeObject(COSObject object, ASAtom attributeName, String O) {
        if (object.getType() == COSObjType.COS_DICT && O.equals(object.getNameKeyStringValue(ASAtom.O))) {
            return object.getKey(attributeName);
        }
        return COSObject.getEmpty();
    }
}

