/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.OutputIntentFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class OutputIntentFeaturesObject
extends FeaturesObject {
    private static final String OUTPUTINTENT = "outputIntent";
    private static final String SUBTYPE = "subtype";
    private static final String OUTPUT_CONDITION = "outputCondition";
    private static final String OUTPUT_CONDITION_IDENTIFIER = "outputConditionIdentifier";
    private static final String REGISTRY_NAME = "registryName";
    private static final String INFO = "info";

    public OutputIntentFeaturesObject(OutputIntentFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.OUTPUTINTENT;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        OutputIntentFeaturesObjectAdapter outIntAdapter = (OutputIntentFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(OUTPUTINTENT);
        CreateNodeHelper.addNotEmptyNode(SUBTYPE, outIntAdapter.getSubType(), root);
        CreateNodeHelper.addNotEmptyNode(OUTPUT_CONDITION, outIntAdapter.getOutputCondition(), root);
        CreateNodeHelper.addNotEmptyNode(OUTPUT_CONDITION_IDENTIFIER, outIntAdapter.getOutputConditionIdentifier(), root);
        CreateNodeHelper.addNotEmptyNode(REGISTRY_NAME, outIntAdapter.getRegistryName(), root);
        CreateNodeHelper.addNotEmptyNode(INFO, outIntAdapter.getInfo(), root);
        String iccProfileID = outIntAdapter.getICCProfileID();
        if (iccProfileID != null) {
            FeatureTreeNode destOutInt = root.addChild("destOutputIntent");
            destOutInt.setAttribute("id", iccProfileID);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Subtype", OutputIntentFeaturesObject.generateVariableXPath(OUTPUTINTENT, SUBTYPE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Output Condition", OutputIntentFeaturesObject.generateVariableXPath(OUTPUTINTENT, OUTPUT_CONDITION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Output Condition Identified", OutputIntentFeaturesObject.generateVariableXPath(OUTPUTINTENT, OUTPUT_CONDITION_IDENTIFIER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Registry Name", OutputIntentFeaturesObject.generateVariableXPath(OUTPUTINTENT, REGISTRY_NAME), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Info", OutputIntentFeaturesObject.generateVariableXPath(OUTPUTINTENT, INFO), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", OutputIntentFeaturesObject.generateAttributeXPath(OUTPUTINTENT, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

