/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters.io;

import org.verapdf.as.filters.ASOutFilter;
import org.verapdf.as.io.ASOutputStream;

public class ASBufferingOutFilter
extends ASOutFilter {
    private final int bufferCapacity;
    protected byte[] internalBuffer;
    private int bufferWriter;
    private final int bufferEnd;

    public ASBufferingOutFilter(ASOutputStream stream) {
        this(stream, 2048);
    }

    public ASBufferingOutFilter(ASOutputStream stream, int bufferCapacity) {
        super(stream);
        this.bufferCapacity = bufferCapacity;
        this.internalBuffer = new byte[bufferCapacity];
        this.bufferWriter = 0;
        this.bufferEnd = bufferCapacity;
    }

    @Override
    public void close() {
        this.internalBuffer = null;
        super.close();
    }

    public int getBufferWriter() {
        return this.bufferWriter;
    }

    public int getBufferEnd() {
        return this.bufferEnd;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public int bufferSize() {
        return this.bufferWriter;
    }

    public void storeChar(byte b) {
        this.internalBuffer[this.bufferWriter++] = b;
    }

    public int bufferRewind(int offset) {
        int actualOffset = Math.min(this.bufferWriter, offset);
        this.bufferWriter -= actualOffset;
        return actualOffset;
    }
}

