/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import com.helger.commons.io.stream.StreamHelper;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.XMLTools;
import org.mustangproject.util.ByteArraySearcher;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.PDFValidator;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.mustangproject.validator.XMLValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ZUGFeRDValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDValidator.class.getCanonicalName());
    protected ValidationContext context = new ValidationContext(LOGGER);
    protected String sha1Checksum;
    protected boolean pdfValidity;
    protected boolean displayXMLValidationOutput;
    protected long startTime;
    protected boolean optionsRecognized;
    protected boolean disableNotices = false;
    protected String Signature;
    protected boolean wasCompletelyValid = false;
    protected String logAppend = null;

    public boolean hasOptionsError() {
        return !this.optionsRecognized;
    }

    public void setLogAppend(String tobeappended) {
        this.logAppend = tobeappended;
    }

    public boolean wasCompletelyValid() {
        return this.wasCompletelyValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalValidate(String contextFilename, InputStream inputStream, long inputLength) {
        boolean isPDF;
        StringBuilder finalStringResult;
        block20: {
            this.context.clear();
            finalStringResult = new StringBuilder();
            SimpleDateFormat isoDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            this.startTime = Calendar.getInstance().getTimeInMillis();
            this.context.setFilename(contextFilename);
            finalStringResult.append("<validation filename='").append(contextFilename).append("' datetime='").append(isoDF.format(date)).append("'>");
            isPDF = false;
            byte[] content = null;
            try {
                if (contextFilename == null || contextFilename.isEmpty()) {
                    this.optionsRecognized = false;
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Filename not specified").setSection(10).setPart(EPart.pdf));
                }
                PDFValidator pdfv = new PDFValidator(this.context);
                if (inputStream == null) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File not found").setSection(1).setPart(EPart.pdf));
                    break block20;
                }
                if (inputLength < 32L) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File too small").setSection(5).setPart(EPart.pdf));
                    break block20;
                }
                if (inputLength >= Integer.MAX_VALUE) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "File too big").setSection(5).setPart(EPart.pdf));
                    break block20;
                }
                content = IOUtils.toByteArray(inputStream);
                XMLValidator xv = new XMLValidator(this.context);
                if (this.disableNotices) {
                    xv.disableNotices();
                }
                if (isPDF = ByteArraySearcher.startsWith(content, new byte[]{37, 80, 68, 70})) {
                    pdfv.setFilenameAndContents(contextFilename, content);
                    this.context.setHasPDF();
                    this.optionsRecognized = true;
                    finalStringResult.append("<pdf>");
                    try {
                        pdfv.validate();
                        this.sha1Checksum = ZUGFeRDValidator.calcSHA1(content);
                        this.getPdfValidationResults(finalStringResult, pdfv, xv);
                    }
                    catch (IrrecoverableValidationError irx) {
                        LOGGER.info(irx.getMessage());
                    }
                    finalStringResult.append("</pdf>\n");
                    this.context.clearCustomXML();
                } else {
                    boolean isXML = false;
                    String xmlAsString = null;
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        dbf.setXIncludeAware(false);
                        dbf.setExpandEntityReferences(false);
                        dbf.setNamespaceAware(true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        content = XMLTools.removeBOM(content);
                        xmlAsString = new String(content, StandardCharsets.UTF_8);
                        InputSource is = new InputSource(new StringReader(xmlAsString));
                        org.w3c.dom.Document doc = db.parse(is);
                        Element root = doc.getDocumentElement();
                        isXML = true;
                    }
                    catch (Exception ex) {
                        LOGGER.info("No XML part provided");
                    }
                    if (isXML) {
                        this.pdfValidity = true;
                        this.optionsRecognized = true;
                        xv.setStringContent(xmlAsString);
                        xv.setAutoload(false);
                        xv.setFilename(contextFilename);
                        this.sha1Checksum = ZUGFeRDValidator.calcSHA1(content);
                        this.displayXMLValidationOutput = true;
                    } else {
                        this.optionsRecognized = false;
                        this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "File does not look like PDF nor XML (contains neither %PDF nor <?xml)").setSection(8));
                    }
                }
                if (!this.optionsRecognized || !this.displayXMLValidationOutput) break block20;
                finalStringResult.append("<xml>");
                try {
                    xv.validate();
                }
                catch (IrrecoverableValidationError irx) {
                    LOGGER.error("XML validation threw an exception ", irx);
                }
                finalStringResult.append(xv.getXMLResult());
                finalStringResult.append("</xml>");
                this.context.clearCustomXML();
            }
            catch (IOException | IrrecoverableValidationError irx) {
                LOGGER.info(irx.getMessage());
                this.context.setInvalid();
            }
            finally {
                finalStringResult.append(this.context.getXMLResult());
                finalStringResult.append("</validation>");
            }
        }
        return this.formatOutput(finalStringResult, isPDF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(String filename) {
        long inputLength;
        FileInputStream inputStream;
        String contextFilename;
        if (filename == null) {
            contextFilename = "";
            inputStream = null;
            inputLength = 0L;
        } else {
            File file = new File(filename);
            contextFilename = file.getName();
            if (file.isFile()) {
                try {
                    inputStream = new FileInputStream(file);
                    inputLength = Files.size(file.toPath());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            } else {
                inputStream = null;
                inputLength = 0L;
            }
        }
        try {
            String string = this.internalValidate(contextFilename, inputStream, inputLength);
            return string;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(InputStream inputStream, String fileNameOfInputStream) {
        long inputLength;
        try {
            inputLength = inputStream == null ? 0L : (long)inputStream.available();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        try {
            String string = this.internalValidate(fileNameOfInputStream, inputStream, inputLength);
            return string;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    public String validate(byte[] bytes, String fileNameOfInputStream) {
        String string;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            string = this.internalValidate(fileNameOfInputStream, bais, bytes.length);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        bais.close();
        return string;
    }

    private void getPdfValidationResults(StringBuilder finalStringResult, PDFValidator pdfv, XMLValidator xv) throws IrrecoverableValidationError {
        finalStringResult.append(pdfv.getXMLResult());
        this.pdfValidity = this.context.isValid();
        this.Signature = this.context.getSignature();
        this.context.clear();
        if (pdfv.getRawXML() != null) {
            xv.setStringContent(pdfv.getRawXML());
            this.displayXMLValidationOutput = true;
        } else {
            this.context.addResultItem(new ValidationResultItem(ESeverity.exception, "XML could not be extracted").setSection(17));
        }
    }

    private String formatOutput(StringBuilder finalStringResult, boolean isPDF) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText(finalStringResult.toString());
        }
        catch (DocumentException e1) {
            LOGGER.error(e1.getMessage());
        }
        XMLWriter writer = new XMLWriter(sw, format);
        try {
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        boolean xmlValidity = this.context.isValid();
        long duration = Calendar.getInstance().getTimeInMillis() - this.startTime;
        String toBeAppended = "";
        if (this.logAppend != null) {
            toBeAppended = this.logAppend;
        }
        String pdfResult = "invalid";
        if (!isPDF) {
            pdfResult = "absent";
        } else if (this.pdfValidity) {
            pdfResult = "valid";
        }
        LOGGER.info("Parsed PDF:" + pdfResult + " XML:" + (xmlValidity ? "valid" : "invalid") + " Signature:" + this.Signature + " Checksum:" + this.sha1Checksum + " Profile:" + this.context.getProfile() + " Version:" + this.context.getGeneration() + " Took:" + duration + "ms Errors:[" + this.context.getCSVResult() + "] ErrorIDs: [" + this.context.getCSVIDResult() + "]" + toBeAppended);
        this.wasCompletelyValid = xmlValidity;
        return sw.toString();
    }

    public void disableNotices() {
        this.disableNotices = true;
    }

    private static String calcSHA1(byte[] data) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(data, 0, data.length);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), e);
        }
        if (sha1 == null) {
            return "";
        }
        return DatatypeConverter.printHexBinary(sha1.digest());
    }
}

