/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mustangproject.EStandard;
import org.mustangproject.ZUGFeRD.Profile;

public class Profiles {
    static Map<String, Profile> zf2Map = Stream.of({"MINIMUM", new Profile("MINIMUM", "urn:factur-x.eu:1p0:minimum")}, {"BASICWL", new Profile("BASICWL", "urn:factur-x.eu:1p0:basicwl")}, {"BASIC", new Profile("BASIC", "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic")}, {"EN16931", new Profile("EN16931", "urn:cen.eu:en16931:2017")}, {"EXTENDED", new Profile("EXTENDED", "urn:cen.eu:en16931:2017#conformant#urn:factur-x.eu:1p0:extended")}, {"XRECHNUNG", new Profile("XRECHNUNG", "urn:cen.eu:en16931:2017#compliant#urn:xeinkauf.de:kosit:xrechnung_3.0")}).collect(Collectors.toMap(data -> (String)data[0], data -> (Profile)data[1]));
    static Map<String, Profile> zf1Map = Stream.of({"BASIC", new Profile("BASIC", "urn:ferd:CrossIndustryDocument:invoice:1p0:basic")}, {"COMFORT", new Profile("COMFORT", "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort")}, {"EXTENDED", new Profile("EXTENDED", "urn:ferd:CrossIndustryDocument:invoice:1p0:extended")}).collect(Collectors.toMap(data -> (String)data[0], data -> (Profile)data[1]));
    static Map<String, Profile> ox1Map = Stream.of({"BASIC", new Profile("BASIC", "urn:order-x.eu:1p0:basic")}, {"COMFORT", new Profile("COMFORT", "urn:order-x.eu:1p0:comfort")}, {"EXTENDED", new Profile("EXTENDED", "urn:order-x.eu:1p0:extended")}).collect(Collectors.toMap(data -> (String)data[0], data -> (Profile)data[1]));
    static Map<String, Profile> dx1Map = Stream.of(new Object[][]{{"PILOT", new Profile("PILOT", "urn:awv-net.de:CIDA:1.0:pilot")}}).collect(Collectors.toMap(data -> (String)data[0], data -> (Profile)data[1]));

    public static Profile getByName(EStandard standard, String name, int version) {
        if (standard == EStandard.orderx) {
            Profile result = null;
            result = ox1Map.get(name.toUpperCase());
            if (result == null) {
                throw new RuntimeException("Profile not found");
            }
            return result;
        }
        if (standard == EStandard.despatchadvice) {
            Profile result = null;
            result = dx1Map.get(name.toUpperCase());
            if (result == null) {
                throw new RuntimeException("Profile not found");
            }
            return result;
        }
        int generation = version;
        if (standard == EStandard.facturx && version == 1) {
            generation = 2;
        }
        return Profiles.getByName(name, generation);
    }

    public static Profile getByName(String name, int version) {
        Profile result = null;
        result = version == 1 ? zf1Map.get(name.toUpperCase()) : zf2Map.get(name.toUpperCase());
        if (result == null) {
            throw new RuntimeException("Profile not found");
        }
        return result;
    }

    public static Profile getByName(String name) {
        return Profiles.getByName(name, 2);
    }

    public static Profile getByNameDisregardingVersion(String name) {
        Profile result = null;
        result = zf1Map.get(name.toUpperCase());
        if (result == null) {
            result = zf2Map.get(name.toUpperCase());
        }
        if (result == null) {
            throw new RuntimeException("Profile " + name + " not found");
        }
        return result;
    }
}

