/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;

public class DestinationValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightPath vPath = ctx.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(COSBase.class)) {
            ctx.addValidationError(new ValidationResult.ValidationError("6.1.3", "Destination validation process needs at least one COSBase object"));
            return;
        }
        COSBase dest = (COSBase)vPath.peek();
        if (!(dest instanceof COSName || dest instanceof COSString || dest instanceof COSArray)) {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "Destination type entry " + dest.getClass().getSimpleName() + " is invalid"));
            return;
        }
        if (dest instanceof COSArray) {
            COSArray ar = (COSArray)dest;
            if (ar.size() < 2) {
                ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "Destination array must have at least 2 elements"));
                return;
            }
            if (!(ar.get(1) instanceof COSName)) {
                ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "Second element of destination array must be a name"));
                return;
            }
            this.validateExplicitDestination(ctx, ar);
        }
        try {
            PDDestination.create(dest);
        }
        catch (IOException e) {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", e.getMessage(), e));
        }
    }

    void validateExplicitDestination(PreflightContext ctx, COSArray ar) {
        COSName type;
        COSBase cosObject = ar.getObject(0);
        if (cosObject instanceof COSDictionary && COSName.PAGE.equals(type = ((COSDictionary)cosObject).getCOSName(COSName.TYPE))) {
            try {
                PDDestination.create(ar);
            }
            catch (IOException e) {
                ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", e.getMessage(), e));
            }
            return;
        }
        ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "First element in Destination array entry must be an indirect reference to a dictionary of /Type /Page, but is " + ar.getName(0)));
    }
}

