/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTFontFamily;

public final class ACIUtils {
    private static final Log LOG = LogFactory.getLog(ACIUtils.class);

    private ACIUtils() {
    }

    public static Font[] findFontsForBatikACI(AttributedCharacterIterator aci, FontInfo fontInfo) {
        ArrayList<Font> fonts = new ArrayList<Font>();
        List gvtFonts = (List)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        String style = ACIUtils.toStyle((Float)aci.getAttribute(TextAttribute.POSTURE));
        int weight = ACIUtils.toCSSWeight((Float)aci.getAttribute(TextAttribute.WEIGHT));
        float fontSize = ((Float)aci.getAttribute(TextAttribute.SIZE)).floatValue();
        String firstFontFamily = null;
        GVTFont gvtFont = (GVTFont)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gvtFont != null) {
            String gvtFontFamily = gvtFont.getFamilyName();
            if (gvtFont instanceof FOPGVTFont) {
                Font font = ((FOPGVTFont)gvtFont).getFont();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found a font that matches the GVT font: " + gvtFontFamily + ", " + weight + ", " + style + " -> " + font);
                }
                fonts.add(font);
            }
            firstFontFamily = gvtFontFamily;
        }
        if (gvtFonts != null) {
            boolean haveInstanceOfSVGFontFamily = false;
            for (GVTFontFamily fontFamily : gvtFonts) {
                if (fontFamily instanceof SVGFontFamily) {
                    haveInstanceOfSVGFontFamily = true;
                } else if (fontFamily instanceof FOPGVTFontFamily) {
                    Font font = ((FOPGVTFontFamily)fontFamily).deriveFont(fontSize, aci).getFont();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found a font that matches the GVT font family: " + fontFamily.getFamilyName() + ", " + weight + ", " + style + " -> " + font);
                    }
                    fonts.add(font);
                }
                if (firstFontFamily != null) continue;
                firstFontFamily = fontFamily.getFamilyName();
            }
            if (fonts.isEmpty() && haveInstanceOfSVGFontFamily) {
                fontInfo.notifyStrokingSVGTextAsShapes(firstFontFamily);
                return null;
            }
        }
        return fonts.isEmpty() ? null : fonts.toArray(new Font[fonts.size()]);
    }

    public static int toCSSWeight(Float weight) {
        if (weight == null) {
            return 400;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue()) {
            return 100;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_LIGHT.floatValue()) {
            return 200;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_DEMILIGHT.floatValue()) {
            return 300;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_REGULAR.floatValue()) {
            return 400;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_SEMIBOLD.floatValue()) {
            return 500;
        }
        if (weight.floatValue() < TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 600;
        }
        if (weight.floatValue() == TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 700;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_HEAVY.floatValue()) {
            return 800;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_EXTRABOLD.floatValue()) {
            return 900;
        }
        return 900;
    }

    public static String toStyle(Float posture) {
        return posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
    }

    public static void dumpAttrs(AttributedCharacterIterator aci) {
        aci.first();
        Set<Map.Entry<AttributedCharacterIterator.Attribute, Object>> entries = aci.getAttributes().entrySet();
        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : entries) {
            if (entry.getValue() == null) continue;
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        int start = aci.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (aci.current() != '\uffff') {
            int end = aci.getRunLimit();
            System.out.print("" + (end - start) + ", ");
            aci.setIndex(end);
            if (start == end) break;
            start = end;
        }
        System.out.println("");
    }
}

