/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageConverterG2D2SVG
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws ImageException {
        this.checkSourceFlavor(src);
        ImageGraphics2D g2dImage = (ImageGraphics2D)src;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Element root = document.getDocumentElement();
        SVGGeneratorContext genCtx = SVGGeneratorContext.createDefault(document);
        genCtx.setComment("Generated by Apache Batik's SVGGraphics2D");
        genCtx.setEmbeddedFontsOn(true);
        SVGGraphics2D g2d = new SVGGraphics2D(genCtx, true);
        ImageSize size = src.getSize();
        Dimension dim = size.getDimensionMpt();
        g2d.setSVGCanvasSize(dim);
        root.setAttribute("viewBox", "0 0 " + dim.width + " " + dim.height);
        g2dImage.getGraphics2DImagePainter().paint(g2d, new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height));
        g2d.getRoot(root);
        ImageXMLDOM svgImage = new ImageXMLDOM(src.getInfo(), document, BatikImageFlavors.SVG_DOM);
        g2d.dispose();
        return svgImage;
    }

    @Override
    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return BatikImageFlavors.SVG_DOM;
    }
}

