/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverterException;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverterRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MicroTypeConverter {
    private static final MicroTypeConverter INSTANCE = new MicroTypeConverter();

    private MicroTypeConverter() {
    }

    @Nullable
    public static <T> IMicroElement convertToMicroElement(@Nullable T t, @Nonnull @Nonempty String string) {
        return MicroTypeConverter.convertToMicroElement(t, null, string);
    }

    @Nullable
    public static <T> IMicroElement convertToMicroElement(@Nullable T t, @Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string2, "TagName");
        if (t == null) {
            return null;
        }
        Class clazz = (Class)GenericReflection.uncheckedCast(t.getClass());
        IMicroTypeConverter<T> iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToMicroElement(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        IMicroElement iMicroElement = iMicroTypeConverter.convertToMicroElement(t, string, string2);
        if (iMicroElement == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return iMicroElement;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @Nonnull Class<DSTTYPE> clazz) {
        return MicroTypeConverter.convertToNative(iMicroElement, clazz, null);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @Nonnull Class<DSTTYPE> clazz, @Nullable DSTTYPE DSTTYPE) {
        ValueEnforcer.notNull(clazz, "DestClass");
        if (iMicroElement == null) {
            return DSTTYPE;
        }
        IMicroTypeConverter<DSTTYPE> iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToNative(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        DSTTYPE DSTTYPE2 = iMicroTypeConverter.convertToNative(iMicroElement);
        if (DSTTYPE2 == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return DSTTYPE2;
    }
}

