/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.jaxb.JAXBNamespacePrefixMapper;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;

@Immutable
public final class JAXBMarshallerHelper {
    private static final String JAXB_EXTERNAL_CLASS_NAME = "org.glassfish.jaxb.runtime.v2.runtime.MarshallerImpl";
    private static final String JAKARTA_INDENT_STRING = "org.glassfish.jaxb.indentString";
    private static final String JAKARTA_PREFIX_MAPPER = "org.glassfish.jaxb.namespacePrefixMapper";
    private static final String JAKARTA_ENCODING_HANDLER2 = "org.glassfish.jaxb.marshaller.CharacterEscapeHandler";
    private static final String JAKARTA_XML_HEADERS = "org.glassfish.jaxb.xmlHeaders";
    private static final String JAKARTA_C14N = "org.glassfish.jaxb.c14n";
    private static final String JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION = "org.glassfish.jaxb.objectIdentitityCycleDetection";

    private JAXBMarshallerHelper() {
    }

    private static void _setProperty(@Nonnull Marshaller marshaller, @Nonnull String string, @Nullable Object object) {
        try {
            marshaller.setProperty(string, object);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to set JAXB property '" + string + "' to " + String.valueOf(object), propertyException);
        }
    }

    @Nullable
    private static Object _getProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        try {
            return marshaller.getProperty(string);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to get JAXB property '" + string + "'", propertyException);
        }
    }

    private static boolean _getBooleanProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        return (Boolean)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    @Nullable
    private static String _getStringProperty(@Nonnull Marshaller marshaller, @Nonnull String string) {
        return (String)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    @Nullable
    public static String getEncoding(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.encoding");
    }

    public static void setEncoding(@Nonnull Marshaller marshaller, @Nullable Charset charset) {
        JAXBMarshallerHelper.setEncoding(marshaller, charset == null ? null : charset.name());
    }

    public static void setEncoding(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.encoding", string);
    }

    public static boolean isFormattedOutput(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.formatted.output");
    }

    public static void setFormattedOutput(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.formatted.output", bl);
    }

    @Nullable
    public static String getSchemaLocation(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.schemaLocation");
    }

    public static void setSchemaLocation(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.schemaLocation", string);
    }

    @Nullable
    public static String getNoNamespaceSchemaLocation(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.noNamespaceSchemaLocation");
    }

    public static void setNoNamespaceSchemaLocation(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.noNamespaceSchemaLocation", string);
    }

    public static boolean isFragment(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.fragment");
    }

    public static void setFragment(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.fragment", bl);
    }

    @Nullable
    public static String getJakartaIndentString(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, JAKARTA_INDENT_STRING);
    }

    public static void setJakartaIndentString(@Nonnull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_INDENT_STRING, string);
    }

    @Nullable
    public static Object getJakartaCharacterEscapeHandler(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getProperty(marshaller, JAKARTA_ENCODING_HANDLER2);
    }

    public static void setJakartaCharacterEscapeHandler(@Nonnull Marshaller marshaller, @Nonnull Object object) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_ENCODING_HANDLER2, object);
    }

    @Nullable
    public static JAXBNamespacePrefixMapper getJakartaNamespacePrefixMapper(@Nonnull Marshaller marshaller) {
        return (JAXBNamespacePrefixMapper)JAXBMarshallerHelper._getProperty(marshaller, JAKARTA_PREFIX_MAPPER);
    }

    public static void setJakartaNamespacePrefixMapper(@Nonnull Marshaller marshaller, @Nonnull NamespaceContext namespaceContext) {
        JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper = new JAXBNamespacePrefixMapper(namespaceContext);
        JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(marshaller, jAXBNamespacePrefixMapper);
    }

    public static void setJakartaNamespacePrefixMapper(@Nonnull Marshaller marshaller, @Nonnull JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_PREFIX_MAPPER, jAXBNamespacePrefixMapper);
    }

    @Nullable
    public static String getJakartaXMLHeaders(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, JAKARTA_XML_HEADERS);
    }

    public static void setJakartaXMLHeaders(@Nonnull Marshaller marshaller, @Nonnull String string) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_XML_HEADERS, string);
    }

    public static boolean isJakartaCanonicalization(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, JAKARTA_C14N);
    }

    public static void setJakartaCanonicalization(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_C14N, bl);
    }

    public static boolean isJakartaObjectIdentityCycleDetection(@Nonnull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION);
    }

    public static void setJakartaObjectIdentityCycleDetection(@Nonnull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION, bl);
    }

    public static boolean isJakartaJAXBMarshaller(@Nullable Marshaller marshaller) {
        if (marshaller == null) {
            return false;
        }
        String string = marshaller.getClass().getName();
        return string.equals(JAXB_EXTERNAL_CLASS_NAME);
    }
}

