<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron"
    schemaVersion="iso">
  <title>Schema for SCRDMCCBDACIOMessageStructure_100pD20B; D20B; Basic</title>
  <ns uri="urn:un:unece:uncefact:codelist:standard:6:0133:40106" prefix="clm60133"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccessRightsType:D11A" prefix="clm210AccountingE704"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAccountBalanceReopeningType:D11A" prefix="clm210AccountingE602"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAccountClassification:D11A" prefix="clm210AccountingE902"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAccountNatureType:D11A" prefix="clm210AccountingE502"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAccountStatus:D11A" prefix="clm210AccountingE305"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAccountType:D11A" prefix="clm210AccountingE501"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAmountQualifierType:D11A" prefix="clm210AccountingE603"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingAmountType:D11A" prefix="clm210AccountingE601"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingContact:D11A" prefix="clm210AccountingE023"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingDocumentType:D11A" prefix="clm210AccountingE006"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingEntryCategory:D11A" prefix="clm210AccountingE202"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingEntryLineCategory:D11A" prefix="clm210AccountingE203"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingEntryLineSource:D11A" prefix="clm210AccountingE302"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingEntryProcessing:D11A" prefix="clm210AccountingE201"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingJournal:D11A" prefix="clm210AccountingE012"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingJournalCategory:D11A" prefix="clm210AccountingE013"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingPeriodFunctionType:D11A" prefix="clm210AccountingE703"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingPerquisite:D11A" prefix="clm210AccountingE021"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AccountingVoucherMedium:D11A" prefix="clm210AccountingE101"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AdditionalPostponement:D11A" prefix="clm210AccountingE904"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AddressFormatType:D11A" prefix="clm210AccountingE011"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AlternateCurrencyAmount:D11A" prefix="clm210AccountingE304"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AmortizationMethod:D11A" prefix="clm210AccountingE204"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:AmountWeightType:D11A" prefix="clm210AccountingE702"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:CertificateType:D11A" prefix="clm210AccountingE004"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:FinancialAccountType:D11A" prefix="clm210AccountingE016"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:FinancialInstitutionRole:D11A" prefix="clm210AccountingE015"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:LifetimeEndCost:D11A" prefix="clm210LifetimeEndCostE206"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:OrganizationFunctionType:D11A" prefix="clm210OrganizationFunctionTypeE706"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:PartyType:D11A" prefix="clm210PartyTypeE705"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:RefundMethod:D11A" prefix="clm210RefundMethodE022"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:ScenarioType:D11A" prefix="clm210ScenarioTypeE018"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:SoftwareUserType:D11A" prefix="clm210SoftwareUserTypeE019"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:EDIFICAS-EU:TaxExemptionReason:D11A" prefix="clm210AccountingE307"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:IANA:CharacterSetCode:2013-01-23" prefix="clmIANACharacterSetCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:ISO:ISO2AlphaLanguageCode:2006-10-27" prefix="clm5ISO63912A"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:ISO:ISO3AlphaCurrencyCode:2012-08-31" prefix="clm5ISO42173A"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ActionCode:D20A" prefix="clm61229LineStatusCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AddressType:D20A" prefix="clm63131"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AdjustmentReasonDescriptionCode:D20A" prefix="clm64465"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AdjustmentReasonDescriptionCode_Financial:D20A" prefix="clm64465AdjustmentReasonCodeFinancial"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AgencyIdentificationCode:D20A" prefix="clm63055"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AllowanceChargeIdentificationCode:D20A" prefix="clm65189AllowanceChargeID"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AllowanceChargeReasonCode:D20A" prefix="clm64465AllowanceChargeReasonCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:AutomaticDataCaptureMethodCode:D20A" prefix="clm67233AutomaticDataCaptureMethodCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CargoOperationalCategoryCode:D20A" prefix="clm67085b"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CargoTypeClassificationCode:D20A" prefix="clm67085"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CargoTypeCode:1996Rev2Final" prefix="clm6Recommendation21AnnexI"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CommodityIdentificationCode:D19B" prefix="clm67357"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CommunicationMeansTypeCode:D20A" prefix="clm63155CommunicationChannelCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ContactFunctionCode:D20A" prefix="clm63139ContactTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ContractTypeCode:D10B" prefix="clm69651"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ContractorType:D10B" prefix="clm6ContractorType"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CostManagementCode:D10B" prefix="clm69653"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CostReportingCode:D10B" prefix="clm69655"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:CustomsDutyRegimeTypeCode:D20A" prefix="clm69213"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DangerousGoodsPackingCode:D20A" prefix="clm68339"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DangerousGoodsRegulationCode:D20A" prefix="clm68273"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DateTimePeriodFunctionCode:D20A" prefix="clm62005DateTimePeriodFunctionCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DeliveryPlanCommitmentLevelCode:D20A" prefix="clm64017CommitmentLevelCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DeliveryTermsCode:2010" prefix="clm64053"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DeliveryTermsFunctionCode:D20A" prefix="clm64055DeliveryTermsFunctionCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DimensionTypeCode:D20A" prefix="clm66145"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode:D20A" prefix="clm61001"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Accounting:D20A" prefix="clm61001Accounting"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Billing:D20A" prefix="clm61001Billing"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Invoice:D20A" prefix="clm61001Invoice"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Quotation:D20A" prefix="clm61001DocumentTypeCodeQuotation"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Remittance:D20A" prefix="clm61001DocumentTypeCodeRemittance"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentNameCode_Scheduling:D20A" prefix="clm61001DocumentTypeCodeScheduling"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DocumentStatusCode:D20A" prefix="clm61373"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DutyTaxFeeTypeCode:D20A" prefix="clm65153"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:DutyorTaxorFeeCategoryCode:D20A" prefix="clm65305"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:EarnedValueCalculationMethod:D10B" prefix="clm69657"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:EquipmentSizeTypeDescriptionCode:D20A" prefix="clm68155"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:EquipmentSupplierCode:D20A" prefix="clm68077"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:EventTimeReferenceCode:D20A" prefix="clm62475"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:EventTimeReferenceCodePaymentTermsEvent:D20A" prefix="clm62475PaymentTermsEvent"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:FreightChargeQuantityUnitBasisCode:D19B" prefix="clm66131"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:FreightChargeTariffCode:D20A" prefix="clm65243"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:FundingTypeCode:D10B" prefix="clm69659"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:GoodsTypeCode:D19B" prefix="clm6TDED7357"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:GoodsTypeExtensionCode:D19B" prefix="clm6TDED7361"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:GovernmentActionCode:D20A" prefix="clm69417"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:HierarchicalStructureTypeCode:D10B" prefix="clm69661"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:LocationFunctionCode:D20A" prefix="clm63227"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MarkingInstructionCode:D20A" prefix="clm64233"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasuredAttributeCode:D20A" prefix="clm66313"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCodeDuration:4" prefix="clm6Recommendation20Duration"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCodeLinear:4" prefix="clm6Recommendation20Linear"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCodeTemperature:4" prefix="clm6Recommendation20Temperature"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCodeVolume:4" prefix="clm6Recommendation20Volume"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCodeWeight:4" prefix="clm6Recommendation20Weight"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCode_Airflow:4" prefix="clm6Recommendation20Airflow"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MeasurementUnitCommonCode_FileSize:4" prefix="clm6Recommendation20FileSize"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MessageFunctionCode:D20A" prefix="clm61225MessageFunctionTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:MessageFunctionCode_Acknowledgement:D20A" prefix="clm61225Acknowledgement"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ObligationGuaranteeCode:D19B" prefix="clm64377"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PackageTypeCode:2006" prefix="clm67065"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PackagingLevelCode:D20A" prefix="clm67075"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PackagingMarkingCode:D20A" prefix="clm67233PackagingMarkingCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PartyRoleCode:D20A" prefix="clm63035"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PartyRoleCode_ChargePaying:D20A" prefix="clm63035ChargePaying"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PaymentGuaranteeMeansCode:D20A" prefix="clm64431"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PaymentMeansChannelCode:D20A" prefix="clm64435"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PaymentMeansCode:D20A" prefix="clm64461"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PaymentMethodCode:D20A" prefix="clm64439"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PaymentTermsTypeCode:D20A" prefix="clm64279"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PlanningLevel:D10B" prefix="clm6PlanningLevel"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PriceTypeCode:D20A" prefix="clm65375"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:PriorityDescriptionCode:D20A" prefix="clm64037PriorityDescriptionCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ProcessTypeCode:D20A" prefix="clm67187"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ProjectTypeCode:D10B" prefix="clm69665"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ReferenceTypeCode:D20A" prefix="clm61153ReferenceTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ReportingThresholdTriggerType:D10B" prefix="clm69667"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ResourceCostCategory:D10B" prefix="clm69669"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ResourcePlanMeasureType:D10B" prefix="clm69671"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ResponseTypeCode:D20A" prefix="clm64343ResponseTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ResponsibleAgencyCode:D20A" prefix="clm69415ResponsibleAgencyCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ResponsibleAgencyInvolvementCode:D20A" prefix="clm69411ResponsibleAgencyInvolvementCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ScheduleTaskRelationshipType:D10B" prefix="clm69673"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ScheduleTaskType:D10B" prefix="clm69675"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:ScheduleTypeCode:D10B" prefix="clm6ScheduleTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:SealConditionCode:D20A" prefix="clm64517"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:SealTypeCode:D14A" prefix="clm6SealTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:SealingPartyRoleCode:D20A" prefix="clm69303"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:SecurityClassificationType:D10B" prefix="clm69677"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:StatusCode:D20A" prefix="clm64405"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:StatusDescriptionCode_AccountingDebitCredit:D20A" prefix="clm64405AccountingDebitCredit"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:StatusDescriptionCode_Workflow:D20A" prefix="clm64405StatusCodeWorkflow"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TemperatureTypeCode:D20A" prefix="clm66245"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TimeOnlyFormatCode:D19B" prefix="clm62379timeonly"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TimePointFormatCode:D19B" prefix="clm62379"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentCategoryCode:D20A" prefix="clm68053"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentFullnessCode:D20A" prefix="clm68169"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentHaulageArrangementsCode:D20A" prefix="clm68341"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentMovementLegalStatusCode:D20A" prefix="clm68249c"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentMovementStatusCode:D20A" prefix="clm68249a"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportEquipmentOperationalStatusCode:D20A" prefix="clm68249b"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportMeansDirectionCode:D20A" prefix="clm68101"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportMeansTypeCode:2007" prefix="clm6Recommendation28"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportModeCode:2" prefix="clm6Recommendation19"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportMovementStageCode:D20A" prefix="clm68051"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportMovementTypeCode:D20A" prefix="clm68323TransportMovementTypeCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportPaymentArrangementCode:D20A" prefix="clm64237TransportPaymentArrangementCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportServiceCategoryCode:D20A" prefix="clm65237TransportServiceCategoryCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportServiceConditionCode:D20A" prefix="clm64065TransportServiceConditionCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportServicePriorityCode:D20A" prefix="clm64219TransportServicePriorityCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportServiceRequirementCode:D20A" prefix="clm67273TransportServiceRequirementCode"/>
  <ns uri="urn:un:unece:uncefact:codelist:standard:UNECE:TransportStatusCode:4" prefix="clm6Recommendation24"/>
  <ns uri="urn:un:unece:uncefact:data:SCRDMCCBDACIOMessageStructure:100" prefix="rsm"/>
  <ns uri="urn:un:unece:uncefact:data:standard:QualifiedDataType:128" prefix="qdt"/>
  <ns uri="urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:128" prefix="ram"/>
  <ns uri="urn:un:unece:uncefact:data:standard:UnqualifiedDataType:128" prefix="udt"/>
  <ns uri="urn:un:unece:uncefact:documentation:standard:CoreComponentsTechnicalSpecification:2" prefix="ccts"/>
  <ns uri="urn:un:unece:uncefact:identifierlist:standard:ISO:ISOAlpha2LanguageCode:2006-10-27" prefix="ids5ISO6391A2"/>
  <ns uri="urn:un:unece:uncefact:identifierlist:standard:ISO:ISOTwo-letterCountryCode:SecondEdition2006" prefix="ids5ISO316612A"/>
  <ns uri="urn:un:unece:uncefact:identifierlist:standard:UNECE:FreightCostCode:4" prefix="ids6Recommendation23"/>
  <ns uri="urn:un:unece:uncefact:identifierlist:standard:UNECE:PaymentTermsDescriptionIdentifier:D20A" prefix="ids64277"/>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:ExchangedDocument/ram:IncludedNote">
      <assert test="count(ram:Content)=1">
	Element 'ram:Content' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:ExchangedDocument/ram:IssueDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:ExchangedDocumentContext/ram:BusinessProcessSpecifiedDocumentContextParameter">
      <assert test="count(ram:ID)=1">
	Element 'ram:ID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:ExchangedDocumentContext/ram:GuidelineSpecifiedDocumentContextParameter">
      <assert test="count(ram:ID)=1">
	Element 'ram:ID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement">
      <assert test="count(ram:CatalogueReferencedDocument)&lt;=1">
	Element 'ram:CatalogueReferencedDocument' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BlanketOrderReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerOrderReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty">
      <assert test="count(ram:Name)=1">
	Element 'ram:Name' must occur exactly 1 times.</assert>
      <assert test="count(ram:DefinedTradeContact)&lt;=1">
	Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</assert>
      <assert test="count(ram:PostalTradeAddress)=1">
	Element 'ram:PostalTradeAddress' must occur exactly 1 times.</assert>
      <assert test="count(ram:SpecifiedTaxRegistration)&lt;=1">
	Element 'ram:SpecifiedTaxRegistration' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication">
      <assert test="count(ram:CompleteNumber)=1">
	Element 'ram:CompleteNumber' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty/ram:SpecifiedTaxRegistration/ram:ID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:BuyerTradeParty/ram:URIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:ContractReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:PreviousOrderChangeReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:PreviousOrderReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:PreviousOrderResponseReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:QuotationReferencedDocument">
      <assert test="count(ram:IssuerAssignedID)=1">
	Element 'ram:IssuerAssignedID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty">
      <assert test="count(ram:Name)=1">
	Element 'ram:Name' must occur exactly 1 times.</assert>
      <assert test="count(ram:DefinedTradeContact)&lt;=1">
	Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</assert>
      <assert test="count(ram:SpecifiedTaxRegistration)&lt;=1">
	Element 'ram:SpecifiedTaxRegistration' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication">
      <assert test="count(ram:CompleteNumber)=1">
	Element 'ram:CompleteNumber' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:SpecifiedTaxRegistration/ram:ID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeAgreement/ram:SellerTradeParty/ram:URIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery">
      <assert test="count(ram:PlannedDespatchSupplyChainEvent)&lt;=1">
	Element 'ram:PlannedDespatchSupplyChainEvent' may occur at maximum 1 times.</assert>
      <assert test="count(ram:PlannedDeliverySupplyChainEvent)&lt;=1">
	Element 'ram:PlannedDeliverySupplyChainEvent' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDeliverySupplyChainEvent/ram:OccurrenceDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDeliverySupplyChainEvent/ram:OccurrenceSpecifiedPeriod/ram:EndDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDeliverySupplyChainEvent/ram:OccurrenceSpecifiedPeriod/ram:StartDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDespatchSupplyChainEvent/ram:OccurrenceDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDespatchSupplyChainEvent/ram:OccurrenceSpecifiedPeriod/ram:EndDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:RequestedDespatchSupplyChainEvent/ram:OccurrenceSpecifiedPeriod/ram:StartDateTime/udt:DateTimeString">
      <assert test="@format">
	Attribute '@format' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipFromTradeParty">
      <assert test="count(ram:DefinedTradeContact)&lt;=1">
	Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipFromTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipFromTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication">
      <assert test="count(ram:CompleteNumber)=1">
	Element 'ram:CompleteNumber' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipFromTradeParty/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipFromTradeParty/ram:URIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipToTradeParty">
      <assert test="count(ram:Name)=1">
	Element 'ram:Name' must occur exactly 1 times.</assert>
      <assert test="count(ram:DefinedTradeContact)&lt;=1">
	Element 'ram:DefinedTradeContact' may occur at maximum 1 times.</assert>
      <assert test="count(ram:PostalTradeAddress)=1">
	Element 'ram:PostalTradeAddress' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipToTradeParty/ram:DefinedTradeContact/ram:EmailURIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipToTradeParty/ram:DefinedTradeContact/ram:TelephoneUniversalCommunication">
      <assert test="count(ram:CompleteNumber)=1">
	Element 'ram:CompleteNumber' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipToTradeParty/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeDelivery/ram:ShipToTradeParty/ram:URIUniversalCommunication">
      <assert test="count(ram:URIID)=1">
	Element 'ram:URIID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeSettlement">
      <assert test="count(ram:PurchaseSpecifiedTradeAccountingAccount)&lt;=1">
	Element 'ram:PurchaseSpecifiedTradeAccountingAccount' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeSettlement/ram:SpecifiedTradeSettlementHeaderMonetarySummation">
      <assert test="count(ram:TaxTotalAmount)&lt;=1">
	Element 'ram:TaxTotalAmount' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:ApplicableHeaderTradeSettlement/ram:SpecifiedTradeSettlementHeaderMonetarySummation/ram:TaxTotalAmount">
      <assert test="@currencyID">
	Attribute '@currencyID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:AssociatedDocumentLineDocument/ram:IncludedNote">
      <assert test="count(ram:Content)=1">
	Element 'ram:Content' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeAgreement">
      <assert test="count(ram:BuyerReference)&lt;=1">
	Element 'ram:BuyerReference' may occur at maximum 1 times.</assert>
      <assert test="count(ram:RequisitionReferencedDocument)&lt;=1">
	Element 'ram:RequisitionReferencedDocument' may occur at maximum 1 times.</assert>
      <assert test="count(ram:GrossPriceProductTradePrice)&lt;=1">
	Element 'ram:GrossPriceProductTradePrice' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeAgreement/ram:BlanketOrderReferencedDocument">
      <assert test="count(ram:LineID)=1">
	Element 'ram:LineID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeAgreement/ram:BuyerOrderReferencedDocument">
      <assert test="count(ram:LineID)=1">
	Element 'ram:LineID' must occur exactly 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeAgreement/ram:NetPriceProductTradePrice/ram:BasisQuantity">
      <assert test="@unitCode">
	Attribute '@unitCode' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeDelivery/ram:AgreedQuantity">
      <assert test="@unitCode">
	Attribute '@unitCode' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeDelivery/ram:RequestedQuantity">
      <assert test="@unitCode">
	Attribute '@unitCode' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedLineTradeSettlement">
      <assert test="count(ram:ApplicableTradeTax)&lt;=1">
	Element 'ram:ApplicableTradeTax' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedTradeProduct">
      <assert test="count(ram:GlobalID)&lt;=1">
	Element 'ram:GlobalID' may occur at maximum 1 times.</assert>
      <assert test="count(ram:ManufacturerAssignedID)&lt;=1">
	Element 'ram:ManufacturerAssignedID' may occur at maximum 1 times.</assert>
      <assert test="count(ram:GrossWeightMeasure)&lt;=1">
	Element 'ram:GrossWeightMeasure' may occur at maximum 1 times.</assert>
      <assert test="count(ram:ApplicableSupplyChainPackaging)&lt;=1">
	Element 'ram:ApplicableSupplyChainPackaging' may occur at maximum 1 times.</assert>
      <assert test="count(ram:OriginTradeCountry)&lt;=1">
	Element 'ram:OriginTradeCountry' may occur at maximum 1 times.</assert>
      <assert test="count(ram:LinearSpatialDimension)&lt;=1">
	Element 'ram:LinearSpatialDimension' may occur at maximum 1 times.</assert>
      <assert test="count(ram:MinimumLinearSpatialDimension)&lt;=1">
	Element 'ram:MinimumLinearSpatialDimension' may occur at maximum 1 times.</assert>
      <assert test="count(ram:MaximumLinearSpatialDimension)&lt;=1">
	Element 'ram:MaximumLinearSpatialDimension' may occur at maximum 1 times.</assert>
      <assert test="count(ram:ManufacturerTradeParty)&lt;=1">
	Element 'ram:ManufacturerTradeParty' may occur at maximum 1 times.</assert>
      <assert test="count(ram:MSDSReferenceReferencedDocument)&lt;=1">
	Element 'ram:MSDSReferenceReferencedDocument' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SpecifiedTradeProduct/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SubstitutedReferencedProduct">
      <assert test="count(ram:ManufacturerAssignedID)&lt;=1">
	Element 'ram:ManufacturerAssignedID' may occur at maximum 1 times.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="/rsm:SCRDMCCBDACIOMessageStructure/rsm:SupplyChainTradeTransaction/ram:IncludedSupplyChainTradeLineItem/ram:SubstitutedReferencedProduct/ram:GlobalID">
      <assert test="@schemeID">
	Attribute '@schemeID' is required in this context.</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="ram:SpecifiedTradeAllowanceCharge/ram:ReasonCode">
      <assert test="((../ram:ChargeIndicator/udt:Indicator = 'true') or ((../ram:ChargeIndicator/udt:Indicator = 'false') and (not(contains(normalize-space(.), ' ')) and contains(' 41 42 60 62 63 64 65 66 67 68 70 71 88 95 100 102 103 104 ', concat(' ', normalize-space(.), ' ')))))">
        Coded allowance reasons MUST belong to the UNCL 5189 code list</assert>
      <assert test="((../ram:ChargeIndicator/udt:Indicator = 'false') or ((../ram:ChargeIndicator/udt:Indicator = 'true') and (not(contains(normalize-space(.), ' ')) and contains(' AA AAA AAC AAD AAE AAF AAH AAI AAS AAT AAV AAY AAZ ABA ABB ABC ABD ABF ABK ABL ABN ABR ABS ABT ABU ACF ACG ACH ACI ACJ ACK ACL ACM ACS ADC ADE ADJ ADK ADL ADM ADN ADO ADP ADQ ADR ADT ADW ADY ADZ AEA AEB AEC AED AEF AEH AEI AEJ AEK AEL AEM AEN AEO AEP AES AET AEU AEV AEW AEX AEY AEZ AJ AU CA CAB CAD CAE CAF CAI CAJ CAK CAL CAM CAN CAO CAP CAQ CAR CAS CAT CAU CAV CAW CAX CAY CAZ CD CG CS CT DAB DAD DAC DAF DAG DAH DAI DAJ DAK DAL DAM DAN DAO DAP DAQ DL EG EP ER FAA FAB FAC FC FH FI GAA HAA HD HH IAA IAB ID IF IR IS KO L1 LA LAA LAB LF MAE MI ML NAA OA PA PAA PC PL RAB RAC RAD RAF RE RF RH RV SA SAA SAD SAE SAI SG SH SM SU TAB TAC TT TV V1 V2 WH XAA YY ZZZ ', concat(' ', normalize-space(.), ' ')))))">
        Coded charge reasons MUST belong to the UNCL 7161 code list</assert>
    </rule>
  </pattern>
  <pattern>
    <rule context="ram:AppliedTradeAllowanceCharge/ram:ReasonCode">
      <assert test="((../ram:ChargeIndicator/udt:Indicator = 'true') or ((../ram:ChargeIndicator/udt:Indicator = 'false') and (not(contains(normalize-space(.), ' ')) and contains(' 41 42 60 62 63 64 65 66 67 68 70 71 88 95 100 102 103 104 ', concat(' ', normalize-space(.), ' ')))))">
        Coded allowance reasons MUST belong to the UNCL 5189 code list</assert>
      <assert test="((../ram:ChargeIndicator/udt:Indicator = 'false') or ((../ram:ChargeIndicator/udt:Indicator = 'true') and (not(contains(normalize-space(.), ' ')) and contains(' AA AAA AAC AAD AAE AAF AAH AAI AAS AAT AAV AAY AAZ ABA ABB ABC ABD ABF ABK ABL ABN ABR ABS ABT ABU ACF ACG ACH ACI ACJ ACK ACL ACM ACS ADC ADE ADJ ADK ADL ADM ADN ADO ADP ADQ ADR ADT ADW ADY ADZ AEA AEB AEC AED AEF AEH AEI AEJ AEK AEL AEM AEN AEO AEP AES AET AEU AEV AEW AEX AEY AEZ AJ AU CA CAB CAD CAE CAF CAI CAJ CAK CAL CAM CAN CAO CAP CAQ CAR CAS CAT CAU CAV CAW CAX CAY CAZ CD CG CS CT DAB DAD DAC DAF DAG DAH DAI DAJ DAK DAL DAM DAN DAO DAP DAQ DL EG EP ER FAA FAB FAC FC FH FI GAA HAA HD HH IAA IAB ID IF IR IS KO L1 LA LAA LAB LF MAE MI ML NAA OA PA PAA PC PL RAB RAC RAD RAF RE RF RH RV SA SAA SAD SAE SAI SG SH SM SU TAB TAC TT TV V1 V2 WH XAA YY ZZZ ', concat(' ', normalize-space(.), ' ')))))">
        Coded charge reasons MUST belong to the UNCL 7161 code list</assert>
    </rule>
  </pattern>
</schema>
