/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import com.helger.schematron.ISchematronResource;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mustangproject.CalculatedInvoice;
import org.mustangproject.Invoice;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.ZUGFeRDInvoiceImporter;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.mustangproject.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLValidator
extends Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XMLValidator.class.getCanonicalName());
    protected String zfXML = "";
    protected String filename = "";
    int firedRules = 0;
    int failedRules = 0;
    boolean disableNotices = false;
    ISchematronResource aResSCH = null;

    public XMLValidator(ValidationContext ctx) {
        super(ctx);
    }

    @Override
    public void setFilename(String name) throws IrrecoverableValidationError {
        this.filename = name;
        if (this.autoload) {
            try {
                this.zfXML = new String(XMLTools.removeBOM((byte[])Files.readAllBytes(Paths.get(this.filename, new String[0]))), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                ValidationResultItem vri = new ValidationResultItem(ESeverity.exception, e.getMessage()).setSection(9).setPart(EPart.fx);
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    vri.setStacktrace(sw.toString());
                    this.context.addResultItem(vri);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    public void setStringContent(String xml) {
        this.zfXML = xml;
    }

    public static boolean matchesURI(String uri1, String uri2) {
        return uri1 != null && uri2 != null && (uri1.equals(uri2) || uri1.startsWith(uri2 + "#"));
    }

    public void disableNotices() {
        this.disableNotices = true;
    }

    @Override
    public void validate() throws IrrecoverableValidationError {
        long startXMLTime = Calendar.getInstance().getTimeInMillis();
        this.firedRules = 0;
        this.failedRules = 0;
        if (this.zfXML.isEmpty()) {
            ValidationResultItem res = new ValidationResultItem(ESeverity.exception, "XML data not found in " + this.filename + ": did you specify a pdf or xml file and does the xml file contain an embedded XML file?").setSection(3);
            this.context.addResultItem(res);
        } else {
            try {
                ESeverity XrechnungSeverity = ESeverity.notice;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(this.zfXML));
                Document doc = db.parse(is);
                Element root = doc.getDocumentElement();
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                XPathExpression expr = xpath.compile("(//*[local-name()=\"GuidelineSpecifiedDocumentContextParameter\"]/*[local-name()=\"ID\"])/text()|//*[local-name()=\"CustomizationID\"]/text()");
                NodeList ndList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                for (int bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
                    Node booking = ndList.item(bookingIndex);
                    this.context.setProfile(booking.getNodeValue());
                }
                boolean isOrderX = false;
                boolean isDespatchAdvice = false;
                boolean isMiniumum = false;
                boolean isBasic = false;
                boolean isBasicWithoutLines = false;
                boolean isEN16931 = false;
                boolean isExtended = false;
                boolean isXRechnung = false;
                String currentZFVersionDir = "ZF_233";
                int mainSchematronSectionErrorTypeCode = 4;
                Object xsltFilename = null;
                String rootLocalName = root.getLocalName();
                String contextProfile = this.context.getProfile();
                if ("SCRDMCCBDACIOMessageStructure".equalsIgnoreCase(rootLocalName)) {
                    this.context.setGeneration("1");
                    isOrderX = true;
                    isBasic = contextProfile.contains("basic");
                    isEN16931 = contextProfile.contains("comfort");
                    isExtended = contextProfile.contains("extended");
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B.xsd", 99, EPart.ox);
                    xsltFilename = "/xslt/OX_10/comfort/SCRDMCCBDACIOMessageStructure_100pD20B_COMFORT.xslt";
                } else if (root.getLocalName().equalsIgnoreCase("CrossIndustryInvoice")) {
                    this.context.setGeneration("2");
                    isMiniumum = contextProfile.contains("minimum");
                    isBasic = contextProfile.contains("basic");
                    isBasicWithoutLines = contextProfile.contains("basicwl");
                    if (isBasicWithoutLines) {
                        isBasic = false;
                    }
                    isEN16931 = Set.of("urn:cen.eu:en16931:2017:compliant:factur-x.eu:1p0:en16931", "urn:cen.eu:en16931:2017").stream().anyMatch(profile -> XMLValidator.matchesURI(contextProfile, profile));
                    isExtended = contextProfile.contains("extended");
                    isXRechnung = contextProfile.contains("xrechnung");
                    if (isExtended || isXRechnung) {
                        isEN16931 = false;
                    }
                    if (isMiniumum) {
                        LOGGER.debug("is Minimum");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/MINIMUM/FACTUR-X_MINIMUM.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_MINIMUM.xslt";
                    } else if (isBasicWithoutLines) {
                        LOGGER.debug("is Basic/WL");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/BASIC-WL/FACTUR-X_BASIC-WL.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_BASIC-WL.xslt";
                    } else if (isBasic) {
                        LOGGER.debug("is Basic");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/BASIC/FACTUR-X_BASIC.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_BASIC.xslt";
                    } else if (isEN16931) {
                        LOGGER.debug("is EN16931");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EN16931/FACTUR-X_EN16931.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_EN16931.xslt";
                    } else if (isXRechnung) {
                        LOGGER.debug("is XRechnung");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EN16931/FACTUR-X_EN16931.xsd", 18, EPart.fx);
                        XrechnungSeverity = ESeverity.error;
                    } else if (isExtended) {
                        LOGGER.debug("is EXTENDED");
                        this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), currentZFVersionDir + "/EXTENDED/FACTUR-X_EXTENDED.xsd", 18, EPart.fx);
                        xsltFilename = "/xslt/" + currentZFVersionDir + "/FACTUR-X_EXTENDED.xslt";
                    }
                } else if ("Invoice".equalsIgnoreCase(rootLocalName) || rootLocalName.equalsIgnoreCase("CreditNote")) {
                    this.context.setGeneration("2");
                    this.context.setFormat("UBL");
                    isXRechnung = contextProfile.contains("xrechnung");
                    LOGGER.debug("UBL");
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "UBL_21/maindoc/UBL-" + rootLocalName + "-2.1.xsd", 18, EPart.fx);
                    xsltFilename = "/xslt/en16931schematron/EN16931-UBL-validation.xslt";
                    mainSchematronSectionErrorTypeCode = 24;
                    if (isXRechnung) {
                        this.validateSchematron(this.zfXML, (String)xsltFilename, 24, ESeverity.error);
                        String xrVersion = contextProfile.substring(contextProfile.length() - 3).replace(".", "");
                        Set<String> supportedVersions = Set.of("12", "20", "21", "22", "23", "30");
                        if (!supportedVersions.contains(xrVersion)) {
                            throw new Exception("Unsupported XR version");
                        }
                        LOGGER.debug("is XRechnung v{}", (Object)xrVersion);
                        xsltFilename = "/xslt/XR_" + xrVersion + "/XRechnung-UBL-validation.xslt";
                        XrechnungSeverity = ESeverity.error;
                        mainSchematronSectionErrorTypeCode = 27;
                    }
                } else if ("CrossIndustryDocument".equalsIgnoreCase(rootLocalName)) {
                    this.context.setGeneration("1");
                    Set<String> validZF1Profiles = Set.of("urn:ferd:CrossIndustryDocument:invoice:1p0:basic", "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort", "urn:ferd:CrossIndustryDocument:invoice:1p0:extended");
                    if (validZF1Profiles.stream().noneMatch(profile -> XMLValidator.matchesURI(contextProfile, profile))) {
                        this.addUnsupportedProfileResultItem();
                    }
                    this.validateSchema(this.zfXML.getBytes(StandardCharsets.UTF_8), "ZF_10/ZUGFeRD1p0.xsd", 18, EPart.fx);
                    xsltFilename = "/xslt/ZUGFeRD_1p0.xslt";
                } else {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Unsupported root element").setSection(3).setPart(EPart.fx));
                }
                if ("CII".equals(this.context.getFormat())) {
                    if ("2".equals(this.context.getGeneration())) {
                        Set<String> validZF2Profiles = Set.of("urn:factur-x.eu:1p0:minimum", "urn:zugferd.de:2p0:minimum", "urn:factur-x.eu:1p0:basicwl", "urn:zugferd.de:2p0:basicwl", "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic", "urn:cen.eu:en16931:2017#compliant#urn:zugferd.de:2p0:basic", "urn:cen.eu:en16931:2017", "urn:cen.eu:en16931:2017#conformant#urn:factur-x.eu:1p0:extended", "urn:cen.eu:en16931:2017#conformant#urn:zugferd.de:2p0:extended");
                        if (validZF2Profiles.stream().noneMatch(profile -> XMLValidator.matchesURI(contextProfile, profile))) {
                            this.addUnsupportedProfileResultItem();
                        }
                    } else if (isOrderX) {
                        if (Set.of("urn:order-x.eu:1p0:basic", "urn:order-x.eu:1p0:comfort", "urn:order-x.eu:1p0:extended").stream().noneMatch(profile -> XMLValidator.matchesURI(contextProfile, profile))) {
                            this.addUnsupportedProfileResultItem();
                        }
                    } else if (Set.of("urn:ferd:CrossIndustryDocument:invoice:1p0:basic", "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort", "urn:ferd:CrossIndustryDocument:invoice:1p0:extended").stream().noneMatch(profile -> XMLValidator.matchesURI(contextProfile, profile))) {
                        this.addUnsupportedProfileResultItem();
                    }
                } else if (this.context.hasPDF()) {
                    ValidationResultItem vri = new ValidationResultItem(ESeverity.error, "Factur-X/ZUGFeRD and Order-X are always strictly CII only, no UBL allowed.").setSection(17).setPart(EPart.fx);
                    this.context.addResultItem(vri);
                }
                if (xsltFilename != null) {
                    this.validateSchematron(this.zfXML, (String)xsltFilename, mainSchematronSectionErrorTypeCode, ESeverity.error);
                }
                if ("CII".equals(this.context.getFormat()) && "2".equals(this.context.getGeneration())) {
                    if (isXRechnung) {
                        this.validateSchematron(this.zfXML, "/xslt/en16931schematron/EN16931-CII-validation.xslt", 24, ESeverity.error);
                    }
                    if ((isXRechnung || isBasic || isEN16931) && (!this.disableNotices || XrechnungSeverity != ESeverity.notice)) {
                        this.validateXR(this.zfXML, XrechnungSeverity);
                    }
                }
                this.checkArithmetics(this.context);
            }
            catch (IrrecoverableValidationError er) {
                throw er;
            }
            catch (Exception e) {
                ValidationResultItem vri = new ValidationResultItem(ESeverity.exception, e.getMessage()).setSection(22).setPart(EPart.fx);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                vri.setStacktrace(sw.toString());
                this.context.addResultItem(vri);
            }
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        this.context.addCustomXML(this.getInfoXml(endTime, startXMLTime));
    }

    private void addUnsupportedProfileResultItem() throws IrrecoverableValidationError {
        this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Unsupported profile type " + this.context.getProfile()).setSection(25).setPart(EPart.fx));
    }

    private String getInfoXml(long endTime, long startXMLTime) {
        String generation = this.context.getGeneration() != null ? this.context.getGeneration() : "invalid";
        String profile = this.context.getProfile() != null ? this.context.getProfile() : "invalid";
        String validatorVersion = XMLValidator.class.getPackage().getImplementationVersion();
        long duration = endTime - startXMLTime;
        return String.format("<info><version>%s</version><profile>%s</profile><validator version=\"%s\"></validator><rules><fired>%d</fired><failed>%d</failed></rules><duration unit=\"ms\">%d</duration></info>", generation, profile, validatorVersion, this.firedRules, this.failedRules, duration);
    }

    private void checkArithmetics(ValidationContext context) {
        ZUGFeRDInvoiceImporter zi = new ZUGFeRDInvoiceImporter();
        try {
            zi.fromXML(this.zfXML);
            CalculatedInvoice ci = new CalculatedInvoice();
            zi.extractInto((Invoice)ci);
        }
        catch (ArithmeticException e) {
            try {
                context.addResultItem(new ValidationResultItem(ESeverity.warning, "Arithmetical issue:" + e.getMessage()).setSection(10));
            }
            catch (IrrecoverableValidationError ie) {
                LOGGER.error(ie.getMessage(), (Throwable)ie);
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void validateXR(String xml, ESeverity errorImpact) throws IrrecoverableValidationError {
        if (xml.contains(":xrechnung_1.")) {
            this.validateSchematron(xml, "/xslt/XR_12/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.0")) {
            this.validateSchematron(xml, "/xslt/XR_20/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.1")) {
            this.validateSchematron(xml, "/xslt/XR_21/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.2")) {
            this.validateSchematron(xml, "/xslt/XR_22/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else if (xml.contains(":xrechnung_2.3")) {
            this.validateSchematron(xml, "/xslt/XR_23/XRechnung-CII-validation.xslt", 27, errorImpact);
        } else {
            this.validateSchematron(xml, "/xslt/XR_30/XRechnung-CII-validation.xslt", 27, errorImpact);
        }
    }

    public void validateSchematron(String xml, String xsltFilename, int section, ESeverity defaultSeverity) throws IrrecoverableValidationError {
        SchematronResourceXSLT aResSCH = null;
        aResSCH = SchematronResourceXSLT.fromClassPath((String)xsltFilename);
        if (aResSCH != null) {
            SchematronOutputType sout;
            if (!aResSCH.isValidSchematron()) {
                throw new IllegalArgumentException(xsltFilename + " is invalid Schematron!");
            }
            try {
                sout = aResSCH.applySchematronValidationToSVRL((Source)new StreamSource(new StringReader(xml)));
            }
            catch (Exception e) {
                throw new IrrecoverableValidationError(e.getMessage());
            }
            Document SVRLReport = new SVRLMarshaller().getAsDocument((Object)sout);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//*[local-name() = 'failed-assert']";
            NodeList failedAsserts = null;
            try {
                failedAsserts = (NodeList)xPath.compile(expression).evaluate(SVRLReport, XPathConstants.NODESET);
                String thisFailText = "";
                String thisFailID = "";
                Object thisFailIDStr = "";
                String thisFailTest = "";
                String thisFailLocation = "";
                if (failedAsserts.getLength() > 0) {
                    for (int nodeIndex = 0; nodeIndex < failedAsserts.getLength(); ++nodeIndex) {
                        Node failNode;
                        String failVal;
                        Node currentFailNode = failedAsserts.item(nodeIndex);
                        if (currentFailNode.getAttributes().getNamedItem("id") != null) {
                            thisFailID = currentFailNode.getAttributes().getNamedItem("id").getNodeValue();
                            thisFailIDStr = " [ID " + thisFailID + "]";
                        }
                        if (currentFailNode.getAttributes().getNamedItem("test") != null) {
                            thisFailTest = currentFailNode.getAttributes().getNamedItem("test").getNodeValue();
                        }
                        if (currentFailNode.getAttributes().getNamedItem("location") != null) {
                            thisFailLocation = currentFailNode.getAttributes().getNamedItem("location").getNodeValue();
                        }
                        String string = failVal = (failNode = currentFailNode.getAttributes().getNamedItem("flag")) == null ? null : failNode.getNodeValue();
                        ESeverity severity = defaultSeverity == ESeverity.notice ? defaultSeverity : ("warning".equals(failVal) ? ESeverity.warning : ("information".equals(failVal) ? ESeverity.notice : ESeverity.error));
                        NodeList failChilds = currentFailNode.getChildNodes();
                        for (int failChildIndex = 0; failChildIndex < failChilds.getLength(); ++failChildIndex) {
                            if (failChilds.item(failChildIndex).getLocalName() == null || !failChilds.item(failChildIndex).getLocalName().equals("text")) continue;
                            thisFailText = failChilds.item(failChildIndex).getTextContent();
                        }
                        LOGGER.info("FailedAssert {}", (Object)thisFailText);
                        this.context.addResultItem(new ValidationResultItem(severity, thisFailText + (String)thisFailIDStr + " from " + xsltFilename + ")").setLocation(thisFailLocation).setCriterion(thisFailTest).setSection(section).setID(thisFailID).setPart(EPart.fx));
                        ++this.failedRules;
                    }
                }
            }
            catch (XPathExpressionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            expression = "//*[local-name() = 'fired-rule']";
            NodeList firedAsserts = null;
            try {
                firedAsserts = (NodeList)xPath.compile(expression).evaluate(SVRLReport, XPathConstants.NODESET);
                this.firedRules = firedAsserts.getLength();
            }
            catch (XPathExpressionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (this.firedRules == 0) {
                this.context.addResultItem(new ValidationResultItem(ESeverity.error, "No rules matched, XML too minimal?").setSection(26).setPart(EPart.fx));
            }
        }
    }

    public int getFiredRules() {
        return this.firedRules;
    }

    public int getFailedRules() {
        return this.failedRules;
    }
}

