/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mustangproject.BankDetails;
import org.mustangproject.Contact;
import org.mustangproject.DirectDebit;
import org.mustangproject.LegalOrganisation;
import org.mustangproject.SchemedID;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableContact;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDLegalOrganisation;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TradeParty
implements IZUGFeRDExportableTradeParty {
    protected String name;
    protected String zip;
    protected String street;
    protected String location;
    protected String country;
    protected String taxScheme;
    protected String taxID = null;
    protected String vatID = null;
    protected String ID = null;
    protected String description = null;
    protected String additionalAddress = null;
    protected String additionalAddressExtension = null;
    protected List<BankDetails> bankDetails = new ArrayList<BankDetails>();
    protected List<DirectDebit> debitDetails = new ArrayList<DirectDebit>();
    protected Contact contact = null;
    protected LegalOrganisation legalOrg = null;
    protected SchemedID globalId = null;
    protected SchemedID uriUniversalCommunicationId = null;

    public TradeParty() {
    }

    public TradeParty(String name, String street, String zip, String location, String country) {
        this.name = name;
        this.street = street;
        this.zip = zip;
        this.location = location;
        this.country = country;
    }

    protected void parseFromUBL(NodeList nodes) {
        if (nodes.getLength() > 0) {
            for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
                Node currentItemNode = nodes.item(nodeIndex);
                if (currentItemNode.getLocalName() == null) continue;
                String currentUBLChild = currentItemNode.getLocalName();
                if (currentUBLChild.equals("Party")) {
                    NodeList party = currentItemNode.getChildNodes();
                    for (int partyIndex = 0; partyIndex < party.getLength(); ++partyIndex) {
                        Node currentNode;
                        if (party.item(partyIndex).getLocalName() == null) continue;
                        String currentTopElementName = party.item(partyIndex).getLocalName();
                        if (currentTopElementName.equals("PartyName")) {
                            NodeList partyName = party.item(partyIndex).getChildNodes();
                            for (int partyNameIndex = 0; partyNameIndex < partyName.getLength(); ++partyNameIndex) {
                                if (partyName.item(partyNameIndex).getLocalName() == null || !partyName.item(partyNameIndex).getLocalName().equals("Name")) continue;
                                this.setName(partyName.item(partyNameIndex).getTextContent());
                            }
                        }
                        if (party.item(partyIndex).getLocalName().equals("EndpointID") && (currentNode = party.item(partyIndex)).getAttributes() != null && currentNode.getAttributes().getNamedItem("schemeID") != null && party.item(partyIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("EM")) {
                            this.setEmail(currentNode.getTextContent());
                        }
                        if (currentTopElementName.equals("PartyIdentification")) {
                            NodeList partyID = party.item(partyIndex).getChildNodes();
                            for (int partyIDIndex = 0; partyIDIndex < partyID.getLength(); ++partyIDIndex) {
                                if (partyID.item(partyIDIndex).getLocalName() == null || !partyID.item(partyIDIndex).getLocalName().equals("ID")) continue;
                                Node currentNode2 = partyID.item(partyIDIndex);
                                if (currentNode2.getAttributes() != null && currentNode2.getAttributes().getNamedItem("schemeID") != null) {
                                    SchemedID sID = new SchemedID().setScheme(currentNode2.getAttributes().getNamedItem("schemeID").getTextContent()).setId(currentNode2.getTextContent());
                                    this.addGlobalID(sID);
                                    continue;
                                }
                                this.setID(currentNode2.getTextContent());
                            }
                        }
                        if (currentTopElementName.equals("PartyTaxScheme")) {
                            NodeList partyTaxScheme = party.item(partyIndex).getChildNodes();
                            String CompanyId = null;
                            for (int partyTaxSchemeIndex = 0; partyTaxSchemeIndex < partyTaxScheme.getLength(); ++partyTaxSchemeIndex) {
                                if (partyTaxScheme.item(partyTaxSchemeIndex).getLocalName() == null) continue;
                                if (partyTaxScheme.item(partyTaxSchemeIndex).getLocalName().equals("CompanyID")) {
                                    CompanyId = partyTaxScheme.item(partyTaxSchemeIndex).getTextContent();
                                }
                                if (!partyTaxScheme.item(partyTaxSchemeIndex).getLocalName().equals("TaxScheme")) continue;
                                NodeList taxSchemechilds = partyTaxScheme.item(partyTaxSchemeIndex).getChildNodes();
                                for (int taxSchemechildsIndex = 0; taxSchemechildsIndex < taxSchemechilds.getLength(); ++taxSchemechildsIndex) {
                                    if (taxSchemechilds.item(taxSchemechildsIndex).getLocalName() == null) continue;
                                    Set<String> taxSchemeTypes = Set.of("FC", "NOVAT");
                                    String textContent = taxSchemechilds.item(taxSchemechildsIndex).getTextContent();
                                    if (textContent != null && taxSchemeTypes.contains(textContent)) {
                                        this.setTaxID(CompanyId);
                                        continue;
                                    }
                                    this.setVATID(CompanyId);
                                }
                            }
                        }
                        if (currentTopElementName.equals("PartyLegalEntity")) {
                            NodeList legal = party.item(partyIndex).getChildNodes();
                            LegalOrganisation lo = null;
                            for (int legalChildIndex = 0; legalChildIndex < legal.getLength(); ++legalChildIndex) {
                                if (legal.item(legalChildIndex).getLocalName() == null) continue;
                                if (legal.item(legalChildIndex).getLocalName().equals("RegistrationName")) {
                                    if (lo == null) {
                                        lo = new LegalOrganisation();
                                    }
                                    lo.setTradingBusinessName(legal.item(legalChildIndex).getTextContent());
                                }
                                if (legal.item(legalChildIndex).getLocalName().equals("CompanyLegalForm")) {
                                    this.setDescription(legal.item(legalChildIndex).getTextContent());
                                }
                                if (legal.item(legalChildIndex).getLocalName().equals("CompanyID")) {
                                    if (lo == null) {
                                        lo = new LegalOrganisation();
                                    }
                                    if (legal.item(legalChildIndex).getAttributes().getNamedItem("schemeID") != null) {
                                        SchemedID sid = new SchemedID(legal.item(legalChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue(), legal.item(legalChildIndex).getTextContent());
                                        lo.setSchemedID(sid);
                                    }
                                }
                                if (lo == null) continue;
                                this.setLegalOrganisation(lo);
                            }
                        }
                        if (currentTopElementName.equals("PostalAddress")) {
                            NodeList postal = party.item(partyIndex).getChildNodes();
                            for (int postalChildIndex = 0; postalChildIndex < postal.getLength(); ++postalChildIndex) {
                                if (postal.item(postalChildIndex).getLocalName() == null) continue;
                                if (postal.item(postalChildIndex).getLocalName().equals("StreetName")) {
                                    this.setStreet(postal.item(postalChildIndex).getTextContent());
                                }
                                if (postal.item(postalChildIndex).getLocalName().equals("AdditionalStreetName")) {
                                    this.setAdditionalAddress(postal.item(postalChildIndex).getTextContent());
                                }
                                if (postal.item(postalChildIndex).getLocalName().equals("CityName")) {
                                    this.setLocation(postal.item(postalChildIndex).getTextContent());
                                }
                                if (postal.item(postalChildIndex).getLocalName().equals("PostalZone")) {
                                    this.setZIP(postal.item(postalChildIndex).getTextContent());
                                }
                                if (postal.item(postalChildIndex).getLocalName().equals("Country")) {
                                    NodeList country = postal.item(postalChildIndex).getChildNodes();
                                    for (int countryIndex = 0; countryIndex < country.getLength(); ++countryIndex) {
                                        if (country.item(countryIndex).getLocalName() == null || !country.item(countryIndex).getLocalName().equals("IdentificationCode")) continue;
                                        this.setCountry(country.item(countryIndex).getTextContent());
                                    }
                                }
                                if (postal.item(postalChildIndex).getLocalName().equals("AddressLine")) {
                                    NodeList AddressLine = postal.item(postalChildIndex).getChildNodes();
                                    for (int lineIndex = 0; lineIndex < AddressLine.getLength(); ++lineIndex) {
                                        if (AddressLine.item(lineIndex).getLocalName() == null || !AddressLine.item(lineIndex).getLocalName().equals("Line")) continue;
                                        this.setAdditionalAddressExtension(AddressLine.item(lineIndex).getTextContent());
                                    }
                                }
                                if (!postal.item(postalChildIndex).getLocalName().equals("Name")) continue;
                                this.setName(postal.item(postalChildIndex).getTextContent());
                            }
                        }
                        if (!currentTopElementName.equals("Contact")) continue;
                        NodeList contact = party.item(partyIndex).getChildNodes();
                        this.setContact(new Contact(contact));
                    }
                }
                if (currentUBLChild.equals("GlobalID") && nodes.item(nodeIndex).getAttributes().getNamedItem("schemeID") != null) {
                    SchemedID gid = new SchemedID().setScheme(nodes.item(nodeIndex).getAttributes().getNamedItem("schemeID").getNodeValue()).setId(nodes.item(nodeIndex).getTextContent());
                    this.addGlobalID(gid);
                }
                if (!currentUBLChild.equals("DefinedTradeContact")) continue;
                NodeList contact = nodes.item(nodeIndex).getChildNodes();
                this.setContact(new Contact(contact));
            }
        }
    }

    public TradeParty(NodeList nodes) {
        if (nodes.getLength() > 0) {
            for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
                String topElementName = nodes.item(nodeIndex).getLocalName();
                if (topElementName.equals("Party")) {
                    this.parseFromUBL(nodes);
                    return;
                }
                Node currentItemNode = nodes.item(nodeIndex);
                NodeList itemChilds = currentItemNode.getChildNodes();
                for (int itemChildIndex = 0; itemChildIndex < itemChilds.getLength(); ++itemChildIndex) {
                    if (itemChilds.item(itemChildIndex).getLocalName() == null) continue;
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("ID")) {
                        this.setID(itemChilds.item(itemChildIndex).getTextContent());
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("Name")) {
                        this.setName(itemChilds.item(itemChildIndex).getTextContent());
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("Description")) {
                        this.setDescription(itemChilds.item(itemChildIndex).getTextContent());
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("GlobalID") && itemChilds.item(itemChildIndex).getAttributes().getNamedItem("schemeID") != null) {
                        SchemedID gid = new SchemedID().setScheme(itemChilds.item(itemChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue()).setId(itemChilds.item(itemChildIndex).getTextContent());
                        this.addGlobalID(gid);
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("SpecifiedLegalOrganization")) {
                        NodeList organization = itemChilds.item(itemChildIndex).getChildNodes();
                        this.setLegalOrganisation(new LegalOrganisation(organization));
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("DefinedTradeContact")) {
                        NodeList contact = itemChilds.item(itemChildIndex).getChildNodes();
                        this.setContact(new Contact(contact));
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("PostalTradeAddress")) {
                        NodeList postal = itemChilds.item(itemChildIndex).getChildNodes();
                        for (int postalChildIndex = 0; postalChildIndex < postal.getLength(); ++postalChildIndex) {
                            if (postal.item(postalChildIndex).getLocalName() == null) continue;
                            if (postal.item(postalChildIndex).getLocalName().equals("LineOne")) {
                                this.setStreet(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("LineTwo")) {
                                this.setAdditionalAddress(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("LineThree")) {
                                this.setAdditionalAddressExtension(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("CityName")) {
                                this.setLocation(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("PostcodeCode")) {
                                this.setZIP(postal.item(postalChildIndex).getTextContent());
                            }
                            if (!postal.item(postalChildIndex).getLocalName().equals("CountryID")) continue;
                            this.setCountry(postal.item(postalChildIndex).getTextContent());
                        }
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("URIUniversalCommunication")) {
                        NodeList URIchilds = itemChilds.item(itemChildIndex).getChildNodes();
                        for (int URIChildIndex = 0; URIChildIndex < URIchilds.getLength(); ++URIChildIndex) {
                            Node currentNode = URIchilds.item(URIChildIndex);
                            if (currentNode.getLocalName() == null || !currentNode.getLocalName().equals("URIID") || currentNode.getAttributes().getNamedItem("schemeID") == null || !URIchilds.item(URIChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("EM")) continue;
                            this.setEmail(currentNode.getTextContent());
                        }
                    }
                    if (!itemChilds.item(itemChildIndex).getLocalName().equals("SpecifiedTaxRegistration")) continue;
                    NodeList taxChilds = itemChilds.item(itemChildIndex).getChildNodes();
                    for (int taxChildIndex = 0; taxChildIndex < taxChilds.getLength(); ++taxChildIndex) {
                        Node firstChild;
                        if (taxChilds.item(taxChildIndex).getLocalName() == null || !taxChilds.item(taxChildIndex).getLocalName().equals("ID") || taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID") == null || (firstChild = taxChilds.item(taxChildIndex).getFirstChild()) == null) continue;
                        if (taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("VA")) {
                            this.setVATID(firstChild.getNodeValue());
                        }
                        if (!taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("FC")) continue;
                        this.setTaxID(firstChild.getNodeValue());
                    }
                }
            }
        }
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public String getGlobalID() {
        if (this.globalId != null) {
            return this.globalId.getID();
        }
        return null;
    }

    @Override
    public String getGlobalIDScheme() {
        if (this.globalId != null) {
            return this.globalId.getScheme();
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getUriUniversalCommunicationID() {
        if (this.uriUniversalCommunicationId != null) {
            return this.uriUniversalCommunicationId.getID();
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getUriUniversalCommunicationIDScheme() {
        if (this.uriUniversalCommunicationId != null) {
            return this.uriUniversalCommunicationId.getScheme();
        }
        return null;
    }

    public TradeParty setEmail(String eMail) {
        SchemedID theSchemedID = new SchemedID("EM", eMail);
        this.addUriUniversalCommunicationID(theSchemedID);
        return this;
    }

    public TradeParty setID(String ID2) {
        this.ID = ID2;
        return this;
    }

    public TradeParty setContact(Contact c) {
        this.contact = c;
        return this;
    }

    public TradeParty setGlobalID(String ID2) {
        if (this.globalId == null) {
            this.globalId = new SchemedID();
        }
        this.globalId.setId(ID2);
        return this;
    }

    public TradeParty setGlobalIDScheme(String scheme) {
        if (this.globalId == null) {
            this.globalId = new SchemedID();
        }
        this.globalId.setScheme(scheme);
        return this;
    }

    public TradeParty addGlobalID(SchemedID schemedID) {
        this.globalId = schemedID;
        return this;
    }

    public TradeParty addUriUniversalCommunicationID(SchemedID schemedID) {
        this.uriUniversalCommunicationId = schemedID;
        return this;
    }

    public TradeParty addBankDetails(BankDetails s) {
        this.bankDetails.add(s);
        return this;
    }

    public TradeParty addDebitDetails(DirectDebit debitDetail) {
        this.debitDetails.add(debitDetail);
        return this;
    }

    public List<DirectDebit> getDebitDetails() {
        return this.debitDetails;
    }

    @Override
    public IZUGFeRDLegalOrganisation getLegalOrganisation() {
        return this.legalOrg;
    }

    public TradeParty setLegalOrganisation(LegalOrganisation legalOrganisation) {
        this.legalOrg = legalOrganisation;
        return this;
    }

    public List<BankDetails> getBankDetails() {
        return this.bankDetails;
    }

    public TradeParty addTaxID(String taxID) {
        this.taxID = taxID;
        return this;
    }

    public TradeParty addVATID(String vatID) {
        this.vatID = vatID;
        return this;
    }

    @Override
    public String getVATID() {
        return this.vatID;
    }

    public TradeParty setVATID(String VATid) {
        this.vatID = VATid;
        return this;
    }

    @Override
    public String getTaxID() {
        return this.taxID;
    }

    public TradeParty setTaxID(String tax) {
        this.taxID = tax;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TradeParty setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public TradeParty setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getZIP() {
        return this.zip;
    }

    public TradeParty setZIP(String zip) {
        this.zip = zip;
        return this;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    public TradeParty setStreet(String street) {
        this.street = street;
        return this;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public TradeParty setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public TradeParty setCountry(String country) {
        this.country = country;
        return this;
    }

    public String getVatID() {
        return this.vatID;
    }

    @Override
    public IZUGFeRDExportableContact getContact() {
        return this.contact;
    }

    @JsonIgnore
    public IZUGFeRDTradeSettlement[] getAsTradeSettlement() {
        if (this.bankDetails.isEmpty() && this.debitDetails.isEmpty()) {
            return null;
        }
        List tradeSettlements = Stream.concat(this.bankDetails.stream(), this.debitDetails.stream()).collect(Collectors.toList());
        IZUGFeRDTradeSettlement[] result = new IZUGFeRDTradeSettlement[tradeSettlements.size()];
        for (int i = 0; i < tradeSettlements.size(); ++i) {
            IZUGFeRDTradeSettlement izugFeRDTradeSettlement;
            result[i] = izugFeRDTradeSettlement = (IZUGFeRDTradeSettlement)tradeSettlements.get(i);
        }
        return result;
    }

    @Override
    public String getAdditionalAddress() {
        return this.additionalAddress;
    }

    public TradeParty setAdditionalAddress(String additionalAddress) {
        this.additionalAddress = additionalAddress;
        return this;
    }

    public TradeParty setAdditionalAddress(String additionalAddress1, String additionalAddress2) {
        this.additionalAddress = additionalAddress1;
        this.additionalAddressExtension = additionalAddress2;
        return this;
    }

    public TradeParty setAdditionalAddressExtension(String additionalAddress2) {
        this.additionalAddressExtension = additionalAddress2;
        return this;
    }

    @Override
    public String getAdditionalAddressExtension() {
        return this.additionalAddressExtension;
    }
}

