/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.NativeTextPainter;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextUtil;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTGlyphVector;

class PDFTextPainter
extends NativeTextPainter {
    private static final int[] PA_ZERO = new int[4];
    private PDFGraphics2D pdf;
    private PDFTextUtil textUtil;
    private double prevVisibleGlyphWidth;
    private boolean repositionNextGlyph;

    public PDFTextPainter(FontInfo fi) {
        super(fi);
    }

    @Override
    protected boolean isSupported(Graphics2D g2d) {
        return g2d instanceof PDFGraphics2D;
    }

    @Override
    protected void preparePainting(Graphics2D g2d) {
        this.pdf = (PDFGraphics2D)g2d;
    }

    @Override
    protected void saveGraphicsState() {
        this.pdf.saveGraphicsState();
    }

    @Override
    protected void restoreGraphicsState() {
        this.pdf.restoreGraphicsState();
    }

    @Override
    protected void setInitialTransform(AffineTransform transform) {
        this.createTextUtil();
        this.textUtil.concatMatrix(transform);
    }

    private void createTextUtil() {
        this.textUtil = new PDFTextUtil(this.pdf.fontInfo){

            @Override
            protected void write(String code) {
                ((PDFTextPainter)PDFTextPainter.this).pdf.currentStream.write(code);
            }

            @Override
            protected void write(StringBuffer code) {
                ((PDFTextPainter)PDFTextPainter.this).pdf.currentStream.append(code);
            }
        };
    }

    @Override
    protected void clip(Shape clip) {
        this.pdf.writeClip(clip);
    }

    @Override
    protected void writeGlyphs(FOPGVTGlyphVector gv, GeneralPath debugShapes) throws IOException {
        if (gv.getGlyphPositionAdjustments() == null) {
            super.writeGlyphs(gv, debugShapes);
        } else {
            Point2D prevPos = null;
            AffineTransform prevGlyphTransform = null;
            this.font = ((FOPGVTFont)gv.getFont()).getFont();
            int[][] glyphPositionAdjustments = gv.getGlyphPositionAdjustments();
            double glyphXPos = 0.0;
            double glyphYPos = 0.0;
            double prevAdjustedGlyphXPos = 0.0;
            double prevAdjustedGlyphYPos = 0.0;
            for (int index = 0; index < gv.getNumGlyphs(); ++index) {
                int[] positionAdjust;
                if (!gv.isGlyphVisible(index)) continue;
                Point2D glyphPos = gv.getGlyphPosition(index);
                AffineTransform glyphTransform = gv.getGlyphTransform(index);
                int[] nArray = positionAdjust = index > glyphPositionAdjustments.length || glyphPositionAdjustments[index] == null ? PA_ZERO : glyphPositionAdjustments[index];
                if (log.isTraceEnabled()) {
                    log.trace("pos " + glyphPos + ", transform " + glyphTransform);
                }
                this.positionGlyph(prevPos, glyphPos, glyphTransform != null || prevGlyphTransform != null);
                char glyph = (char)gv.getGlyphCode(index);
                double adjustedGlyphXPos = glyphXPos + (double)positionAdjust[0];
                double adjustedGlyphYPos = glyphYPos + (double)positionAdjust[1];
                double tdXPos = (adjustedGlyphXPos - prevAdjustedGlyphXPos) / 1000.0;
                double tdYPos = (adjustedGlyphYPos - prevAdjustedGlyphYPos) / 1000.0;
                this.textUtil.writeTd(tdXPos, tdYPos);
                this.writeGlyph(glyph, this.getLocalTransform(glyphPos, glyphTransform));
                prevPos = glyphPos;
                prevGlyphTransform = glyphTransform;
                glyphXPos = glyphPos.getX() + (double)positionAdjust[2];
                glyphYPos = glyphPos.getY() + (double)positionAdjust[3];
                prevAdjustedGlyphXPos = adjustedGlyphXPos;
                prevAdjustedGlyphYPos = adjustedGlyphYPos;
            }
        }
    }

    @Override
    protected void beginTextObject() {
        this.applyColorAndPaint(this.tpi);
        this.textUtil.beginTextObject();
        boolean stroke = this.tpi.strokePaint != null && this.tpi.strokeStroke != null;
        this.textUtil.setTextRenderingMode(this.tpi.fillPaint != null, stroke, false);
    }

    @Override
    protected void endTextObject() {
        this.textUtil.writeTJ();
        this.textUtil.endTextObject();
    }

    private void applyColorAndPaint(TextPaintInfo tpi) {
        Color col;
        Paint fillPaint = tpi.fillPaint;
        Paint strokePaint = tpi.strokePaint;
        Stroke stroke = tpi.strokeStroke;
        int fillAlpha = 255;
        int strokeAlpha = 255;
        if (fillPaint instanceof Color) {
            col = (Color)fillPaint;
            this.pdf.applyColor(col, true);
            fillAlpha = col.getAlpha();
        }
        if (strokePaint instanceof Color) {
            col = (Color)strokePaint;
            this.pdf.applyColor(col, false);
            strokeAlpha = col.getAlpha();
        }
        this.pdf.applyPaint(fillPaint, true);
        this.pdf.applyStroke(stroke);
        if (strokePaint != null) {
            this.pdf.applyPaint(strokePaint, false);
        }
        this.pdf.applyAlpha(fillAlpha, strokeAlpha);
    }

    @Override
    protected void positionGlyph(Point2D prevPos, Point2D glyphPos, boolean reposition) {
        double xdiff;
        double effxdiff;
        boolean bl = this.repositionNextGlyph = prevPos == null || prevPos.getY() != glyphPos.getY() || reposition;
        if (!this.repositionNextGlyph && (effxdiff = 1000.0 * (xdiff = glyphPos.getX() - prevPos.getX()) - this.prevVisibleGlyphWidth) != 0.0) {
            double adjust = -effxdiff / (double)this.font.getFontSize();
            this.textUtil.adjustGlyphTJ(adjust * 1000.0);
        }
    }

    @Override
    protected void writeGlyph(char glyph, AffineTransform transform) {
        this.prevVisibleGlyphWidth = this.font.getWidth(glyph);
        boolean encodingChanging = false;
        if (!this.textUtil.isMultiByteFont(this.font.getFontName())) {
            int encoding = glyph / 256;
            glyph = (char)(glyph % 256);
            if (this.textUtil.getCurrentEncoding() != encoding) {
                this.textUtil.setCurrentEncoding(encoding);
                encodingChanging = true;
            }
        }
        if (this.repositionNextGlyph || encodingChanging) {
            this.textUtil.writeTJ();
            if (this.font != this.textUtil.getCurrentFont() || encodingChanging) {
                this.textUtil.setCurrentFont(this.font);
                this.textUtil.writeTf(this.font);
            }
            this.textUtil.writeTextMatrix(transform);
        }
        this.textUtil.writeTJMappedChar(glyph);
    }
}

