/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.sch;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.sch.SchematronProviderXSLTFromSCH;
import com.helger.schematron.sch.TransformerCustomizerSCH;
import com.helger.xml.serialize.write.XMLWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SchematronResourceSCHCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceSCHCache.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, SchematronProviderXSLTFromSCH> MAP = new CommonsHashMap<String, SchematronProviderXSLTFromSCH>();

    private SchematronResourceSCHCache() {
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSCH transformerCustomizerSCH) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiling Schematron instance " + iReadableResource.toString());
        }
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = new SchematronProviderXSLTFromSCH(iReadableResource, transformerCustomizerSCH);
        schematronProviderXSLTFromSCH.convertSchematronToXSLT();
        if (!schematronProviderXSLTFromSCH.isValidSchematron()) {
            LOGGER.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (LOGGER.isDebugEnabled() && schematronProviderXSLTFromSCH.getXSLTDocument() != null) {
                LOGGER.debug("  Created XSLT document:\n" + XMLWriter.getNodeAsString(schematronProviderXSLTFromSCH.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSCH.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished compiling Schematron instance " + iReadableResource.toString());
        }
        return schematronProviderXSLTFromSCH;
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSCH transformerCustomizerSCH) {
        ValueEnforcer.notNull(iReadableResource, "SchematronResource");
        ValueEnforcer.notNull(transformerCustomizerSCH, "TransformerCustomizer");
        if (!iReadableResource.exists()) {
            LOGGER.warn("Schematron resource " + String.valueOf(iReadableResource) + " does not exist!");
            return null;
        }
        if (!transformerCustomizerSCH.canCacheResult()) {
            return SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, transformerCustomizerSCH);
        }
        String string = StringHelper.getImploded(':', new String[]{iReadableResource.getResourceID(), StringHelper.getNotNull(transformerCustomizerSCH.getPhase()), StringHelper.getNotNull(transformerCustomizerSCH.getLanguageCode())});
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = RW_LOCK.readLockedGet(() -> (SchematronProviderXSLTFromSCH)MAP.get(string));
        if (schematronProviderXSLTFromSCH == null && (schematronProviderXSLTFromSCH = RW_LOCK.writeLockedGet(() -> (SchematronProviderXSLTFromSCH)MAP.get(string))) == null) {
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH2 = SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, transformerCustomizerSCH);
            if (schematronProviderXSLTFromSCH2 != null) {
                RW_LOCK.writeLocked(() -> MAP.put(string, schematronProviderXSLTFromSCH2));
            }
            schematronProviderXSLTFromSCH = schematronProviderXSLTFromSCH2;
        }
        return schematronProviderXSLTFromSCH;
    }

    public static void clearCache() {
        RW_LOCK.writeLocked(MAP::clear);
    }
}

