/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.en16931.cii2ubl.AbstractCIIToUBLConverter;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AddressLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CardAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentMandateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PayableRoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PrimaryAccountNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.creditnote_22.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_22.InvoiceType;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.CreditorFinancialAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.CreditorFinancialInstitutionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DebtorFinancialAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DocumentLineDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentContextType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LegalOrganizationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.NoteType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProcuringProjectType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductCharacteristicType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductClassificationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ReferencedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SpecifiedPeriodType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainEventType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeLineItemType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TaxRegistrationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAccountingAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAddressType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAllowanceChargeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeContactType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeCountryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePartyType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePaymentTermsType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePriceType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeProductType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementFinancialCardType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementHeaderMonetarySummationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementLineMonetarySummationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementPaymentMeansType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeTaxType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.UniversalCommunicationType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;

public class CIIToUBL22Converter
extends AbstractCIIToUBLConverter<CIIToUBL22Converter> {
    private static final String UBL_VERSION = "2.2";

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType _copyID(@Nullable IDType iDType) {
        return CIIToUBL22Converter.copyID(iDType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType());
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType _copyNote(@Nullable NoteType noteType) {
        if (noteType == null) {
            return null;
        }
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType noteType2 = new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType();
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(noteType.getSubjectCodeValue())) {
            stringBuilder.append('#').append(noteType.getSubjectCodeValue()).append('#');
        }
        boolean bl = true;
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : noteType.getContent()) {
            if (stringBuilder.length() > 0 && !bl) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(textType.getValue());
            bl = false;
        }
        noteType2.setValue(stringBuilder.toString());
        return noteType2;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType _copyNote(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType) {
        return CIIToUBL22Converter.copyName(textType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType());
    }

    @Nullable
    private static DocumentReferenceType _convertDocumentReference(@Nullable ReferencedDocumentType referencedDocumentType, @Nonnull IErrorList iErrorList) {
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        FormattedDateTimeType formattedDateTimeType;
        if (referencedDocumentType == null) {
            return null;
        }
        String string = referencedDocumentType.getIssuerAssignedIDValue();
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(string).setSchemeID(referencedDocumentType.getReferenceTypeCodeValue());
        if (CIIToUBL22Converter.isValidDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue())) {
            documentReferenceType.setDocumentTypeCode(referencedDocumentType.getTypeCodeValue());
        }
        if ((formattedDateTimeType = referencedDocumentType.getFormattedIssueDateTime()) != null) {
            documentReferenceType.setIssueDate(CIIToUBL22Converter.parseDate(formattedDateTimeType.getDateTimeString(), iErrorList));
        }
        Object object = referencedDocumentType.getName().iterator();
        while (object.hasNext()) {
            iExplicitlyCloneable2 = object.next();
            iExplicitlyCloneable = new DocumentDescriptionType();
            ((TextType)iExplicitlyCloneable).setValue(((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2).getValue());
            ((TextType)iExplicitlyCloneable).setLanguageID(((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2).getLanguageID());
            ((TextType)iExplicitlyCloneable).setLanguageLocaleID(((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2).getLanguageLocaleID());
            documentReferenceType.addDocumentDescription((DocumentDescriptionType)iExplicitlyCloneable);
        }
        if (referencedDocumentType.getAttachmentBinaryObjectCount() > 0) {
            object = referencedDocumentType.getAttachmentBinaryObjectAtIndex(0);
            iExplicitlyCloneable2 = new AttachmentType();
            iExplicitlyCloneable = new EmbeddedDocumentBinaryObjectType();
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setMimeCode(((BinaryObjectType)object).getMimeCode());
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setFilename(((BinaryObjectType)object).getFilename());
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setValue(((BinaryObjectType)object).getValue());
            ((AttachmentType)iExplicitlyCloneable2).setEmbeddedDocumentBinaryObject((EmbeddedDocumentBinaryObjectType)iExplicitlyCloneable);
            documentReferenceType.setAttachment((AttachmentType)iExplicitlyCloneable2);
        }
        if (StringHelper.hasText((String)(object = referencedDocumentType.getURIIDValue()))) {
            iExplicitlyCloneable2 = documentReferenceType.getAttachment();
            if (iExplicitlyCloneable2 == null) {
                iExplicitlyCloneable2 = new AttachmentType();
                documentReferenceType.setAttachment((AttachmentType)iExplicitlyCloneable2);
            }
            iExplicitlyCloneable = new ExternalReferenceType();
            ((ExternalReferenceType)iExplicitlyCloneable).setURI((String)object);
            ((AttachmentType)iExplicitlyCloneable2).setExternalReference((ExternalReferenceType)iExplicitlyCloneable);
        }
        return documentReferenceType;
    }

    @Nonnull
    private static AddressType _convertPostalAddress(@Nonnull TradeAddressType tradeAddressType) {
        IExplicitlyCloneable iExplicitlyCloneable;
        AddressType addressType = new AddressType();
        if (StringHelper.hasText(tradeAddressType.getLineOneValue())) {
            addressType.setStreetName(tradeAddressType.getLineOneValue());
        }
        if (StringHelper.hasText(tradeAddressType.getLineTwoValue())) {
            addressType.setAdditionalStreetName(tradeAddressType.getLineTwoValue());
        }
        if (StringHelper.hasText(tradeAddressType.getLineThreeValue())) {
            iExplicitlyCloneable = new AddressLineType();
            ((AddressLineType)iExplicitlyCloneable).setLine(tradeAddressType.getLineThreeValue());
            addressType.addAddressLine((AddressLineType)iExplicitlyCloneable);
        }
        if (StringHelper.hasText(tradeAddressType.getCityNameValue())) {
            addressType.setCityName(tradeAddressType.getCityNameValue());
        }
        if (StringHelper.hasText(tradeAddressType.getPostcodeCodeValue())) {
            addressType.setPostalZone(tradeAddressType.getPostcodeCodeValue());
        }
        if (tradeAddressType.hasCountrySubDivisionNameEntries()) {
            addressType.setCountrySubentity(tradeAddressType.getCountrySubDivisionNameAtIndex(0).getValue());
        }
        if (StringHelper.hasText(tradeAddressType.getCountryIDValue())) {
            iExplicitlyCloneable = new CountryType();
            ((CountryType)iExplicitlyCloneable).setIdentificationCode(tradeAddressType.getCountryIDValue());
            addressType.setCountry((CountryType)iExplicitlyCloneable);
        }
        return addressType;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType _extractFirstPartyID(@Nonnull TradePartyType tradePartyType) {
        IDType iDType = CIIToUBL22Converter.canUseGlobalID(tradePartyType) ? CIIToUBL22Converter.getAllUsableGlobalIDs(tradePartyType).getFirstOrNull() : (tradePartyType.hasIDEntries() ? tradePartyType.getIDAtIndex(0) : null);
        return iDType == null ? null : CIIToUBL22Converter._copyID(iDType);
    }

    private static void _extractAllPartyIDs(@Nonnull TradePartyType tradePartyType, @Nonnull Consumer<? super oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType> consumer) {
        if (CIIToUBL22Converter.canUseGlobalID(tradePartyType)) {
            CIIToUBL22Converter.getAllUsableGlobalIDs(tradePartyType).forEach(iDType -> consumer.accept(CIIToUBL22Converter._copyID(iDType)));
        } else {
            for (IDType iDType2 : tradePartyType.getID()) {
                consumer.accept(CIIToUBL22Converter._copyID(iDType2));
            }
        }
    }

    private static void _addPartyID(@Nullable oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType iDType, @Nonnull PartyType partyType) {
        if (iDType != null && !CollectionHelper.containsAny(partyType.getPartyIdentification(), partyIdentificationType -> EqualsHelper.equals(iDType, partyIdentificationType.getID()))) {
            PartyIdentificationType partyIdentificationType2 = new PartyIdentificationType();
            partyIdentificationType2.setID(iDType);
            partyType.addPartyIdentification(partyIdentificationType2);
        }
    }

    @Nonnull
    private static PartyType _convertParty(@Nonnull TradePartyType tradePartyType, boolean bl, boolean bl2) {
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        PartyType partyType = new PartyType();
        if (tradePartyType.hasURIUniversalCommunicationEntries()) {
            iExplicitlyCloneable2 = tradePartyType.getURIUniversalCommunicationAtIndex(0);
            partyType.setEndpointID(CIIToUBL22Converter.copyID(((UniversalCommunicationType)iExplicitlyCloneable2).getURIID(), new EndpointIDType()));
        }
        if (bl) {
            CIIToUBL22Converter._extractAllPartyIDs(tradePartyType, iDType -> CIIToUBL22Converter._addPartyID(iDType, partyType));
        } else {
            CIIToUBL22Converter._addPartyID(CIIToUBL22Converter._extractFirstPartyID(tradePartyType), partyType);
        }
        iExplicitlyCloneable2 = tradePartyType.getName();
        if (iExplicitlyCloneable2 != null && StringHelper.hasText(((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2).getValue())) {
            if (bl2) {
                iExplicitlyCloneable = new PartyLegalEntityType();
                ((PartyLegalEntityType)iExplicitlyCloneable).setRegistrationName(((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2).getValue());
                partyType.addPartyLegalEntity((PartyLegalEntityType)iExplicitlyCloneable);
            } else {
                iExplicitlyCloneable = new PartyNameType();
                ((PartyNameType)iExplicitlyCloneable).setName(CIIToUBL22Converter.copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2, new NameType()));
                if (((PartyNameType)iExplicitlyCloneable).getName() != null) {
                    partyType.addPartyName((PartyNameType)iExplicitlyCloneable);
                }
            }
        }
        if ((iExplicitlyCloneable = tradePartyType.getPostalTradeAddress()) != null) {
            partyType.setPostalAddress(CIIToUBL22Converter._convertPostalAddress((TradeAddressType)iExplicitlyCloneable));
        }
        return partyType;
    }

    @Nonnull
    private PartyTaxSchemeType _convertPartyTaxScheme(@Nonnull TaxRegistrationType taxRegistrationType) {
        if (taxRegistrationType.getID() == null) {
            return null;
        }
        PartyTaxSchemeType partyTaxSchemeType = new PartyTaxSchemeType();
        partyTaxSchemeType.setCompanyID(taxRegistrationType.getIDValue());
        String string = taxRegistrationType.getID().getSchemeID();
        if (StringHelper.hasNoText(string)) {
            string = this.getVATScheme();
        } else if ("VA".equals(string)) {
            string = this.getVATScheme();
        }
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        taxSchemeType.setID(string);
        partyTaxSchemeType.setTaxScheme(taxSchemeType);
        return partyTaxSchemeType;
    }

    private static void _convertPartyLegalEntity(@Nonnull TradePartyType tradePartyType, @Nonnull PartyType partyType) {
        PartyLegalEntityType partyLegalEntityType;
        if (partyType.hasPartyLegalEntityEntries()) {
            partyLegalEntityType = partyType.getPartyLegalEntityAtIndex(0);
        } else {
            partyLegalEntityType = new PartyLegalEntityType();
            partyType.addPartyLegalEntity(partyLegalEntityType);
        }
        LegalOrganizationType legalOrganizationType = tradePartyType.getSpecifiedLegalOrganization();
        if (legalOrganizationType != null) {
            if (StringHelper.hasText(legalOrganizationType.getTradingBusinessNameValue())) {
                PartyNameType partyNameType = new PartyNameType();
                partyNameType.setName(legalOrganizationType.getTradingBusinessNameValue());
                if (partyNameType.getName() != null) {
                    partyType.addPartyName(partyNameType);
                }
            }
            partyLegalEntityType.setCompanyID(CIIToUBL22Converter.copyID(legalOrganizationType.getID(), new CompanyIDType()));
        }
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePartyType.getDescription()) {
            if (!StringHelper.hasText(textType.getValue())) continue;
            partyLegalEntityType.setCompanyLegalForm(textType.getValue());
            break;
        }
        if (partyLegalEntityType.getRegistrationName() == null) {
            partyLegalEntityType.setRegistrationName(tradePartyType.getNameValue());
        }
    }

    @Nullable
    private static ContactType _convertContact(@Nonnull TradePartyType tradePartyType) {
        UniversalCommunicationType universalCommunicationType;
        UniversalCommunicationType universalCommunicationType2;
        if (!tradePartyType.hasDefinedTradeContactEntries()) {
            return null;
        }
        TradeContactType tradeContactType = tradePartyType.getDefinedTradeContactAtIndex(0);
        ContactType contactType = new ContactType();
        contactType.setName(CIIToUBL22Converter.copyName(tradeContactType.getPersonName(), new NameType()));
        if (contactType.getNameValue() == null) {
            contactType.setName(CIIToUBL22Converter.copyName(tradeContactType.getDepartmentName(), new NameType()));
        }
        if ((universalCommunicationType2 = tradeContactType.getTelephoneUniversalCommunication()) != null) {
            CIIToUBL22Converter.ifNotEmpty(universalCommunicationType2.getCompleteNumberValue(), contactType::setTelephone);
        }
        if ((universalCommunicationType = tradeContactType.getEmailURIUniversalCommunication()) != null) {
            CIIToUBL22Converter.ifNotEmpty(universalCommunicationType.getURIIDValue(), contactType::setElectronicMail);
        }
        if (contactType.getName() == null && contactType.getTelephone() == null && contactType.getElectronicMail() == null) {
            return null;
        }
        return contactType;
    }

    @Nullable
    private static AmountType _copyAmount(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType, @Nullable String string) {
        return CIIToUBL22Converter.copyAmount(amountType, new AmountType(), string);
    }

    private void _copyAllowanceCharge(@Nonnull TradeAllowanceChargeType tradeAllowanceChargeType, @Nonnull AllowanceChargeType allowanceChargeType, @Nullable String string) {
        if (StringHelper.hasText(tradeAllowanceChargeType.getReasonCodeValue())) {
            allowanceChargeType.setAllowanceChargeReasonCode(tradeAllowanceChargeType.getReasonCodeValue());
        }
        if (tradeAllowanceChargeType.getReason() != null) {
            AllowanceChargeReasonType allowanceChargeReasonType = new AllowanceChargeReasonType();
            allowanceChargeReasonType.setValue(tradeAllowanceChargeType.getReasonValue());
            allowanceChargeType.addAllowanceChargeReason(allowanceChargeReasonType);
        }
        if (tradeAllowanceChargeType.getCalculationPercent() != null) {
            allowanceChargeType.setMultiplierFactorNumeric(tradeAllowanceChargeType.getCalculationPercentValue());
        }
        if (tradeAllowanceChargeType.hasActualAmountEntries()) {
            allowanceChargeType.setAmount(CIIToUBL22Converter._copyAmount(tradeAllowanceChargeType.getActualAmountAtIndex(0), string));
        }
        allowanceChargeType.setBaseAmount(CIIToUBL22Converter.copyAmount(tradeAllowanceChargeType.getBasisAmount(), new BaseAmountType(), string));
        for (TradeTaxType tradeTaxType : tradeAllowanceChargeType.getCategoryTradeTax()) {
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes(tradeTaxType.getRateApplicablePercentValue()));
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            allowanceChargeType.addTaxCategory(taxCategoryType);
        }
    }

    private void _convertPaymentMeans(@Nonnull HeaderTradeSettlementType headerTradeSettlementType, @Nonnull TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType, @Nonnull Consumer<oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType> consumer, @Nonnull Consumer<PaymentMeansType> consumer2, @Nonnull ErrorList errorList) {
        boolean bl;
        boolean bl2;
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        boolean bl3;
        IExplicitlyCloneable iExplicitlyCloneable3;
        String string = tradeSettlementPaymentMeansType.getTypeCodeValue();
        PaymentMeansType paymentMeansType = new PaymentMeansType();
        PaymentMeansCodeType paymentMeansCodeType = new PaymentMeansCodeType();
        paymentMeansCodeType.setValue(string);
        if (tradeSettlementPaymentMeansType.hasInformationEntries()) {
            paymentMeansCodeType.setName(tradeSettlementPaymentMeansType.getInformationAtIndex(0).getValue());
        }
        paymentMeansType.setPaymentMeansCode(paymentMeansCodeType);
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : headerTradeSettlementType.getPaymentReference()) {
            iExplicitlyCloneable3 = new PaymentIDType();
            ((IdentifierType)iExplicitlyCloneable3).setValue(textType.getValue());
            paymentMeansType.addPaymentID((PaymentIDType)iExplicitlyCloneable3);
        }
        CreditorFinancialAccountType creditorFinancialAccountType = tradeSettlementPaymentMeansType.getPayeePartyCreditorFinancialAccount();
        boolean bl4 = bl3 = CIIToUBL22Converter.isPaymentMeansCodeCreditTransfer(string) && creditorFinancialAccountType != null;
        if (bl3) {
            iExplicitlyCloneable3 = new FinancialAccountType();
            ((FinancialAccountType)iExplicitlyCloneable3).setID(CIIToUBL22Converter._copyID(creditorFinancialAccountType.getIBANID()));
            if (((FinancialAccountType)iExplicitlyCloneable3).getID() == null) {
                ((FinancialAccountType)iExplicitlyCloneable3).setID(CIIToUBL22Converter._copyID(creditorFinancialAccountType.getProprietaryID()));
            }
            ((FinancialAccountType)iExplicitlyCloneable3).setName(CIIToUBL22Converter.copyName(creditorFinancialAccountType.getAccountName(), new NameType()));
            iExplicitlyCloneable2 = tradeSettlementPaymentMeansType.getPayeeSpecifiedCreditorFinancialInstitution();
            if (iExplicitlyCloneable2 != null) {
                iExplicitlyCloneable = new BranchType();
                ((BranchType)iExplicitlyCloneable).setID(CIIToUBL22Converter._copyID(((CreditorFinancialInstitutionType)iExplicitlyCloneable2).getBICID()));
                if (((BranchType)iExplicitlyCloneable).getID() != null) {
                    ((FinancialAccountType)iExplicitlyCloneable3).setFinancialInstitutionBranch((BranchType)iExplicitlyCloneable);
                }
            }
            paymentMeansType.setPayeeFinancialAccount((FinancialAccountType)iExplicitlyCloneable3);
        }
        if (bl2 = CIIToUBL22Converter.isPaymentMeansCodePaymentCard(string)) {
            iExplicitlyCloneable2 = tradeSettlementPaymentMeansType.getApplicableTradeSettlementFinancialCard();
            if (iExplicitlyCloneable2 == null) {
                errorList.add(CIIToUBL22Converter.buildError(null, "The element 'ApplicableTradeSettlementFinancialCard' is missing for Payment Card Information"));
            } else {
                iExplicitlyCloneable = new CardAccountType();
                ((CardAccountType)iExplicitlyCloneable).setPrimaryAccountNumberID(CIIToUBL22Converter.copyID(((TradeSettlementFinancialCardType)iExplicitlyCloneable2).getID(), new PrimaryAccountNumberIDType()));
                if (StringHelper.hasText(this.getCardAccountNetworkID())) {
                    ((CardAccountType)iExplicitlyCloneable).setNetworkID(this.getCardAccountNetworkID());
                }
                if (StringHelper.hasText(((TradeSettlementFinancialCardType)iExplicitlyCloneable2).getCardholderNameValue())) {
                    ((CardAccountType)iExplicitlyCloneable).setHolderName(((TradeSettlementFinancialCardType)iExplicitlyCloneable2).getCardholderNameValue());
                }
                if (StringHelper.hasNoText(((CardAccountType)iExplicitlyCloneable).getPrimaryAccountNumberIDValue())) {
                    errorList.add(CIIToUBL22Converter.buildError(null, "The Payment card primary account number is missing"));
                } else if (StringHelper.hasNoText(((CardAccountType)iExplicitlyCloneable).getNetworkIDValue())) {
                    errorList.add(CIIToUBL22Converter.buildError(null, "The Payment card network ID is missing"));
                } else {
                    paymentMeansType.setCardAccount((CardAccountType)iExplicitlyCloneable);
                }
            }
        }
        if (bl = CIIToUBL22Converter.isPaymentMeansCodeDirectDebit(string)) {
            IExplicitlyCloneable iExplicitlyCloneable4;
            iExplicitlyCloneable = new PaymentMandateType();
            Object object = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
            while (object.hasNext()) {
                iExplicitlyCloneable4 = object.next();
                if (!((TradePaymentTermsType)iExplicitlyCloneable4).hasDirectDebitMandateIDEntries()) continue;
                ((PaymentMandateType)iExplicitlyCloneable).setID(CIIToUBL22Converter._copyID(((TradePaymentTermsType)iExplicitlyCloneable4).getDirectDebitMandateIDAtIndex(0)));
                if (((PaymentMandateType)iExplicitlyCloneable).getID() == null) continue;
                break;
            }
            if ((object = headerTradeSettlementType.getCreditorReferenceID()) != null && (iExplicitlyCloneable4 = CIIToUBL22Converter._copyID((IDType)object)) != null) {
                ((IdentifierType)iExplicitlyCloneable4).setSchemeID("SEPA");
                consumer.accept((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType)iExplicitlyCloneable4);
            }
            if ((iExplicitlyCloneable4 = tradeSettlementPaymentMeansType.getPayerPartyDebtorFinancialAccount()) != null) {
                FinancialAccountType financialAccountType = new FinancialAccountType();
                financialAccountType.setID(CIIToUBL22Converter._copyID(((DebtorFinancialAccountType)iExplicitlyCloneable4).getIBANID()));
                if (financialAccountType.getID() != null) {
                    ((PaymentMandateType)iExplicitlyCloneable).setPayerFinancialAccount(financialAccountType);
                }
            }
            paymentMeansType.setPaymentMandate((PaymentMandateType)iExplicitlyCloneable);
        }
        if (bl3 || bl2 || bl || CIIToUBL22Converter.isPaymentMeansCodeOtherKnown(string)) {
            consumer2.accept(paymentMeansType);
        } else {
            errorList.add(CIIToUBL22Converter.buildError(null, "Failed to determine a supported Payment Means Type from code '" + string + "'"));
        }
    }

    @Nullable
    private OrderReferenceType _createUBLOrderRef(@Nullable ReferencedDocumentType referencedDocumentType, @Nullable ReferencedDocumentType referencedDocumentType2) {
        OrderReferenceType orderReferenceType = new OrderReferenceType();
        if (referencedDocumentType != null) {
            orderReferenceType.setID(referencedDocumentType.getIssuerAssignedIDValue());
        }
        if (referencedDocumentType2 != null) {
            if (orderReferenceType.getIDValue() == null) {
                orderReferenceType.setID(this.getDefaultOrderRefID());
            }
            CIIToUBL22Converter.ifNotEmpty(referencedDocumentType2.getIssuerAssignedIDValue(), orderReferenceType::setSalesOrderID);
        }
        if (StringHelper.hasNoText(orderReferenceType.getIDValue()) && StringHelper.hasNoText(orderReferenceType.getSalesOrderIDValue())) {
            return null;
        }
        return orderReferenceType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public InvoiceType convertToInvoice(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        boolean bl;
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        IExplicitlyCloneable iExplicitlyCloneable3;
        IExplicitlyCloneable iExplicitlyCloneable4;
        TradePartyType tradePartyType;
        DateTimeType dateTimeType;
        TradePartyType tradePartyType2;
        TradePartyType tradePartyType3;
        TradePartyType tradePartyType4;
        TradePartyType tradePartyType5;
        String string;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType2;
        TradeTaxType tradeTaxType;
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIIInvoice");
        ValueEnforcer.notNull(errorList, "ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        InvoiceType invoiceType = new InvoiceType();
        ExchangedDocumentContextType exchangedDocumentContextType = crossIndustryInvoiceType.getExchangedDocumentContext();
        if (exchangedDocumentContextType != null) {
            if (exchangedDocumentContextType.hasBusinessProcessSpecifiedDocumentContextParameterEntries()) {
                invoiceType.setProfileID(exchangedDocumentContextType.getBusinessProcessSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
            if (exchangedDocumentContextType.hasGuidelineSpecifiedDocumentContextParameterEntries()) {
                invoiceType.setCustomizationID(exchangedDocumentContextType.getGuidelineSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
        }
        if (StringHelper.hasText(this.getProfileID())) {
            invoiceType.setProfileID(this.getProfileID());
        }
        if (StringHelper.hasText(this.getCustomizationID())) {
            invoiceType.setCustomizationID(this.getCustomizationID());
        }
        if (exchangedDocumentType != null) {
            invoiceType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        invoiceType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        invoiceType.setAccountingCustomerParty(customerPartyType);
        Object object5 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object5 = CIIToUBL22Converter.parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object5 != null) {
            invoiceType.setIssueDate((LocalDate)object5);
        }
        object5 = null;
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            if (tradePaymentTermsType.getDueDateDateTime() != null && (object5 = CIIToUBL22Converter.parseDate(tradePaymentTermsType.getDueDateDateTime().getDateTimeString(), (IErrorList)errorList)) != null) break;
        }
        if (object5 != null) {
            invoiceType.setDueDate((LocalDate)object5);
        }
        if (exchangedDocumentType != null) {
            invoiceType.setInvoiceTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (NoteType noteType : exchangedDocumentType.getIncludedNote()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(noteType), invoiceType::addNote);
            }
        }
        for (TradeTaxType tradeTaxType2 : headerTradeSettlementType.getApplicableTradeTax()) {
            LocalDate localDate;
            if (tradeTaxType2.getTaxPointDate() == null || (localDate = CIIToUBL22Converter.parseDate(tradeTaxType2.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            invoiceType.setTaxPointDate(localDate);
            break;
        }
        object5 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        invoiceType.setDocumentCurrencyCode((String)object5);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            invoiceType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (TradeAccountingAccountType tradeAccountingAccountType : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            String string2 = tradeAccountingAccountType.getIDValue();
            if (!StringHelper.hasText(string2)) continue;
            invoiceType.setAccountingCost(string2);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            invoiceType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        PeriodType periodType = new PeriodType();
        SpecifiedPeriodType specifiedPeriodType = headerTradeSettlementType.getBillingSpecifiedPeriod();
        if (specifiedPeriodType != null) {
            DateTimeType dateTimeType2;
            DateTimeType dateTimeType3 = specifiedPeriodType.getStartDateTime();
            if (dateTimeType3 != null) {
                periodType.setStartDate(CIIToUBL22Converter.parseDate(dateTimeType3.getDateTimeString(), (IErrorList)errorList));
            }
            if ((dateTimeType2 = specifiedPeriodType.getEndDateTime()) != null) {
                periodType.setEndDate(CIIToUBL22Converter.parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
            }
        }
        if (headerTradeSettlementType.hasApplicableTradeTaxEntries() && StringHelper.hasText((tradeTaxType = headerTradeSettlementType.getApplicableTradeTaxAtIndex(0)).getDueDateTypeCodeValue())) {
            periodType.addDescriptionCode(new DescriptionCodeType(CIIToUBL22Converter.mapDueDateTypeCode(tradeTaxType.getDueDateTypeCodeValue())));
        }
        if (periodType.getStartDate() != null || periodType.getEndDate() != null || periodType.hasDescriptionCodeEntries()) {
            invoiceType.addInvoicePeriod(periodType);
        }
        OrderReferenceType orderReferenceType = this._createUBLOrderRef(headerTradeAgreementType.getBuyerOrderReferencedDocument(), headerTradeAgreementType.getSellerOrderReferencedDocument());
        invoiceType.setOrderReference(orderReferenceType);
        DocumentReferenceType documentReferenceType3 = CIIToUBL22Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), errorList);
        if (documentReferenceType3 != null) {
            BillingReferenceType billingReferenceType = new BillingReferenceType();
            billingReferenceType.setInvoiceDocumentReference(documentReferenceType3);
            invoiceType.addBillingReference(billingReferenceType);
        }
        if ((documentReferenceType2 = CIIToUBL22Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), errorList)) != null) {
            invoiceType.addDespatchDocumentReference(documentReferenceType2);
        }
        if ((documentReferenceType = CIIToUBL22Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), errorList)) != null) {
            invoiceType.addReceiptDocumentReference(documentReferenceType);
        }
        for (ReferencedDocumentType referencedDocumentType : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType4;
            if (!CIIToUBL22Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue()) || (documentReferenceType4 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList)) == null) continue;
            documentReferenceType4.setDocumentTypeCode((DocumentTypeCodeType)null);
            invoiceType.addOriginatorDocumentReference(documentReferenceType4);
        }
        DocumentReferenceType documentReferenceType5 = CIIToUBL22Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), errorList);
        if (documentReferenceType5 != null) {
            invoiceType.addContractDocumentReference(documentReferenceType5);
        }
        for (ReferencedDocumentType referencedDocumentType : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType6;
            if (CIIToUBL22Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue()) || (documentReferenceType6 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList)) == null) continue;
            invoiceType.addAdditionalDocumentReference(documentReferenceType6);
        }
        ProcuringProjectType procuringProjectType = headerTradeAgreementType.getSpecifiedProcuringProject();
        if (procuringProjectType != null && StringHelper.hasText(string = procuringProjectType.getIDValue())) {
            ProjectReferenceType projectReferenceType = new ProjectReferenceType();
            projectReferenceType.setID(string);
            invoiceType.addProjectReference(projectReferenceType);
        }
        if ((tradePartyType5 = headerTradeAgreementType.getSellerTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType5, true, true);
            for (TaxRegistrationType taxRegistrationType : tradePartyType5.getSpecifiedTaxRegistration()) {
                PartyTaxSchemeType partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL22Converter._convertPartyLegalEntity(tradePartyType5, partyType);
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType5);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            supplierPartyType.setParty(partyType);
        }
        if ((tradePartyType4 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType4, false, true);
            for (TaxRegistrationType taxRegistrationType : tradePartyType4.getSpecifiedTaxRegistration()) {
                PartyTaxSchemeType partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL22Converter._convertPartyLegalEntity(tradePartyType4, partyType);
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType4);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            customerPartyType.setParty(partyType);
        }
        if ((tradePartyType3 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType3, false, false);
            for (TaxRegistrationType taxRegistrationType : tradePartyType3.getSpecifiedTaxRegistration()) {
                PartyTaxSchemeType partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType3);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            invoiceType.setPayeeParty(partyType);
        }
        if ((tradePartyType2 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType2, false, false);
            for (TaxRegistrationType taxRegistrationType : tradePartyType2.getSpecifiedTaxRegistration()) {
                PartyTaxSchemeType partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType2);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            invoiceType.setTaxRepresentativeParty(partyType);
        }
        DeliveryType deliveryType = new DeliveryType();
        boolean bl2 = false;
        SupplyChainEventType supplyChainEventType = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
        if (supplyChainEventType != null && (dateTimeType = supplyChainEventType.getOccurrenceDateTime()) != null) {
            deliveryType.setActualDeliveryDate(CIIToUBL22Converter.parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
            boolean bl3 = true;
        }
        if ((tradePartyType = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            LocationType locationType = new LocationType();
            boolean bl4 = false;
            oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType iDType2 = CIIToUBL22Converter._extractFirstPartyID(tradePartyType);
            if (iDType2 != null) {
                locationType.setID(iDType2);
                bl4 = true;
            }
            if ((iExplicitlyCloneable4 = tradePartyType.getPostalTradeAddress()) != null) {
                locationType.setAddress(CIIToUBL22Converter._convertPostalAddress((TradeAddressType)iExplicitlyCloneable4));
                bl4 = true;
            }
            if (bl4) {
                deliveryType.setDeliveryLocation(locationType);
                boolean bl5 = true;
            }
            if ((iExplicitlyCloneable3 = tradePartyType.getName()) != null) {
                iExplicitlyCloneable2 = new PartyType();
                iExplicitlyCloneable = new PartyNameType();
                ((PartyNameType)iExplicitlyCloneable).setName(CIIToUBL22Converter.copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable3, new NameType()));
                ((PartyType)iExplicitlyCloneable2).addPartyName((PartyNameType)iExplicitlyCloneable);
                deliveryType.setDeliveryParty((PartyType)iExplicitlyCloneable2);
                bl = true;
            }
        }
        if (bl) {
            invoiceType.addDelivery(deliveryType);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL22Converter._addPartyID(iDType, invoiceType.getAccountingSupplierParty().getParty()), invoiceType::addPaymentMeans, errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            PaymentTermsType paymentTermsType = new PaymentTermsType();
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePaymentTermsType.getDescription()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(textType), paymentTermsType::addNote);
            }
            if (!paymentTermsType.hasNoteEntries()) continue;
            invoiceType.addPaymentTerms(paymentTermsType);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            void var15_102;
            ETriState eTriState = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                ETriState eTriState2 = CIIToUBL22Converter.parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
            } else {
                errorList.add(CIIToUBL22Converter.buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!var15_102.isDefined()) continue;
            AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
            allowanceChargeType.setChargeIndicator(var15_102.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object5);
            invoiceType.addAllowanceCharge(allowanceChargeType);
        }
        TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object var14_66 = null;
        if (tradeSettlementHeaderMonetarySummationType != null && tradeSettlementHeaderMonetarySummationType.hasTaxTotalAmountEntries()) {
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType : tradeSettlementHeaderMonetarySummationType.getTaxTotalAmount()) {
                void var14_67;
                TaxTotalType taxTotalType = new TaxTotalType();
                taxTotalType.setTaxAmount(CIIToUBL22Converter.copyAmount(amountType, new TaxAmountType(), (String)object5));
                invoiceType.addTaxTotal(taxTotalType);
                if (var14_67 != null) continue;
                TaxTotalType taxTotalType2 = taxTotalType;
            }
        } else {
            TaxAmountType taxAmountType = new TaxAmountType();
            taxAmountType.setValue(BigDecimal.ZERO);
            taxAmountType.setCurrencyID((String)object5);
            TaxTotalType taxTotalType = new TaxTotalType();
            taxTotalType.setTaxAmount(taxAmountType);
            invoiceType.addTaxTotal(taxTotalType);
        }
        for (TradeTaxType tradeTaxType3 : headerTradeSettlementType.getApplicableTradeTax()) {
            void var14_70;
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            if (tradeTaxType3.hasBasisAmountEntries()) {
                taxSubtotalType.setTaxableAmount(CIIToUBL22Converter.copyAmount(tradeTaxType3.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object5));
            }
            if (tradeTaxType3.hasCalculatedAmountEntries()) {
                taxSubtotalType.setTaxAmount(CIIToUBL22Converter.copyAmount(tradeTaxType3.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object5));
            }
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType3.getCategoryCodeValue());
            if (tradeTaxType3.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes(tradeTaxType3.getRateApplicablePercentValue()));
            }
            if (StringHelper.hasText(tradeTaxType3.getExemptionReasonCodeValue())) {
                taxCategoryType.setTaxExemptionReasonCode(tradeTaxType3.getExemptionReasonCodeValue());
            }
            if (tradeTaxType3.getExemptionReason() != null) {
                TaxExemptionReasonType taxExemptionReasonType = new TaxExemptionReasonType();
                taxExemptionReasonType.setValue(tradeTaxType3.getExemptionReason().getValue());
                taxExemptionReasonType.setLanguageID(tradeTaxType3.getExemptionReason().getLanguageID());
                taxExemptionReasonType.setLanguageLocaleID(tradeTaxType3.getExemptionReason().getLanguageLocaleID());
                taxCategoryType.addTaxExemptionReason(taxExemptionReasonType);
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory(taxCategoryType);
            var14_70.addTaxSubtotal(taxSubtotalType);
        }
        MonetaryTotalType monetaryTotalType = new MonetaryTotalType();
        if (tradeSettlementHeaderMonetarySummationType != null) {
            if (tradeSettlementHeaderMonetarySummationType.hasLineTotalAmountEntries()) {
                monetaryTotalType.setLineExtensionAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTaxBasisTotalAmountEntries()) {
                monetaryTotalType.setTaxExclusiveAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasGrandTotalAmountEntries()) {
                monetaryTotalType.setTaxInclusiveAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasAllowanceTotalAmountEntries()) {
                monetaryTotalType.setAllowanceTotalAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasChargeTotalAmountEntries()) {
                monetaryTotalType.setChargeTotalAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTotalPrepaidAmountEntries()) {
                monetaryTotalType.setPrepaidAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasRoundingAmountEntries() && MathHelper.isNE0(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0).getValue())) {
                monetaryTotalType.setPayableRoundingAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasDuePayableAmountEntries()) {
                monetaryTotalType.setPayableAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object5));
            }
        }
        invoiceType.setLegalMonetaryTotal(monetaryTotalType);
        for (SupplyChainTradeLineItemType supplyChainTradeLineItemType : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            boolean bl6;
            IExplicitlyCloneable iExplicitlyCloneable5;
            Object object;
            Object object2;
            IExplicitlyCloneable iExplicitlyCloneable6;
            IExplicitlyCloneable iExplicitlyCloneable7;
            Object object3;
            Object object4;
            InvoiceLineType invoiceLineType = new InvoiceLineType();
            DocumentLineDocumentType documentLineDocumentType = supplyChainTradeLineItemType.getAssociatedDocumentLineDocument();
            invoiceLineType.setID(CIIToUBL22Converter._copyID(documentLineDocumentType.getLineID()));
            for (NoteType noteType : documentLineDocumentType.getIncludedNote()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(noteType), invoiceLineType::addNote);
            }
            boolean bl7 = false;
            LineTradeSettlementType lineTradeSettlementType = supplyChainTradeLineItemType.getSpecifiedLineTradeSettlement();
            iExplicitlyCloneable4 = lineTradeSettlementType.getSpecifiedTradeSettlementLineMonetarySummation();
            if (iExplicitlyCloneable4 != null && ((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable4).hasLineTotalAmountEntries()) {
                invoiceLineType.setLineExtensionAmount(CIIToUBL22Converter.copyAmount(((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable4).getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
                if (CIIToUBL22Converter.isLT0Strict(invoiceLineType.getLineExtensionAmountValue())) {
                    bl7 = true;
                }
            }
            if ((iExplicitlyCloneable3 = supplyChainTradeLineItemType.getSpecifiedLineTradeDelivery()) != null && (iExplicitlyCloneable2 = ((LineTradeDeliveryType)iExplicitlyCloneable3).getBilledQuantity()) != null) {
                invoiceLineType.setInvoicedQuantity(CIIToUBL22Converter.copyQuantity((QuantityType)iExplicitlyCloneable2, new InvoicedQuantityType()));
            }
            if (lineTradeSettlementType.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                iExplicitlyCloneable2 = lineTradeSettlementType.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                invoiceLineType.setAccountingCost(((TradeAccountingAccountType)iExplicitlyCloneable2).getIDValue());
            }
            if ((iExplicitlyCloneable2 = lineTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
                DateTimeType dateTimeType4;
                iExplicitlyCloneable = new PeriodType();
                object4 = ((SpecifiedPeriodType)iExplicitlyCloneable2).getStartDateTime();
                if (object4 != null) {
                    ((PeriodType)iExplicitlyCloneable).setStartDate(CIIToUBL22Converter.parseDate(((DateTimeType)object4).getDateTimeString(), (IErrorList)errorList));
                }
                if ((dateTimeType4 = ((SpecifiedPeriodType)iExplicitlyCloneable2).getEndDateTime()) != null) {
                    ((PeriodType)iExplicitlyCloneable).setEndDate(CIIToUBL22Converter.parseDate(dateTimeType4.getDateTimeString(), (IErrorList)errorList));
                }
                if (((PeriodType)iExplicitlyCloneable).getStartDate() != null || ((PeriodType)iExplicitlyCloneable).getEndDate() != null) {
                    invoiceLineType.addInvoicePeriod((PeriodType)iExplicitlyCloneable);
                }
            }
            if ((iExplicitlyCloneable = supplyChainTradeLineItemType.getSpecifiedLineTradeAgreement()) != null && (object4 = ((LineTradeAgreementType)iExplicitlyCloneable).getBuyerOrderReferencedDocument()) != null && StringHelper.hasText(((ReferencedDocumentType)object4).getLineIDValue())) {
                OrderLineReferenceType orderLineReferenceType = new OrderLineReferenceType();
                orderLineReferenceType.setLineID(CIIToUBL22Converter.copyID(((ReferencedDocumentType)object4).getLineID(), new LineIDType()));
                invoiceLineType.addOrderLineReference(orderLineReferenceType);
            }
            for (ReferencedDocumentType referencedDocumentType : lineTradeSettlementType.getAdditionalReferencedDocument()) {
                object3 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList);
                if (object3 == null) continue;
                invoiceLineType.addDocumentReference((DocumentReferenceType)object3);
            }
            for (TradeAllowanceChargeType tradeAllowanceChargeType : lineTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
                object3 = ETriState.UNDEFINED;
                if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                    object3 = CIIToUBL22Converter.parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
                } else {
                    errorList.add(CIIToUBL22Converter.buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!((ETriState)object3).isDefined()) continue;
                AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                allowanceChargeType.setChargeIndicator(((ETriState)object3).getAsBooleanValue());
                this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object5);
                invoiceLineType.addAllowanceCharge(allowanceChargeType);
            }
            object4 = new ItemType();
            TradeProductType tradeProductType = supplyChainTradeLineItemType.getSpecifiedTradeProduct();
            if (tradeProductType != null) {
                IDType iDType3;
                object3 = tradeProductType.getDescription();
                if (object3 != null) {
                    CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter.copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)object3, new DescriptionType()), ((ItemType)object4)::addDescription);
                }
                if (tradeProductType.hasNameEntries()) {
                    ((ItemType)object4).setName(CIIToUBL22Converter.copyName(tradeProductType.getNameAtIndex(0), new NameType()));
                }
                if ((iDType3 = tradeProductType.getBuyerAssignedID()) != null) {
                    iExplicitlyCloneable7 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable7).setID(CIIToUBL22Converter._copyID(iDType3));
                    if (StringHelper.hasText(((ItemIdentificationType)iExplicitlyCloneable7).getIDValue())) {
                        ((ItemType)object4).setBuyersItemIdentification((ItemIdentificationType)iExplicitlyCloneable7);
                    }
                }
                if ((iExplicitlyCloneable7 = tradeProductType.getSellerAssignedID()) != null) {
                    iExplicitlyCloneable6 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable6).setID(CIIToUBL22Converter._copyID((IDType)iExplicitlyCloneable7));
                    if (StringHelper.hasText(((ItemIdentificationType)iExplicitlyCloneable6).getIDValue())) {
                        ((ItemType)object4).setSellersItemIdentification((ItemIdentificationType)iExplicitlyCloneable6);
                    }
                }
                if ((iExplicitlyCloneable6 = tradeProductType.getGlobalID()) != null) {
                    object2 = new ItemIdentificationType();
                    ((ItemIdentificationType)object2).setID(CIIToUBL22Converter._copyID((IDType)iExplicitlyCloneable6));
                    if (StringHelper.hasText(((ItemIdentificationType)object2).getIDValue())) {
                        ((ItemType)object4).setStandardItemIdentification((ItemIdentificationType)object2);
                    }
                }
                if ((object2 = tradeProductType.getOriginTradeCountry()) != null) {
                    object = new CountryType();
                    ((CountryType)object).setIdentificationCode(((TradeCountryType)object2).getIDValue());
                    if (((TradeCountryType)object2).hasNameEntries()) {
                        ((CountryType)object).setName(CIIToUBL22Converter.copyName(((TradeCountryType)object2).getNameAtIndex(0), new NameType()));
                    }
                    ((ItemType)object4).setOriginCountry((CountryType)object);
                }
                for (ProductClassificationType productClassificationType : tradeProductType.getDesignatedProductClassification()) {
                    iExplicitlyCloneable5 = productClassificationType.getClassCode();
                    if (iExplicitlyCloneable5 == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL22Converter.copyCode(iExplicitlyCloneable5, new ItemClassificationCodeType()));
                    if (commodityClassificationType.getItemClassificationCode() == null) continue;
                    ((ItemType)object4).addCommodityClassification(commodityClassificationType);
                }
            }
            for (TradeTaxType tradeTaxType4 : lineTradeSettlementType.getApplicableTradeTax()) {
                iExplicitlyCloneable7 = new TaxCategoryType();
                ((TaxCategoryType)iExplicitlyCloneable7).setID(tradeTaxType4.getCategoryCodeValue());
                if (tradeTaxType4.getRateApplicablePercentValue() != null) {
                    ((TaxCategoryType)iExplicitlyCloneable7).setPercent(MathHelper.getWithoutTrailingZeroes(tradeTaxType4.getRateApplicablePercentValue()));
                }
                iExplicitlyCloneable6 = new TaxSchemeType();
                ((TaxSchemeType)iExplicitlyCloneable6).setID(this.getVATScheme());
                ((TaxCategoryType)iExplicitlyCloneable7).setTaxScheme((TaxSchemeType)iExplicitlyCloneable6);
                ((ItemType)object4).addClassifiedTaxCategory((TaxCategoryType)iExplicitlyCloneable7);
            }
            if (tradeProductType != null) {
                for (ProductCharacteristicType productCharacteristicType : tradeProductType.getApplicableProductCharacteristic()) {
                    if (!productCharacteristicType.hasDescriptionEntries()) continue;
                    iExplicitlyCloneable7 = new ItemPropertyType();
                    ((ItemPropertyType)iExplicitlyCloneable7).setName(CIIToUBL22Converter.copyName(productCharacteristicType.getDescriptionAtIndex(0), new NameType()));
                    if (productCharacteristicType.hasValueEntries()) {
                        ((ItemPropertyType)iExplicitlyCloneable7).setValue(productCharacteristicType.getValueAtIndex(0).getValue());
                    }
                    if (((ItemPropertyType)iExplicitlyCloneable7).getName() == null) continue;
                    ((ItemType)object4).addAdditionalItemProperty((ItemPropertyType)iExplicitlyCloneable7);
                }
            }
            object3 = new PriceType();
            boolean bl8 = false;
            iExplicitlyCloneable7 = new AllowanceChargeType();
            ((AllowanceChargeType)iExplicitlyCloneable7).setChargeIndicator(false);
            ((PriceType)object3).addAllowanceCharge((AllowanceChargeType)iExplicitlyCloneable7);
            boolean bl9 = false;
            if (iExplicitlyCloneable != null) {
                TradePriceType tradePriceType;
                object2 = null;
                object = ((LineTradeAgreementType)iExplicitlyCloneable).getGrossPriceProductTradePrice();
                if (object != null) {
                    un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType;
                    TradeAllowanceChargeType tradeAllowanceChargeType;
                    if (((TradePriceType)object).hasAppliedTradeAllowanceChargeEntries() && (tradeAllowanceChargeType = ((TradePriceType)object).getAppliedTradeAllowanceChargeAtIndex(0)).hasActualAmountEntries() && (iExplicitlyCloneable5 = tradeAllowanceChargeType.getActualAmountAtIndex(0)) != null) {
                        ((AllowanceChargeType)iExplicitlyCloneable7).setAmount(CIIToUBL22Converter.copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)iExplicitlyCloneable5, new AmountType(), (String)object5));
                        boolean bl10 = bl9 = ((AllowanceChargeType)iExplicitlyCloneable7).getAmount() != null;
                    }
                    if (((TradePriceType)object).hasChargeAmountEntries() && (amountType = ((TradePriceType)object).getChargeAmountAtIndex(0)) != null) {
                        ((AllowanceChargeType)iExplicitlyCloneable7).setBaseAmount(CIIToUBL22Converter.copyAmount(amountType, new BaseAmountType(), (String)object5));
                        if (!bl9) {
                            ((AllowanceChargeType)iExplicitlyCloneable7).setAmount(BigDecimal.ZERO).setCurrencyID((String)object5);
                            bl9 = true;
                        }
                    }
                    if (((TradePriceType)object).getBasisQuantity() != null) {
                        object2 = ((TradePriceType)object).getBasisQuantity().getUnitCode();
                    }
                }
                if ((tradePriceType = ((LineTradeAgreementType)iExplicitlyCloneable).getNetPriceProductTradePrice()) != null) {
                    if (tradePriceType.hasChargeAmountEntries()) {
                        ((PriceType)object3).setPriceAmount(CIIToUBL22Converter.copyAmount(tradePriceType.getChargeAmountAtIndex(0), new PriceAmountType(), (String)object5));
                        bl6 = ((PriceType)object3).getPriceAmount() != null;
                    }
                    IExplicitlyCloneable iExplicitlyCloneable8 = iExplicitlyCloneable5 = object != null ? ((TradePriceType)object).getBasisQuantity() : null;
                    if (iExplicitlyCloneable5 == null) {
                        iExplicitlyCloneable5 = tradePriceType.getBasisQuantity();
                    }
                    if (iExplicitlyCloneable5 != null) {
                        ((PriceType)object3).setBaseQuantity(CIIToUBL22Converter.copyQuantity((QuantityType)iExplicitlyCloneable5, new BaseQuantityType()));
                        if (((PriceType)object3).getBaseQuantity() != null) {
                            ((PriceType)object3).getBaseQuantity().setUnitCode((String)object2);
                        }
                    }
                }
            }
            if (invoiceLineType.getInvoicedQuantityValue() != null) {
                this.swapQuantityAndPriceIfNeeded(bl7, invoiceLineType.getInvoicedQuantityValue(), invoiceLineType::setInvoicedQuantity, bl6 ? ((PriceType)object3).getPriceAmountValue() : null, bl6 ? ((PriceType)object3)::setPriceAmount : null, errorList);
            }
            if (bl6) {
                if (!bl9) {
                    ((PriceType)object3).setAllowanceCharge(null);
                }
                invoiceLineType.setPrice((PriceType)object3);
            }
            invoiceLineType.setItem((ItemType)object4);
            invoiceType.addInvoiceLine(invoiceLineType);
        }
        return invoiceType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CreditNoteType convertToCreditNote(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        IExplicitlyCloneable iExplicitlyCloneable3;
        Object object;
        TradePartyType tradePartyType;
        TradePartyType tradePartyType2;
        TradePartyType tradePartyType3;
        TradePartyType tradePartyType4;
        PartyTaxSchemeType partyTaxSchemeType;
        TradePartyType tradePartyType5;
        String string;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType2;
        TradeTaxType tradeTaxType;
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIICreditNote");
        ValueEnforcer.notNull(errorList, "ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        CreditNoteType creditNoteType = new CreditNoteType();
        ExchangedDocumentContextType exchangedDocumentContextType = crossIndustryInvoiceType.getExchangedDocumentContext();
        if (exchangedDocumentContextType != null) {
            if (exchangedDocumentContextType.hasBusinessProcessSpecifiedDocumentContextParameterEntries()) {
                creditNoteType.setProfileID(exchangedDocumentContextType.getBusinessProcessSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
            if (exchangedDocumentContextType.hasGuidelineSpecifiedDocumentContextParameterEntries()) {
                creditNoteType.setCustomizationID(exchangedDocumentContextType.getGuidelineSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
        }
        if (StringHelper.hasText(this.getProfileID())) {
            creditNoteType.setProfileID(this.getProfileID());
        }
        if (StringHelper.hasText(this.getCustomizationID())) {
            creditNoteType.setCustomizationID(this.getCustomizationID());
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        creditNoteType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        creditNoteType.setAccountingCustomerParty(customerPartyType);
        Object object6 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object6 = CIIToUBL22Converter.parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object6 != null) {
            creditNoteType.setIssueDate((LocalDate)object6);
        }
        object6 = null;
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            if (tradePaymentTermsType.getDueDateDateTime() != null && (object6 = CIIToUBL22Converter.parseDate(tradePaymentTermsType.getDueDateDateTime().getDateTimeString(), (IErrorList)errorList)) != null) break;
        }
        if (object6 != null) {
            creditNoteType.setDueDate((LocalDate)object6);
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setCreditNoteTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (NoteType noteType : exchangedDocumentType.getIncludedNote()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(noteType), creditNoteType::addNote);
            }
        }
        for (TradeTaxType tradeTaxType2 : headerTradeSettlementType.getApplicableTradeTax()) {
            LocalDate localDate;
            if (tradeTaxType2.getTaxPointDate() == null || (localDate = CIIToUBL22Converter.parseDate(tradeTaxType2.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            creditNoteType.setTaxPointDate(localDate);
            break;
        }
        object6 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        creditNoteType.setDocumentCurrencyCode((String)object6);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            creditNoteType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (TradeAccountingAccountType tradeAccountingAccountType : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            String string2 = tradeAccountingAccountType.getIDValue();
            if (!StringHelper.hasText(string2)) continue;
            creditNoteType.setAccountingCost(string2);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            creditNoteType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        PeriodType periodType = new PeriodType();
        SpecifiedPeriodType specifiedPeriodType = headerTradeSettlementType.getBillingSpecifiedPeriod();
        if (specifiedPeriodType != null) {
            DateTimeType dateTimeType;
            DateTimeType dateTimeType2 = specifiedPeriodType.getStartDateTime();
            if (dateTimeType2 != null) {
                periodType.setStartDate(CIIToUBL22Converter.parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
            }
            if ((dateTimeType = specifiedPeriodType.getEndDateTime()) != null) {
                periodType.setEndDate(CIIToUBL22Converter.parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
            }
        }
        if (headerTradeSettlementType.hasApplicableTradeTaxEntries() && StringHelper.hasText((tradeTaxType = headerTradeSettlementType.getApplicableTradeTaxAtIndex(0)).getDueDateTypeCodeValue())) {
            periodType.addDescriptionCode(new DescriptionCodeType(CIIToUBL22Converter.mapDueDateTypeCode(tradeTaxType.getDueDateTypeCodeValue())));
        }
        if (periodType.getStartDate() != null || periodType.getEndDate() != null || periodType.hasDescriptionCodeEntries()) {
            creditNoteType.addInvoicePeriod(periodType);
        }
        OrderReferenceType orderReferenceType = this._createUBLOrderRef(headerTradeAgreementType.getBuyerOrderReferencedDocument(), headerTradeAgreementType.getSellerOrderReferencedDocument());
        creditNoteType.setOrderReference(orderReferenceType);
        DocumentReferenceType documentReferenceType3 = CIIToUBL22Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), errorList);
        if (documentReferenceType3 != null) {
            BillingReferenceType billingReferenceType = new BillingReferenceType();
            billingReferenceType.setCreditNoteDocumentReference(documentReferenceType3);
            creditNoteType.addBillingReference(billingReferenceType);
        }
        if ((documentReferenceType2 = CIIToUBL22Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), errorList)) != null) {
            creditNoteType.addDespatchDocumentReference(documentReferenceType2);
        }
        if ((documentReferenceType = CIIToUBL22Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), errorList)) != null) {
            creditNoteType.addReceiptDocumentReference(documentReferenceType);
        }
        for (ReferencedDocumentType referencedDocumentType : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType4;
            if (!CIIToUBL22Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue()) || (documentReferenceType4 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList)) == null) continue;
            documentReferenceType4.setDocumentTypeCode((DocumentTypeCodeType)null);
            creditNoteType.addOriginatorDocumentReference(documentReferenceType4);
        }
        DocumentReferenceType documentReferenceType5 = CIIToUBL22Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), errorList);
        if (documentReferenceType5 != null) {
            creditNoteType.addContractDocumentReference(documentReferenceType5);
        }
        for (ReferencedDocumentType referencedDocumentType : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType6;
            if (CIIToUBL22Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue()) || (documentReferenceType6 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList)) == null) continue;
            creditNoteType.addAdditionalDocumentReference(documentReferenceType6);
        }
        ProcuringProjectType procuringProjectType = headerTradeAgreementType.getSpecifiedProcuringProject();
        if (procuringProjectType != null && StringHelper.hasText(string = procuringProjectType.getIDValue())) {
            ProjectReferenceType projectReferenceType = new ProjectReferenceType();
            projectReferenceType.setID(string);
            creditNoteType.addProjectReference(projectReferenceType);
        }
        if ((tradePartyType5 = headerTradeAgreementType.getSellerTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType5, true, true);
            for (TaxRegistrationType taxRegistrationType : tradePartyType5.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL22Converter._convertPartyLegalEntity(tradePartyType5, partyType);
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType5);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            supplierPartyType.setParty(partyType);
        }
        if ((tradePartyType4 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType4, false, true);
            for (TaxRegistrationType taxRegistrationType : tradePartyType4.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL22Converter._convertPartyLegalEntity(tradePartyType4, partyType);
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType4);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            customerPartyType.setParty(partyType);
        }
        if ((tradePartyType3 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType3, false, false);
            for (TaxRegistrationType taxRegistrationType : tradePartyType3.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType3);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            creditNoteType.setPayeeParty(partyType);
        }
        if ((tradePartyType2 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            PartyType partyType = CIIToUBL22Converter._convertParty(tradePartyType2, false, false);
            for (TaxRegistrationType taxRegistrationType : tradePartyType2.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL22Converter._convertContact(tradePartyType2);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            creditNoteType.setTaxRepresentativeParty(partyType);
        }
        if ((tradePartyType = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            TradeAddressType tradeAddressType;
            DateTimeType dateTimeType;
            DeliveryType deliveryType = new DeliveryType();
            SupplyChainEventType supplyChainEventType = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
            if (supplyChainEventType != null && (dateTimeType = supplyChainEventType.getOccurrenceDateTime()) != null) {
                deliveryType.setActualDeliveryDate(CIIToUBL22Converter.parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
            }
            LocationType locationType = new LocationType();
            boolean bl = false;
            object = CIIToUBL22Converter._extractFirstPartyID(tradePartyType);
            if (object != null) {
                locationType.setID((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.IDType)object);
                bl = true;
            }
            if ((tradeAddressType = tradePartyType.getPostalTradeAddress()) != null) {
                locationType.setAddress(CIIToUBL22Converter._convertPostalAddress(tradeAddressType));
                bl = true;
            }
            if (bl) {
                deliveryType.setDeliveryLocation(locationType);
            }
            if ((iExplicitlyCloneable3 = tradePartyType.getName()) != null) {
                iExplicitlyCloneable2 = new PartyType();
                iExplicitlyCloneable = new PartyNameType();
                ((PartyNameType)iExplicitlyCloneable).setName(CIIToUBL22Converter.copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable3, new NameType()));
                ((PartyType)iExplicitlyCloneable2).addPartyName((PartyNameType)iExplicitlyCloneable);
                deliveryType.setDeliveryParty((PartyType)iExplicitlyCloneable2);
            }
            creditNoteType.addDelivery(deliveryType);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL22Converter._addPartyID(iDType, creditNoteType.getAccountingSupplierParty().getParty()), creditNoteType::addPaymentMeans, errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            PaymentTermsType paymentTermsType = new PaymentTermsType();
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePaymentTermsType.getDescription()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(textType), paymentTermsType::addNote);
            }
            if (!paymentTermsType.hasNoteEntries()) continue;
            creditNoteType.addPaymentTerms(paymentTermsType);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            void var15_104;
            ETriState eTriState = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                ETriState eTriState2 = CIIToUBL22Converter.parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
            } else {
                errorList.add(CIIToUBL22Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!var15_104.isDefined()) continue;
            AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
            allowanceChargeType.setChargeIndicator(var15_104.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object6);
            creditNoteType.addAllowanceCharge(allowanceChargeType);
        }
        TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object var14_67 = null;
        if (tradeSettlementHeaderMonetarySummationType != null && tradeSettlementHeaderMonetarySummationType.hasTaxTotalAmountEntries()) {
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType : tradeSettlementHeaderMonetarySummationType.getTaxTotalAmount()) {
                void var14_68;
                TaxTotalType taxTotalType = new TaxTotalType();
                taxTotalType.setTaxAmount(CIIToUBL22Converter.copyAmount(amountType, new TaxAmountType(), (String)object6));
                creditNoteType.addTaxTotal(taxTotalType);
                if (var14_68 != null) continue;
                TaxTotalType taxTotalType2 = taxTotalType;
            }
        } else {
            TaxAmountType taxAmountType = new TaxAmountType();
            taxAmountType.setValue(BigDecimal.ZERO);
            taxAmountType.setCurrencyID((String)object6);
            TaxTotalType taxTotalType = new TaxTotalType();
            taxTotalType.setTaxAmount(taxAmountType);
            creditNoteType.addTaxTotal(taxTotalType);
        }
        for (TradeTaxType tradeTaxType3 : headerTradeSettlementType.getApplicableTradeTax()) {
            void var14_71;
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            if (tradeTaxType3.hasBasisAmountEntries()) {
                taxSubtotalType.setTaxableAmount(CIIToUBL22Converter.copyAmount(tradeTaxType3.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object6));
            }
            if (tradeTaxType3.hasCalculatedAmountEntries()) {
                taxSubtotalType.setTaxAmount(CIIToUBL22Converter.copyAmount(tradeTaxType3.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object6));
            }
            object = new TaxCategoryType();
            ((TaxCategoryType)object).setID(tradeTaxType3.getCategoryCodeValue());
            if (tradeTaxType3.getRateApplicablePercentValue() != null) {
                ((TaxCategoryType)object).setPercent(MathHelper.getWithoutTrailingZeroes(tradeTaxType3.getRateApplicablePercentValue()));
            }
            if (StringHelper.hasText(tradeTaxType3.getExemptionReasonCodeValue())) {
                ((TaxCategoryType)object).setTaxExemptionReasonCode(tradeTaxType3.getExemptionReasonCodeValue());
            }
            if (tradeTaxType3.getExemptionReason() != null) {
                TaxExemptionReasonType taxExemptionReasonType = new TaxExemptionReasonType();
                taxExemptionReasonType.setValue(tradeTaxType3.getExemptionReason().getValue());
                taxExemptionReasonType.setLanguageID(tradeTaxType3.getExemptionReason().getLanguageID());
                taxExemptionReasonType.setLanguageLocaleID(tradeTaxType3.getExemptionReason().getLanguageLocaleID());
                ((TaxCategoryType)object).addTaxExemptionReason(taxExemptionReasonType);
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            ((TaxCategoryType)object).setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory((TaxCategoryType)object);
            var14_71.addTaxSubtotal(taxSubtotalType);
        }
        MonetaryTotalType monetaryTotalType = new MonetaryTotalType();
        if (tradeSettlementHeaderMonetarySummationType != null) {
            if (tradeSettlementHeaderMonetarySummationType.hasLineTotalAmountEntries()) {
                monetaryTotalType.setLineExtensionAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTaxBasisTotalAmountEntries()) {
                monetaryTotalType.setTaxExclusiveAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasGrandTotalAmountEntries()) {
                monetaryTotalType.setTaxInclusiveAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasAllowanceTotalAmountEntries()) {
                monetaryTotalType.setAllowanceTotalAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasChargeTotalAmountEntries()) {
                monetaryTotalType.setChargeTotalAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTotalPrepaidAmountEntries()) {
                monetaryTotalType.setPrepaidAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasRoundingAmountEntries() && MathHelper.isNE0(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0).getValue())) {
                monetaryTotalType.setPayableRoundingAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasDuePayableAmountEntries()) {
                monetaryTotalType.setPayableAmount(CIIToUBL22Converter.copyAmount(tradeSettlementHeaderMonetarySummationType.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object6));
            }
        }
        creditNoteType.setLegalMonetaryTotal(monetaryTotalType);
        for (SupplyChainTradeLineItemType supplyChainTradeLineItemType : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            boolean bl;
            Object object2;
            IExplicitlyCloneable iExplicitlyCloneable4;
            Object object3;
            IExplicitlyCloneable iExplicitlyCloneable5;
            Object object4;
            Object object5;
            IExplicitlyCloneable iExplicitlyCloneable6;
            CreditNoteLineType creditNoteLineType = new CreditNoteLineType();
            DocumentLineDocumentType documentLineDocumentType = supplyChainTradeLineItemType.getAssociatedDocumentLineDocument();
            creditNoteLineType.setID(CIIToUBL22Converter._copyID(documentLineDocumentType.getLineID()));
            for (NoteType noteType : documentLineDocumentType.getIncludedNote()) {
                CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter._copyNote(noteType), creditNoteLineType::addNote);
            }
            boolean bl2 = false;
            LineTradeSettlementType lineTradeSettlementType = supplyChainTradeLineItemType.getSpecifiedLineTradeSettlement();
            iExplicitlyCloneable3 = lineTradeSettlementType.getSpecifiedTradeSettlementLineMonetarySummation();
            if (iExplicitlyCloneable3 != null && ((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).hasLineTotalAmountEntries()) {
                creditNoteLineType.setLineExtensionAmount(CIIToUBL22Converter.copyAmount(((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
                if (CIIToUBL22Converter.isLT0Strict(creditNoteLineType.getLineExtensionAmountValue())) {
                    bl2 = true;
                }
            }
            if ((iExplicitlyCloneable2 = supplyChainTradeLineItemType.getSpecifiedLineTradeDelivery()) != null && (iExplicitlyCloneable = ((LineTradeDeliveryType)iExplicitlyCloneable2).getBilledQuantity()) != null) {
                creditNoteLineType.setCreditedQuantity(CIIToUBL22Converter.copyQuantity((QuantityType)iExplicitlyCloneable, new CreditedQuantityType()));
            }
            if (lineTradeSettlementType.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                iExplicitlyCloneable = lineTradeSettlementType.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                creditNoteLineType.setAccountingCost(((TradeAccountingAccountType)iExplicitlyCloneable).getIDValue());
            }
            if ((iExplicitlyCloneable = lineTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
                DateTimeType dateTimeType;
                iExplicitlyCloneable6 = new PeriodType();
                object5 = ((SpecifiedPeriodType)iExplicitlyCloneable).getStartDateTime();
                if (object5 != null) {
                    ((PeriodType)iExplicitlyCloneable6).setStartDate(CIIToUBL22Converter.parseDate(((DateTimeType)object5).getDateTimeString(), (IErrorList)errorList));
                }
                if ((dateTimeType = ((SpecifiedPeriodType)iExplicitlyCloneable).getEndDateTime()) != null) {
                    ((PeriodType)iExplicitlyCloneable6).setEndDate(CIIToUBL22Converter.parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
                }
                if (((PeriodType)iExplicitlyCloneable6).getStartDate() != null || ((PeriodType)iExplicitlyCloneable6).getEndDate() != null) {
                    creditNoteLineType.addInvoicePeriod((PeriodType)iExplicitlyCloneable6);
                }
            }
            if ((iExplicitlyCloneable6 = supplyChainTradeLineItemType.getSpecifiedLineTradeAgreement()) != null && (object5 = ((LineTradeAgreementType)iExplicitlyCloneable6).getBuyerOrderReferencedDocument()) != null && StringHelper.hasText(((ReferencedDocumentType)object5).getLineIDValue())) {
                OrderLineReferenceType orderLineReferenceType = new OrderLineReferenceType();
                orderLineReferenceType.setLineID(CIIToUBL22Converter.copyID(((ReferencedDocumentType)object5).getLineID(), new LineIDType()));
                creditNoteLineType.addOrderLineReference(orderLineReferenceType);
            }
            for (ReferencedDocumentType referencedDocumentType : lineTradeSettlementType.getAdditionalReferencedDocument()) {
                object4 = CIIToUBL22Converter._convertDocumentReference(referencedDocumentType, errorList);
                if (object4 == null) continue;
                creditNoteLineType.addDocumentReference((DocumentReferenceType)object4);
            }
            for (TradeAllowanceChargeType tradeAllowanceChargeType : lineTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
                object4 = ETriState.UNDEFINED;
                if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                    object4 = CIIToUBL22Converter.parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
                } else {
                    errorList.add(CIIToUBL22Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!((ETriState)object4).isDefined()) continue;
                AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                allowanceChargeType.setChargeIndicator(((ETriState)object4).getAsBooleanValue());
                this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object6);
                creditNoteLineType.addAllowanceCharge(allowanceChargeType);
            }
            object5 = new ItemType();
            TradeProductType tradeProductType = supplyChainTradeLineItemType.getSpecifiedTradeProduct();
            if (tradeProductType != null) {
                IDType iDType2;
                object4 = tradeProductType.getDescription();
                if (object4 != null) {
                    CIIToUBL22Converter.ifNotNull(CIIToUBL22Converter.copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)object4, new DescriptionType()), ((ItemType)object5)::addDescription);
                }
                if (tradeProductType.hasNameEntries()) {
                    ((ItemType)object5).setName(CIIToUBL22Converter.copyName(tradeProductType.getNameAtIndex(0), new NameType()));
                }
                if ((iDType2 = tradeProductType.getBuyerAssignedID()) != null) {
                    iExplicitlyCloneable5 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable5).setID(CIIToUBL22Converter._copyID(iDType2));
                    if (StringHelper.hasText(((ItemIdentificationType)iExplicitlyCloneable5).getIDValue())) {
                        ((ItemType)object5).setBuyersItemIdentification((ItemIdentificationType)iExplicitlyCloneable5);
                    }
                }
                if ((iExplicitlyCloneable5 = tradeProductType.getSellerAssignedID()) != null) {
                    object3 = new ItemIdentificationType();
                    ((ItemIdentificationType)object3).setID(CIIToUBL22Converter._copyID((IDType)iExplicitlyCloneable5));
                    if (StringHelper.hasText(((ItemIdentificationType)object3).getIDValue())) {
                        ((ItemType)object5).setSellersItemIdentification((ItemIdentificationType)object3);
                    }
                }
                if ((object3 = tradeProductType.getGlobalID()) != null) {
                    iExplicitlyCloneable4 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable4).setID(CIIToUBL22Converter._copyID((IDType)object3));
                    if (StringHelper.hasText(((ItemIdentificationType)iExplicitlyCloneable4).getIDValue())) {
                        ((ItemType)object5).setStandardItemIdentification((ItemIdentificationType)iExplicitlyCloneable4);
                    }
                }
                if ((iExplicitlyCloneable4 = tradeProductType.getOriginTradeCountry()) != null) {
                    object2 = new CountryType();
                    ((CountryType)object2).setIdentificationCode(((TradeCountryType)iExplicitlyCloneable4).getIDValue());
                    if (((TradeCountryType)iExplicitlyCloneable4).hasNameEntries()) {
                        ((CountryType)object2).setName(CIIToUBL22Converter.copyName(((TradeCountryType)iExplicitlyCloneable4).getNameAtIndex(0), new NameType()));
                    }
                    ((ItemType)object5).setOriginCountry((CountryType)object2);
                }
                for (ProductClassificationType productClassificationType : tradeProductType.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL22Converter.copyCode(codeType, new ItemClassificationCodeType()));
                    if (commodityClassificationType.getItemClassificationCode() == null) continue;
                    ((ItemType)object5).addCommodityClassification(commodityClassificationType);
                }
            }
            for (TradeTaxType tradeTaxType4 : lineTradeSettlementType.getApplicableTradeTax()) {
                iExplicitlyCloneable5 = new TaxCategoryType();
                ((TaxCategoryType)iExplicitlyCloneable5).setID(tradeTaxType4.getCategoryCodeValue());
                if (tradeTaxType4.getRateApplicablePercentValue() != null) {
                    ((TaxCategoryType)iExplicitlyCloneable5).setPercent(MathHelper.getWithoutTrailingZeroes(tradeTaxType4.getRateApplicablePercentValue()));
                }
                object3 = new TaxSchemeType();
                ((TaxSchemeType)object3).setID(this.getVATScheme());
                ((TaxCategoryType)iExplicitlyCloneable5).setTaxScheme((TaxSchemeType)object3);
                ((ItemType)object5).addClassifiedTaxCategory((TaxCategoryType)iExplicitlyCloneable5);
            }
            if (tradeProductType != null) {
                for (ProductCharacteristicType productCharacteristicType : tradeProductType.getApplicableProductCharacteristic()) {
                    if (!productCharacteristicType.hasDescriptionEntries()) continue;
                    iExplicitlyCloneable5 = new ItemPropertyType();
                    ((ItemPropertyType)iExplicitlyCloneable5).setName(CIIToUBL22Converter.copyName(productCharacteristicType.getDescriptionAtIndex(0), new NameType()));
                    if (productCharacteristicType.hasValueEntries()) {
                        ((ItemPropertyType)iExplicitlyCloneable5).setValue(productCharacteristicType.getValueAtIndex(0).getValue());
                    }
                    if (((ItemPropertyType)iExplicitlyCloneable5).getName() == null) continue;
                    ((ItemType)object5).addAdditionalItemProperty((ItemPropertyType)iExplicitlyCloneable5);
                }
            }
            object4 = new PriceType();
            boolean bl3 = false;
            if (iExplicitlyCloneable6 != null && (iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable6).getNetPriceProductTradePrice()) != null) {
                if (((TradePriceType)iExplicitlyCloneable5).hasChargeAmountEntries()) {
                    ((PriceType)object4).setPriceAmount(CIIToUBL22Converter.copyAmount(((TradePriceType)iExplicitlyCloneable5).getChargeAmountAtIndex(0), new PriceAmountType(), (String)object6));
                    boolean bl4 = true;
                }
                if (((TradePriceType)iExplicitlyCloneable5).getBasisQuantity() != null) {
                    ((PriceType)object4).setBaseQuantity(CIIToUBL22Converter.copyQuantity(((TradePriceType)iExplicitlyCloneable5).getBasisQuantity(), new BaseQuantityType()));
                    bl = true;
                }
            }
            if (creditNoteLineType.getCreditedQuantityValue() != null) {
                this.swapQuantityAndPriceIfNeeded(bl2, creditNoteLineType.getCreditedQuantityValue(), creditNoteLineType::setCreditedQuantity, bl ? ((PriceType)object4).getPriceAmountValue() : null, bl ? ((PriceType)object4)::setPriceAmount : null, errorList);
            }
            if ((iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable6).getGrossPriceProductTradePrice()) != null) {
                object3 = ((TradePriceType)iExplicitlyCloneable5).getAppliedTradeAllowanceCharge().iterator();
                while (object3.hasNext()) {
                    iExplicitlyCloneable4 = (TradeAllowanceChargeType)object3.next();
                    object2 = ETriState.UNDEFINED;
                    if (((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator() != null) {
                        object2 = CIIToUBL22Converter.parseIndicator(((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator(), errorList);
                    } else {
                        errorList.add(CIIToUBL22Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "GrossPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!((ETriState)object2).isDefined()) continue;
                    AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                    allowanceChargeType.setChargeIndicator(((ETriState)object2).getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)iExplicitlyCloneable4, allowanceChargeType, (String)object6);
                    ((PriceType)object4).addAllowanceCharge(allowanceChargeType);
                }
            }
            if (bl) {
                creditNoteLineType.setPrice((PriceType)object4);
            }
            creditNoteLineType.setItem((ItemType)object5);
            creditNoteType.addCreditNoteLine(creditNoteLineType);
        }
        return creditNoteType;
    }

    @Override
    @Nullable
    public Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIIInvoice");
        ValueEnforcer.notNull(errorList, "ErrorList");
        switch (this.getUBLCreationMode()) {
            case AUTOMATIC: {
                ETriState eTriState = CIIToUBL22Converter.isInvoiceType(crossIndustryInvoiceType, errorList);
                return eTriState.getAsBooleanValue(true) ? this.convertToInvoice(crossIndustryInvoiceType, errorList) : this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
            case INVOICE: {
                return this.convertToInvoice(crossIndustryInvoiceType, errorList);
            }
            case CREDIT_NOTE: {
                return this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
        }
        throw new IllegalStateException("Unsupported creation mode");
    }
}

