/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.commons.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IHasLastModificationDateTime {
    @Nullable
    public LocalDateTime getLastModificationDateTime();

    default public boolean hasLastModificationDateTime() {
        return this.getLastModificationDateTime() != null;
    }

    @Nullable
    default public LocalDate getLastModificationDate() {
        LocalDateTime localDateTime = this.getLastModificationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nullable
    default public LocalTime getLastModificationTime() {
        LocalDateTime localDateTime = this.getLastModificationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isLastModifiedAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "LocalDateTime");
        return this.hasLastModificationDateTime() && this.getLastModificationDateTime().compareTo(localDateTime) <= 0;
    }
}

