/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;

@XmlRootElement(name="item")
public class ItemDetails {
    static final ItemDetails DEFAULT = new ItemDetails();
    @XmlElement
    private final String name;
    @XmlAttribute
    private final long size;

    private ItemDetails() {
        this("unknown");
    }

    private ItemDetails(String name) {
        this(name, -1L);
    }

    private ItemDetails(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public static ItemDetails fromFile(File file) {
        return ItemDetails.fromValues(file.getAbsolutePath(), file.length());
    }

    public static ItemDetails fromValues(String name) {
        return ItemDetails.fromValues(name, -1L);
    }

    public static ItemDetails fromValues(String name, long size) {
        if (name == null) {
            throw new NullPointerException("Parameter name can not be null.");
        }
        return new ItemDetails(name, size);
    }

    public static ItemDetails defaultInstance() {
        return DEFAULT;
    }
}

