/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Objects;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.Components;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskType;

@XmlRootElement(name="taskException")
class TaskResultImpl
implements TaskResult {
    private static final VeraPDFException notExecutedExcept = new VeraPDFException("Not Executed");
    private static final TaskResult defaultInstance = new TaskResultImpl();
    private static final String EXCEPTION = "Exception: ";
    private static final String CAUSED_BY = " caused by exception: ";
    private final VeraPDFException exception;
    @XmlAttribute
    private final TaskType type;
    @XmlAttribute
    private final boolean isExecuted;
    @XmlAttribute
    private final boolean isSuccess;
    @XmlElement
    private final AuditDuration duration;

    @XmlElement
    public String getExceptionMessage() {
        if (this.exception == null) {
            return null;
        }
        Throwable e = this.exception;
        StringBuilder res = new StringBuilder(EXCEPTION + e.getMessage());
        for (e = e.getCause(); e != null; e = e.getCause()) {
            res.append(CAUSED_BY).append(e.getMessage());
        }
        return res.toString();
    }

    private TaskResultImpl() {
        this(TaskType.NONE, false, false, Components.defaultDuration(), notExecutedExcept);
    }

    private TaskResultImpl(TaskType type, AuditDuration duration) {
        this(type, true, true, duration, null);
    }

    private TaskResultImpl(TaskType type, AuditDuration duration, VeraPDFException exception) {
        this(type, true, false, duration, exception);
    }

    private TaskResultImpl(TaskType type, boolean isExecuted, boolean isSuccess, AuditDuration duration, VeraPDFException exception) {
        this.type = type;
        this.isExecuted = isExecuted;
        this.isSuccess = isSuccess;
        this.duration = duration;
        this.exception = exception;
    }

    @Override
    public TaskType getType() {
        return this.type;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public VeraPDFException getException() {
        return this.exception;
    }

    @Override
    public boolean isExecuted() {
        return this.isExecuted;
    }

    @Override
    public AuditDuration getDuration() {
        return this.duration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.isExecuted ? 1231 : 1237);
        result = 31 * result + (this.isSuccess ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskResultImpl)) {
            return false;
        }
        TaskResultImpl other = (TaskResultImpl)obj;
        if (this.type != other.type) {
            return false;
        }
        if (!Objects.equals(this.duration, other.duration)) {
            return false;
        }
        if (!Objects.equals(this.exception, other.exception)) {
            return false;
        }
        if (this.isExecuted != other.isExecuted) {
            return false;
        }
        return this.isSuccess == other.isSuccess;
    }

    static TaskResult defaultInstance() {
        return defaultInstance;
    }

    static TaskResult fromValues(TaskType type, AuditDuration duration) {
        return new TaskResultImpl(type, duration);
    }

    static TaskResult fromValues(TaskType type, AuditDuration duration, VeraPDFException exception) {
        return new TaskResultImpl(type, duration, exception);
    }

    static class Adapter
    extends XmlAdapter<TaskResultImpl, TaskResult> {
        Adapter() {
        }

        @Override
        public TaskResult unmarshal(TaskResultImpl procResultImpl) {
            return procResultImpl;
        }

        @Override
        public TaskResultImpl marshal(TaskResult procResult) {
            return (TaskResultImpl)procResult;
        }
    }
}

