/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.parsers.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.verapdf.pdfa.parsers.pkcs7.DEREncodedValue;
import org.verapdf.pdfa.parsers.pkcs7.IndefiniteLengthConverter;
import org.verapdf.pdfa.parsers.pkcs7.InputBuffer;

public class DEREncodedInputStream {
    private byte valueTag;
    protected InputBuffer inputBuffer;

    public DEREncodedInputStream(byte[] data) throws IOException {
        int len = data.length;
        if (data.length < 2) {
            throw new IOException("Byte array is too short");
        }
        if (IndefiniteLengthConverter.isIndefinite(data[1])) {
            byte[] bytes = new byte[len];
            System.arraycopy(data, 0, bytes, 0, len);
            byte[] convertedBytes = new IndefiniteLengthConverter().convertBytes(bytes);
            if (convertedBytes == null) {
                throw new IOException("Error resolving indefinite length BER");
            }
            this.inputBuffer = new InputBuffer(convertedBytes);
        } else {
            this.inputBuffer = new InputBuffer(data);
        }
        this.inputBuffer.mark(Integer.MAX_VALUE);
    }

    public DEREncodedInputStream(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
        this.inputBuffer.mark(Integer.MAX_VALUE);
    }

    public DEREncodedValue getDEREncodedValue() throws IOException {
        return new DEREncodedValue(this.inputBuffer);
    }

    public byte[] getOID() throws IOException {
        byte tag = (byte)(0xFF & this.inputBuffer.read());
        if (tag == 6) {
            int length = DEREncodedInputStream.getDefLength(this.inputBuffer);
            if (length > this.available()) {
                throw new IOException("OID: length = " + length + " is greater than data available = " + this.available());
            }
            byte[] oid = new byte[length];
            if (oid.length != 0 && this.inputBuffer.read(oid) != oid.length) {
                throw new IOException("OID: Invalid read of DER bytes sequence");
            }
            if (length < 1 || (oid[length - 1] & 0x80) != 0) {
                throw new IOException("OID: DER encoding is not ended");
            }
            for (int i = 0; i < length; ++i) {
                if (oid[i] != -128 || i != 0 && (oid[i - 1] & 0x80) != 0) continue;
                throw new IOException("OID: DER encoding contains extra bytes");
            }
            return oid;
        }
        throw new IOException("OID: invalid object ID tag: " + tag);
    }

    public void getBigInteger() throws IOException {
        if (this.inputBuffer.read() != 2) {
            throw new IOException("Invalid integer tag in DER");
        }
        this.inputBuffer.getBigInteger(DEREncodedInputStream.getDefLength(this.inputBuffer));
    }

    public DEREncodedValue[] getSequence(int len) throws IOException {
        this.valueTag = (byte)this.inputBuffer.read();
        if (this.valueTag == 48) {
            return this.readValues(len);
        }
        throw new IOException("Invalid sequence tag in DER");
    }

    public DEREncodedValue[] getSet(int len) throws IOException {
        return this.getSet(len, false);
    }

    public DEREncodedValue[] getSet(int len, boolean implicit) throws IOException {
        this.valueTag = (byte)this.inputBuffer.read();
        if (this.valueTag == 49 || implicit) {
            return this.readValues(len);
        }
        throw new IOException("Invalid set tag in DER");
    }

    public DEREncodedInputStream getSubStream(int len) throws IOException {
        InputBuffer buffer = this.inputBuffer.dup();
        buffer.truncate(len);
        this.inputBuffer.skip(len);
        return new DEREncodedInputStream(buffer);
    }

    public int peekByte() throws IOException {
        return this.inputBuffer.peek();
    }

    public void mark(int value) {
        this.inputBuffer.mark(value);
    }

    public void reset() {
        this.inputBuffer.reset();
    }

    public int available() {
        return this.inputBuffer.available();
    }

    protected DEREncodedValue[] readValues(int len) throws IOException {
        byte lengthByte = (byte)this.inputBuffer.read();
        int length = DEREncodedInputStream.getLength(lengthByte, this.inputBuffer);
        if (length == -1) {
            this.inputBuffer = new InputBuffer(IndefiniteLengthConverter.convertStream(this.inputBuffer, lengthByte, this.valueTag));
            if (this.valueTag != this.inputBuffer.read()) {
                throw new IOException("Data length is indefinite");
            }
            length = DEREncodedInputStream.getDefLength(this.inputBuffer);
        }
        if (length == 0) {
            return new DEREncodedValue[0];
        }
        DEREncodedInputStream newStr = this.inputBuffer.available() == length ? this : this.getSubStream(length);
        ArrayList<DEREncodedValue> values = new ArrayList<DEREncodedValue>(len);
        do {
            values.add(new DEREncodedValue(newStr.inputBuffer));
        } while (newStr.available() > 0);
        if (newStr.available() != 0) {
            throw new IOException("Values contain extra data");
        }
        DEREncodedValue[] result = new DEREncodedValue[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (DEREncodedValue)values.get(i);
        }
        return result;
    }

    static int getDefLength(InputStream in) throws IOException {
        int length = DEREncodedInputStream.getLength(in.read(), in);
        if (length >= 0) {
            return length;
        }
        throw new IOException("Data length is indefinite");
    }

    static int getLength(int lengthByteValue, InputStream in) throws IOException {
        int resultValue;
        int lengthByte = lengthByteValue;
        if (lengthByte == -1) {
            throw new IOException("Invalid DER length");
        }
        if ((lengthByte & 0x80) == 0) {
            resultValue = lengthByte;
        } else {
            if ((lengthByte &= 0x7F) == 0) {
                return -1;
            }
            if (lengthByte > 4) {
                throw new IOException("Length tag = " + lengthByte + " is too big");
            }
            resultValue = 0xFF & in.read();
            if (resultValue == 0) {
                throw new IOException("DER requires length value to be encoded in minimum number of bytes. Redundant length bytes found");
            }
            while (--lengthByte > 0) {
                resultValue <<= 8;
                resultValue += 0xFF & in.read();
            }
            if (resultValue < 0) {
                throw new IOException("Invalid length bytes in DER");
            }
            if (resultValue <= 127) {
                throw new IOException("DER requires length value to be encoded in minimum number of bytes. Use short form for length");
            }
        }
        return resultValue;
    }
}

