/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDSpecialColorSpace;

public class PDIndexed
extends PDSpecialColorSpace {
    private static final Logger LOGGER = Logger.getLogger(PDIndexed.class.getCanonicalName());

    public PDIndexed(COSObject obj) {
        this(obj, null);
    }

    public PDIndexed(COSObject obj, PDResources resources) {
        super(obj, resources, false);
    }

    public PDColorSpace getBase() {
        return super.getBaseColorSpace();
    }

    @Override
    protected COSObject getBaseColorSpaceObject() {
        return this.getObject().at(1);
    }

    public Long getHival() {
        return this.getObject().at(2).getInteger();
    }

    public ASInputStream getLookup() {
        COSObject object = this.getObject().at(3);
        if (object != null) {
            COSObjType type = object.getType();
            if (type == COSObjType.COS_STRING) {
                return new ASMemoryInStream(object.getString().getBytes(StandardCharsets.ISO_8859_1));
            }
            if (type == COSObjType.COS_STREAM) {
                return object.getData(COSStream.FilterFlags.DECODE);
            }
        }
        return null;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.INDEXED;
    }

    @Override
    public double[] toRGB(double[] value) {
        if (value.length > 1) {
            throw new IllegalArgumentException("Indexed color spaces must have one color value");
        }
        int index = (int)Math.round(value[0]);
        index = Math.max(index, 0);
        index = Math.min(index, this.getHival().intValue());
        int lookupDataLength = (int)((long)this.getBaseColorSpace().getNumberOfComponents() * (this.getHival() + 1L));
        int maxIndex = (int)Math.min(this.getHival(), 255L);
        int numComponents = this.getBaseColorSpace().getNumberOfComponents();
        if (lookupDataLength / numComponents < maxIndex + 1) {
            maxIndex = lookupDataLength / numComponents - 1;
        }
        double[][] colorTable = new double[maxIndex + 1][numComponents];
        try {
            for (int i = 0; i <= maxIndex; ++i) {
                for (int c = 0; c < numComponents; ++c) {
                    colorTable[i][c] = (double)(this.getLookup().read() & 0xFF) / 255.0;
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading color table for PDIndexed", e);
        }
        return this.getBaseColorSpace().toRGB(colorTable[index]);
    }
}

