/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.external.ICCProfile;
import org.verapdf.pd.PDObject;

public class PDOutputIntent
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDOutputIntent.class.getCanonicalName());

    public PDOutputIntent(COSObject obj) {
        super(obj);
        if (this.getOutputConditionIdentifier() == null) {
            LOGGER.log(Level.WARNING, "Missing OutputConditionIdentifier in an output intent dictionary");
        }
    }

    public String getOutputCondition() {
        return this.getStringValue(ASAtom.OUTPUT_CONDITION);
    }

    public String getOutputConditionIdentifier() {
        return this.getStringValue(ASAtom.OUTPUT_CONDITION_IDENTIFIER);
    }

    public String getRegistryName() {
        return this.getStringValue(ASAtom.REGISTRY_NAME);
    }

    public String getInfo() {
        return this.getStringValue(ASAtom.INFO);
    }

    public String getSubtype() {
        COSObject base = this.getKey(ASAtom.S);
        if (base != null && base.getType() == COSObjType.COS_NAME) {
            return base.getName().getValue();
        }
        return null;
    }

    public String getColorSpace() {
        ICCProfile iccProfile = this.getDestOutputProfile();
        if (iccProfile != null && "GTS_PDFA1".equals(this.getSubtype())) {
            return iccProfile.getColorSpace();
        }
        return null;
    }

    public ICCProfile getDestOutputProfile() {
        COSObject profile = this.getKey(ASAtom.DEST_OUTPUT_PROFILE);
        if (profile != null && profile.getType() == COSObjType.COS_STREAM) {
            return new ICCProfile(profile);
        }
        return null;
    }

    public COSObject getCOSDestOutputProfileRef() {
        return this.getKey(ASAtom.DEST_OUTPUT_PROFILE_REF);
    }

    private String getStringValue(ASAtom key) {
        COSObject base = this.getKey(key);
        if (base != null && base.getType() == COSObjType.COS_STRING) {
            return base.getString();
        }
        return null;
    }

    public String getDestOutputProfileIndirect() {
        COSObject obj = this.getKey(ASAtom.DEST_OUTPUT_PROFILE);
        if (!obj.empty() && obj.isIndirect().booleanValue()) {
            COSKey key = obj.getKey();
            return key.getNumber() + " " + key.getGeneration();
        }
        return null;
    }
}

