/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.signature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.external.GFPKCSDataObject;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.signature.GFPDSigRef;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.pdlayer.PDSigRef;
import org.verapdf.parser.SignatureParser;
import org.verapdf.pd.PDSignature;
import org.verapdf.tools.StaticResources;

public class GFPDSignature
extends GFPDObject
implements org.verapdf.model.pdlayer.PDSignature {
    private static final Logger LOGGER = Logger.getLogger(GFPDSignature.class.getCanonicalName());
    public static final String SIGNATURE_TYPE = "PDSignature";
    public static final String CONTENTS = "Contents";
    public static final String REFERENCE = "Reference";
    protected COSString contents;
    protected long signatureOffset = -1L;

    public GFPDSignature(PDSignature pdSignature, COSObject signatureReference) {
        super(pdSignature, SIGNATURE_TYPE);
        if (signatureReference.isIndirect().booleanValue()) {
            COSKey key = signatureReference.getObjectKey();
            this.signatureOffset = StaticResources.getDocument().getDocument().getOffset(key);
        }
        this.contents = pdSignature.getContents();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Contents": {
                return this.getContents();
            }
            case "Reference": {
                return this.getSigRefs();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PKCSDataObject> getContents() {
        if (this.contents != null) {
            ArrayList<GFPKCSDataObject> list = new ArrayList<GFPKCSDataObject>(1);
            list.add(new GFPKCSDataObject(this.contents));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDSigRef> getSigRefs() {
        COSArray reference = ((PDSignature)this.simplePDObject).getReference();
        if (reference == null || reference.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<GFPDSigRef> list = new ArrayList<GFPDSigRef>();
        for (COSObject sigRef : reference) {
            list.add(new GFPDSigRef((COSDictionary)sigRef.getDirectBase()));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Boolean getdoesByteRangeCoverEntireDocument() {
        try {
            SeekableInputStream pdfSource = StaticResources.getDocument().getPDFSource();
            long offset = pdfSource.getOffset();
            SignatureParser parser = new SignatureParser(pdfSource, StaticResources.getDocument().getDocument());
            long[] actualByteRange = parser.getByteRangeBySignatureOffset(this.signatureOffset);
            int[] byteRange = ((PDSignature)this.simplePDObject).getByteRange();
            pdfSource.seek(offset);
            for (int i = 0; i < 3; ++i) {
                if ((long)byteRange[i] == actualByteRange[i]) continue;
                return Boolean.FALSE;
            }
            int floating = parser.getFloatingBytesNumberForLastByteRangeObtained();
            if (parser.isStreamEnd()) {
                return (long)byteRange[3] == actualByteRange[3];
            }
            return (long)byteRange[3] >= actualByteRange[3] - (long)floating && (long)byteRange[3] <= actualByteRange[3];
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Can't create parser to process digital signature", ex);
            return Boolean.FALSE;
        }
    }
}

