/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.external.JPEG2000;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.external.GFJPEG2000;
import org.verapdf.gf.model.impl.pd.images.GFPDSMaskImage;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.pdlayer.PDSMaskImage;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXObject;

public class GFPDXImage
extends GFPDXObject
implements org.verapdf.model.pdlayer.PDXImage {
    public static final String X_IMAGE_TYPE = "PDXImage";
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";
    public static final String JPX_STREAM = "jpxStream";
    public static final String S_MASK = "SMask";
    private List<org.verapdf.model.external.JPEG2000> jpeg2000List = null;
    private final PDColorSpace inheritedFillCS;

    protected GFPDXImage(PDXImage simplePDObject, PDResourcesHandler resourcesHandler, PDColorSpace inheritedFillCS) {
        this(simplePDObject, resourcesHandler, inheritedFillCS, X_IMAGE_TYPE);
    }

    protected GFPDXImage(PDXImage simplePDObject, PDResourcesHandler resourcesHandler, PDColorSpace inheritedFillCS, String type) {
        super(simplePDObject, resourcesHandler, type);
        this.inheritedFillCS = inheritedFillCS;
    }

    @Override
    public Boolean getInterpolate() {
        return ((PDXImage)this.simplePDObject).isInterpolate();
    }

    @Override
    public Boolean getcontainsAlternates() {
        return this.simplePDObject.knownKey(ASAtom.ALTERNATES);
    }

    @Override
    public Long getBitsPerComponent() {
        return ((PDXImage)this.simplePDObject).getBitsPerComponent();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "jpxStream": {
                return this.getJPXStream();
            }
            case "SMask": {
                return this.getSMask();
            }
        }
        return super.getLinkedObjects(link);
    }

    protected List<PDSMaskImage> getSMask() {
        PDXImage smask = ((PDXObject)this.simplePDObject).getSMask();
        if (smask != null) {
            ArrayList<GFPDSMaskImage> mask = new ArrayList<GFPDSMaskImage>(1);
            mask.add(new GFPDSMaskImage(smask, this.resourcesHandler));
            return Collections.unmodifiableList(mask);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getIntent() {
        COSName intent = ((PDXImage)this.simplePDObject).getIntent();
        if (intent != null) {
            ArrayList<GFCosRenderingIntent> intents = new ArrayList<GFCosRenderingIntent>(1);
            intents.add(new GFCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getImageCS() {
        PDXImage image;
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        if (!(image = (PDXImage)this.simplePDObject).getImageMask()) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            ASAtom csName = image.getImageCSName();
            if (csName != null) {
                PDColorSpace colorSpace = this.resourcesHandler.getColorSpace(csName);
                if (colorSpace != null) {
                    colorSpaces.add(ColorSpaceFactory.getColorSpace(colorSpace));
                    return Collections.unmodifiableList(colorSpaces);
                }
            } else {
                PDColorSpace colorSpace = image.getImageCS();
                if (colorSpace != null) {
                    if ((colorSpace = this.resourcesHandler.getColorSpace(colorSpace.getType(), false)) == null) {
                        colorSpace = image.getImageCS();
                    }
                    if (colorSpace != null) {
                        colorSpaces.add(ColorSpaceFactory.getColorSpace(colorSpace));
                        return Collections.unmodifiableList(colorSpaces);
                    }
                }
            }
        } else if (this.inheritedFillCS != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpaces.add(ColorSpaceFactory.getColorSpace(this.inheritedFillCS));
            return Collections.unmodifiableList(colorSpaces);
        }
        return Collections.emptyList();
    }

    private List<? extends org.verapdf.model.pdlayer.PDXImage> getAlternates() {
        List<PDXImage> alternates = ((PDXImage)this.simplePDObject).getAlternates();
        ArrayList<GFPDXImage> res = new ArrayList<GFPDXImage>(alternates.size());
        for (PDXImage image : alternates) {
            res.add(new GFPDXImage(image, this.resourcesHandler, this.inheritedFillCS));
        }
        return res;
    }

    private List<org.verapdf.model.external.JPEG2000> getJPXStream() {
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        return this.jpeg2000List;
    }

    private List<org.verapdf.model.external.JPEG2000> parseJPXStream() {
        JPEG2000 jpeg = ((PDXImage)this.simplePDObject).getJPXStream();
        if (jpeg != null) {
            COSObject colorSpace = this.simplePDObject.getKey(ASAtom.COLORSPACE);
            ArrayList<GFJPEG2000> list = new ArrayList<GFJPEG2000>(1);
            list.add(new GFJPEG2000(jpeg, colorSpace != null && !colorSpace.empty() && colorSpace.getType() != COSObjType.COS_NULL));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public boolean containsTransparency() {
        COSObject smask = this.simplePDObject.getKey(ASAtom.SMASK);
        return smask != null && smask.getType() == COSObjType.COS_STREAM || ((PDXImage)this.simplePDObject).getSMaskInData() > 0;
    }
}

