/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosStream;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.axl.AXLMainXMPPackage;
import org.verapdf.model.impl.axl.AXLXMPPackage;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class GFPDMetadata
extends GFPDObject
implements org.verapdf.model.pdlayer.PDMetadata {
    private static final Logger LOGGER = Logger.getLogger(GFPDMetadata.class.getCanonicalName());
    public static final String METADATA_TYPE = "PDMetadata";
    public static final String XMP_PACKAGE = "XMPPackage";
    public static final String STREAM = "stream";
    private final boolean isMainMetadata;
    private final PDMetadata mainMetadata;

    public GFPDMetadata(PDMetadata simplePDObject, Boolean isMainMetadata) {
        super(simplePDObject, METADATA_TYPE);
        this.isMainMetadata = isMainMetadata;
        this.mainMetadata = StaticResources.getDocument() != null && StaticResources.getDocument().getCatalog() != null && StaticResources.getDocument().getCatalog().getMetadata() != null ? StaticResources.getDocument().getCatalog().getMetadata() : null;
    }

    @Override
    public String getFilter() {
        List<ASAtom> filters = ((PDMetadata)this.simplePDObject).getFilters();
        if (filters != null && !filters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (ASAtom filter : filters) {
                result.append(filter.getValue()).append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "XMPPackage": {
                return this.getXMPPackage();
            }
            case "stream": {
                return this.getStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<XMPPackage> getXMPPackage() {
        ArrayList<XMPPackage> xmp;
        block17: {
            xmp = new ArrayList<XMPPackage>(1);
            PDFAFlavour flavour = StaticContainers.getFlavour();
            try (InputStream stream = ((PDMetadata)this.simplePDObject).getStream();){
                if (stream == null) break block17;
                VeraPDFMeta metadata = VeraPDFMeta.parse(stream);
                if (this.isMainMetadata) {
                    xmp.add(new AXLMainXMPPackage(metadata, true, flavour));
                    break block17;
                }
                if (flavour != null && flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) break block17;
                VeraPDFXMPNode mainExtensionNode = null;
                try (InputStream mainStream = this.mainMetadata != null ? this.mainMetadata.getStream() : null;){
                    if (mainStream != null) {
                        VeraPDFMeta mainMeta = VeraPDFMeta.parse(mainStream);
                        mainExtensionNode = mainMeta.getExtensionSchemasNode();
                    }
                    xmp.add(new AXLXMPPackage(metadata, true, mainExtensionNode, flavour));
                }
            }
            catch (IOException | XMPException e) {
                LOGGER.log(Level.WARNING, "Problems with parsing metadata. " + e.getMessage(), e);
                if (this.isMainMetadata) {
                    xmp.add(new AXLMainXMPPackage(null, false, flavour));
                }
                if (flavour != null && flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) break block17;
                xmp.add(new AXLXMPPackage(null, false, null, flavour));
            }
        }
        return xmp;
    }

    private List<CosStream> getStream() {
        COSStream stream = ((PDMetadata)this.simplePDObject).getCOSStream();
        if (stream != null) {
            ArrayList<GFCosStream> streams = new ArrayList<GFCosStream>(1);
            streams.add(new GFCosStream(stream));
            return Collections.unmodifiableList(streams);
        }
        return Collections.emptyList();
    }
}

