/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public abstract class AbstractFeaturesExtractor {
    private final FeatureObjectType type;
    private ExtractorDetails details = new ExtractorDetails();
    private Map<String, String> attributes = new HashMap<String, String>();

    AbstractFeaturesExtractor(FeatureObjectType type) {
        this.type = type;
    }

    public final void initialize(ExtractorDetails initialDetails) {
        this.initialize(initialDetails, Collections.emptyMap());
    }

    public final void initialize(ExtractorDetails initialDetails, Map<String, String> initialAttributes) {
        if (initialDetails == null) {
            throw new IllegalArgumentException("Argument details shall not be null");
        }
        if (initialAttributes == null) {
            throw new IllegalArgumentException("Argument attributes shall not be null");
        }
        this.details = initialDetails;
        this.attributes = new HashMap<String, String>(initialAttributes);
    }

    abstract List<FeatureTreeNode> getFeatures(FeaturesData var1);

    public final FeatureObjectType getType() {
        return this.type;
    }

    public ExtractorDetails getDetails() {
        return this.details;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static final class ExtractorDetails {
        private final String name;
        private final String version;
        private final String description;

        public ExtractorDetails(String name, String version, String description) {
            this.name = name;
            this.version = version;
            this.description = description;
        }

        public ExtractorDetails() {
            this("", "", "");
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

