/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.ValidationResultItem;
import org.slf4j.Logger;

public class ValidationContext {
    protected Vector<ValidationResultItem> results;
    protected String customXML = "";
    private String format = "CII";
    private String generation = null;
    private String profile = null;
    private String signature = null;
    private boolean isValid = true;
    private boolean hasPDF = false;
    protected Logger logger;
    private String filename;

    public ValidationContext(Logger log) {
        this.logger = log;
        this.results = new Vector();
    }

    public void setHasPDF() {
        this.hasPDF = true;
    }

    public boolean hasPDF() {
        return this.hasPDF;
    }

    public void addResultItem(ValidationResultItem vr) throws IrrecoverableValidationError {
        this.results.add(vr);
        if (vr.getSeverity() == ESeverity.fatal || vr.getSeverity() == ESeverity.exception || vr.getSeverity() == ESeverity.error) {
            this.isValid = false;
        }
        if (this.logger != null) {
            if (vr.getSeverity() == ESeverity.fatal || vr.getSeverity() == ESeverity.exception) {
                this.logger.error("Fatal Error {}: {}", (Object)vr.getSection(), (Object)vr.getMessage());
            } else if (vr.getSeverity() == ESeverity.error) {
                this.logger.error("Error {}: {}", (Object)vr.getSection(), (Object)vr.getMessage());
            } else if (vr.getSeverity() == ESeverity.warning) {
                this.logger.warn("Warning {}: {}", (Object)vr.getSection(), (Object)vr.getMessage());
            } else if (vr.getSeverity() == ESeverity.notice) {
                this.logger.info("Notice {}: {}", (Object)vr.getSection(), (Object)vr.getMessage());
            }
        }
        if (vr.getSeverity() == ESeverity.fatal || vr.getSeverity() == ESeverity.exception) {
            throw new IrrecoverableValidationError(vr.getMessage());
        }
    }

    public void clearCustomXML() {
        this.customXML = "";
    }

    public void addCustomXML(String XML2) {
        this.customXML = this.customXML + XML2;
    }

    public String getCustomXML() {
        return this.customXML;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public ValidationContext setGeneration(String version) {
        this.generation = version;
        return this;
    }

    public ValidationContext setProfile(String profile) {
        this.profile = profile.trim();
        return this;
    }

    public ValidationContext setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public String getGeneration() {
        return this.generation;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void clear() {
        this.results.clear();
        this.isValid = true;
        this.clearCustomXML();
        this.generation = null;
        this.profile = null;
        this.signature = null;
    }

    public String getXMLResult() {
        StringBuilder res = new StringBuilder(this.getCustomXML());
        if (this.results != null && !this.results.isEmpty()) {
            res.append("<messages>");
            for (ValidationResultItem validationResultItem : this.results) {
                res.append(validationResultItem.getXMLOnce()).append("\n");
            }
            res.append("</messages>");
        }
        res.append("<summary status=\"").append(this.isValid ? "valid" : "invalid").append("\"/>");
        return res.toString();
    }

    public String getCSVResult() {
        ArrayList<String> errorcodes = new ArrayList<String>();
        for (ValidationResultItem validationResultItem : this.results) {
            String errorCodeStr = Integer.toString(validationResultItem.getSection());
            errorcodes.add(errorCodeStr);
        }
        return String.join((CharSequence)",", errorcodes);
    }

    public String getCSVIDResult() {
        ArrayList<String> errorIDs = new ArrayList<String>();
        for (ValidationResultItem validationResultItem : this.results) {
            if (validationResultItem.getID().isEmpty()) continue;
            String errorID = validationResultItem.getID();
            errorIDs.add(errorID);
        }
        return String.join((CharSequence)",", errorIDs);
    }

    public void setInvalid() {
        this.isValid = false;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        if (this.filename == null) {
            return "";
        }
        return this.filename;
    }

    public String getFormat() {
        return this.format;
    }

    public List<ValidationResultItem> getResults() {
        return this.results;
    }
}

