/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.ReferencedDocument;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;

public class OXPullProvider
extends ZUGFeRD2PullProvider {
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName(EStandard.orderx, "basic", 1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = XMLTools.encodeXML(trans.getPaymentTermDescription());
        }
        if (this.paymentTermsDescription == null && !"384".equals(trans.getDocumentCode())) {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        String typecode = "220";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rsm:SCRDMCCBDACIOMessageStructure\nxmlns:rsm=\"urn:un:unece:uncefact:data:SCRDMCCBDACIOMessageStructure:100\"\nxmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:128\"\nxmlns:qdt=\"urn:un:unece:uncefact:data:standard:QualifiedDataType:128\"\nxmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:128\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><rsm:ExchangedDocumentContext><ram:BusinessProcessSpecifiedDocumentContextParameter><ram:ID>A1</ram:ID></ram:BusinessProcessSpecifiedDocumentContextParameter><ram:GuidelineSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:GuidelineSpecifiedDocumentContextParameter></rsm:ExchangedDocumentContext><rsm:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>220</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + this.buildNotes(trans) + "</rsm:ExchangedDocument><rsm:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                // empty if block
            }
            LineCalculator lineCalculator = currentItem.getCalculation();
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID>" + this.buildItemNotes(currentItem) + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            Object allowanceChargeStr = "";
            if (currentItem.getItemAllowances() != null) {
                for (IZUGFeRDAllowanceCharge allowance : currentItem.getItemAllowances()) {
                    allowanceChargeStr = (String)allowanceChargeStr + this.getAllowanceChargeStr(allowance, currentItem);
                }
            }
            if (currentItem.getItemCharges() != null) {
                for (IZUGFeRDAllowanceCharge charge : currentItem.getItemCharges()) {
                    allowanceChargeStr = (String)allowanceChargeStr + this.getAllowanceChargeStr(charge, currentItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeAgreement>";
            if (currentItem.getBuyerOrderReferencedDocumentLineID() != null) {
                xml = xml + "<ram:BuyerOrderReferencedDocument> \n<ram:LineID>" + XMLTools.encodeXML(currentItem.getBuyerOrderReferencedDocumentLineID()) + "</ram:LineID></ram:BuyerOrderReferencedDocument>";
            }
            xml = xml + "<ram:GrossPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lineCalculator.getPriceGross()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity>" + (String)allowanceChargeStr + "</ram:GrossPriceProductTradePrice><ram:NetPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lineCalculator.getPrice()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:NetPriceProductTradePrice></ram:SpecifiedLineTradeAgreement><ram:SpecifiedLineTradeDelivery><ram:RequestedQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:RequestedQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement><ram:ApplicableTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + currentItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentItem.getProduct().getVATPercent()) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
            if (currentItem.getDetailedDeliveryPeriodFrom() != null || currentItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (currentItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (currentItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lineCalculator.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "<ram:ContractReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID></ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment f : trans.getAdditionalReferencedDocuments()) {
                String string = Base64.getEncoder().encodeToString(f.getData());
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + f.getFilename() + "</ram:IssuerAssignedID><ram:TypeCode>916</ram:TypeCode><ram:Name>" + f.getDescription() + "</ram:Name><ram:AttachmentBinaryObject mimeCode=\"" + f.getMimetype() + "\"\nfilename=\"" + f.getFilename() + "\">" + string + "</ram:AttachmentBinaryObject></ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "<ram:SpecifiedProcuringProject><ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "<ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "</ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement><ram:ApplicableHeaderTradeDelivery>";
        IZUGFeRDExportableTradeParty deliveryAddress = this.trans.getDeliveryAddress();
        if (deliveryAddress == null) {
            deliveryAddress = this.trans.getRecipient();
        }
        xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(deliveryAddress, false, true) + "</ram:ShipToTradeParty>";
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>\n<ram:ApplicableHeaderTradeSettlement><ram:OrderCurrencyCode>" + trans.getCurrency() + "</ram:OrderCurrencyCode>";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlementPayment iZUGFeRDTradeSettlementPayment : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlementPayment == null) continue;
                hasDueDate = true;
                break;
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null || !(iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment)) continue;
                hasDueDate = true;
            }
        }
        if (trans.getDocumentCode() != null && trans.getDocumentCode().equals("384")) {
            hasDueDate = false;
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = (VATAmount)VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
        }
        if (trans.getDetailedDeliveryPeriodFrom() != null || trans.getDetailedDeliveryPeriodTo() != null) {
            xml = xml + "<ram:BillingSpecifiedPeriod>";
            if (trans.getDetailedDeliveryPeriodFrom() != null) {
                xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
            }
            if (trans.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
            }
            xml = xml + "</ram:BillingSpecifiedPeriod>";
        }
        if (trans.getZFCharges() != null && trans.getZFCharges().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getChargesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + " <ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>true</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getChargesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getChargeReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
            }
        }
        if (trans.getZFAllowances() != null && trans.getZFAllowances().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getAllowancesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>false</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getAllowanceReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>\t\n";
            }
        }
        if (trans.getPaymentTerms() == null && (this.paymentTermsDescription != null || trans.getTradeSettlement() != null || hasDueDate)) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms>";
            if (this.paymentTermsDescription != null) {
                xml = xml + "<ram:Description>" + this.paymentTermsDescription + "</ram:Description>";
            }
            if (trans.getTradeSettlement() != null) {
                void var12_33;
                IZUGFeRDTradeSettlement[] iZUGFeRDTradeSettlementArray = trans.getTradeSettlement();
                int currentTaxPercent = iZUGFeRDTradeSettlementArray.length;
                boolean bl = false;
                while (var12_33 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = iZUGFeRDTradeSettlementArray[var12_33];
                    if (payment == null || payment instanceof IZUGFeRDTradeSettlementDebit) {
                        // empty if block
                    }
                    ++var12_33;
                }
            }
            xml = xml + "</ram:SpecifiedTradePaymentTerms>";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        String allowanceTotalLine = "<ram:AllowanceTotalAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(null)) + "</ram:AllowanceTotalAmount>";
        String chargesTotalLine = "<ram:ChargeTotalAmount>" + this.currencyFormat(this.calc.getChargesForPercent(null)) + "</ram:ChargeTotalAmount>";
        xml = xml + "<ram:SpecifiedTradeSettlementHeaderMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>" + chargesTotalLine + allowanceTotalLine + "<ram:TaxBasisTotalAmount>" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount><ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount><ram:GrandTotalAmount>" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount></ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (trans.getInvoiceReferencedDocumentID() != null) {
            xml = xml + "<ram:InvoiceReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getInvoiceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            if (trans.getInvoiceReferencedIssueDate() != null) {
                xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(trans.getInvoiceReferencedIssueDate()) + "</ram:FormattedIssueDateTime>";
            }
            xml = xml + "</ram:InvoiceReferencedDocument>";
        }
        if (trans.getInvoiceReferencedDocuments() != null) {
            for (ReferencedDocument doc : trans.getInvoiceReferencedDocuments()) {
                xml = xml + "<ram:InvoiceReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(doc.getIssuerAssignedID()) + "</ram:IssuerAssignedID>";
                if (doc.getFormattedIssueDateTime() != null) {
                    xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(doc.getFormattedIssueDateTime()) + "</ram:FormattedIssueDateTime>";
                }
                xml = xml + "</ram:InvoiceReferencedDocument>";
            }
        }
        xml = xml + "</ram:ApplicableHeaderTradeSettlement>";
        xml = xml + "</rsm:SupplyChainTradeTransaction></rsm:SCRDMCCBDACIOMessageStructure>";
        byte[] byArray = xml.getBytes(StandardCharsets.UTF_8);
        this.zugferdData = XMLTools.removeBOM(byArray);
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms[] paymentTerms = this.trans.getExtendedPaymentTerms();
        Object paymentTermsXml = "";
        if (paymentTerms == null || paymentTerms.length == 0) {
            return "";
        }
        for (IZUGFeRDPaymentTerms pt : paymentTerms) {
            paymentTermsXml = (String)paymentTermsXml + "<ram:SpecifiedTradePaymentTerms>";
            IZUGFeRDPaymentDiscountTerms discountTerms = pt.getDiscountTerms();
            paymentTermsXml = (String)paymentTermsXml + "<ram:Description>" + pt.getDescription() + "</ram:Description>";
            if (discountTerms != null) {
                paymentTermsXml = (String)paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
                String currency = this.trans.getCurrency();
                String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
                paymentTermsXml = (String)paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
                paymentTermsXml = (String)paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
                if (discountTerms.getBaseDate() != null) {
                    Date baseDate = discountTerms.getBaseDate();
                    paymentTermsXml = (String)paymentTermsXml + "<ram:BasisDateTime>";
                    paymentTermsXml = (String)paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                    paymentTermsXml = (String)paymentTermsXml + "</ram:BasisDateTime>";
                    paymentTermsXml = (String)paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
                }
                paymentTermsXml = (String)paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
            }
            paymentTermsXml = (String)paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        }
        return paymentTermsXml;
    }
}

