/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Charge
implements IZUGFeRDAllowanceCharge {
    protected BigDecimal percent = null;
    protected BigDecimal totalAmount;
    protected BigDecimal basisAmount;
    protected BigDecimal taxPercent;
    protected String reason;
    protected String reasonCode;
    protected String categoryCode;

    public Charge() {
        this.taxPercent = BigDecimal.ZERO;
    }

    public Charge(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Charge setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public Charge setPercent(BigDecimal percent) {
        this.percent = percent;
        return this;
    }

    public Charge setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
        return this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public Charge setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public BigDecimal getBasisAmount() {
        return this.basisAmount;
    }

    public Charge setBasisAmount(BigDecimal basis) {
        this.basisAmount = basis;
        return this;
    }

    @Override
    public String getReasonCode() {
        return this.reasonCode;
    }

    public Charge setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Override
    public BigDecimal getTotalAmount(IAbsoluteValueProvider currentItem) {
        if (this.totalAmount != null) {
            return this.totalAmount;
        }
        if (this.percent != null) {
            BigDecimal singlePrice = currentItem.getValue().multiply(BigDecimal.ONE.subtract(this.getPercent().divide(new BigDecimal(100), 18, RoundingMode.HALF_UP)));
            BigDecimal singlePriceDiff = currentItem.getValue().subtract(singlePrice);
            return singlePriceDiff.multiply(currentItem.getQuantity());
        }
        throw new RuntimeException("percent must be set");
    }

    public BigDecimal getTotalAmount() {
        if (this.totalAmount != null) {
            return this.totalAmount;
        }
        if (this.percent == null) {
            throw new RuntimeException("totalAmount must be set");
        }
        return null;
    }

    @Override
    public BigDecimal getPercent() {
        return this.percent;
    }

    @Override
    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    @Override
    @JsonIgnore
    public boolean isCharge() {
        return true;
    }

    @Override
    public String getCategoryCode() {
        if (this.categoryCode != null) {
            return this.categoryCode;
        }
        return IZUGFeRDAllowanceCharge.super.getCategoryCode();
    }

    public Charge setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
        return this;
    }
}

