/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import com.helger.commons.text.ReadOnlyMultilingualText;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistry;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@IsSPIImplementation
@Immutable
public final class MultilingualTextMicroTypeConverterRegistrar
implements IMicroTypeConverterRegistrarSPI {
    @Override
    public void registerMicroTypeConverter(@Nonnull IMicroTypeConverterRegistry iMicroTypeConverterRegistry) {
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(ReadOnlyMultilingualText.class, new ReadOnlyMultilingualTextConverter());
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(MultilingualText.class, new MultilingualTextConverter());
    }

    public static final class ReadOnlyMultilingualTextConverter
    extends AbstractMLTConverter<ReadOnlyMultilingualText> {
        @Override
        @Nonnull
        public ReadOnlyMultilingualText convertToNative(@Nonnull IMicroElement iMicroElement) {
            return new ReadOnlyMultilingualText(ReadOnlyMultilingualTextConverter.convertToMLT(iMicroElement));
        }
    }

    public static final class MultilingualTextConverter
    extends AbstractMLTConverter<MultilingualText> {
        @Override
        @Nonnull
        public MultilingualText convertToNative(@Nonnull IMicroElement iMicroElement) {
            return MultilingualTextConverter.convertToMLT(iMicroElement);
        }
    }

    private static abstract class AbstractMLTConverter<T extends IMultilingualText>
    implements IMicroTypeConverter<T> {
        private static final String ELEMENT_TEXT = "text";
        private static final IMicroQName ATTR_LOCALE = new MicroQName("locale");

        private AbstractMLTConverter() {
        }

        @Override
        @Nonnull
        public final IMicroElement convertToMicroElement(@Nonnull T t, @Nullable String string, @Nonnull @Nonempty String string2) {
            MicroElement microElement = new MicroElement(string, string2);
            for (Map.Entry entry : t.texts().getSortedByKey(Comparator.comparing(Locale::toString)).entrySet()) {
                IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_TEXT);
                iMicroElement.setAttribute(ATTR_LOCALE, ((Locale)entry.getKey()).toString());
                iMicroElement.appendText((CharSequence)entry.getValue());
            }
            return microElement;
        }

        @Nonnull
        protected static MultilingualText convertToMLT(@Nonnull IMicroElement iMicroElement) {
            MultilingualText multilingualText = new MultilingualText();
            LocaleCache localeCache = LocaleCache.getInstance();
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_TEXT)) {
                Locale locale = localeCache.getLocale(iMicroElement2.getAttributeValue(ATTR_LOCALE));
                multilingualText.setText(locale, iMicroElement2.getTextContent());
            }
            return multilingualText;
        }
    }
}

