/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.functional.ITriConsumer;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMicroAttributeContainer<IMPLTYPE extends IMicroAttributeContainer<IMPLTYPE>>
extends IMicroNode {
    public boolean hasAttributes();

    public boolean hasNoAttributes();

    @Nonnegative
    public int getAttributeCount();

    default public boolean hasAttribute(@Nullable String string) {
        return this.hasAttribute(null, string);
    }

    default public boolean hasAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return false;
        }
        return this.hasAttribute(new MicroQName(string, string2));
    }

    public boolean hasAttribute(@Nullable IMicroQName var1);

    @Nullable
    default public IMicroAttribute getAttributeObj(@Nullable String string) {
        return this.getAttributeObj(null, string);
    }

    @Nullable
    default public IMicroAttribute getAttributeObj(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        return this.getAttributeObj(new MicroQName(string, string2));
    }

    @Nullable
    public IMicroAttribute getAttributeObj(@Nullable IMicroQName var1);

    @Nullable
    default public String getAttributeValue(@Nullable String string) {
        return this.getAttributeValue(null, string);
    }

    @Nullable
    default public String getAttributeValue(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getAttributeValue(new MicroQName(string, string2));
    }

    @Nullable
    default public String getAttributeValue(@Nullable IMicroQName iMicroQName) {
        IMicroAttribute iMicroAttribute = this.getAttributeObj(iMicroQName);
        return iMicroAttribute == null ? null : iMicroAttribute.getAttributeValue();
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        return this.getAttributeValueWithConversion(null, string, clazz);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable String string, @Nullable String string2, @Nonnull Class<DSTTYPE> clazz) {
        if (string2 == null) {
            return null;
        }
        return this.getAttributeValueWithConversion(new MicroQName(string, string2), clazz);
    }

    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable IMicroQName var1, @Nonnull Class<DSTTYPE> var2);

    default public boolean getAttributeValueAsBool(@Nullable String string, boolean bl) {
        return StringParser.parseBool(this.getAttributeValue(string), bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable String string, @Nullable String string2, boolean bl) {
        return StringParser.parseBool(this.getAttributeValue(string, string2), bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable IMicroQName iMicroQName, boolean bl) {
        return StringParser.parseBool(this.getAttributeValue(iMicroQName), bl);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, double d) {
        return StringParser.parseDouble(this.getAttributeValue(string), d);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, @Nullable String string2, double d) {
        return StringParser.parseDouble(this.getAttributeValue(string, string2), d);
    }

    default public double getAttributeValueAsDouble(@Nullable IMicroQName iMicroQName, double d) {
        return StringParser.parseDouble(this.getAttributeValue(iMicroQName), d);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, float f) {
        return StringParser.parseFloat(this.getAttributeValue(string), f);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, @Nullable String string2, float f) {
        return StringParser.parseFloat(this.getAttributeValue(string, string2), f);
    }

    default public float getAttributeValueAsFloat(@Nullable IMicroQName iMicroQName, float f) {
        return StringParser.parseFloat(this.getAttributeValue(iMicroQName), f);
    }

    default public int getAttributeValueAsInt(@Nullable String string, int n) {
        return StringParser.parseInt(this.getAttributeValue(string), n);
    }

    default public int getAttributeValueAsInt(@Nullable String string, @Nullable String string2, int n) {
        return StringParser.parseInt(this.getAttributeValue(string, string2), n);
    }

    default public int getAttributeValueAsInt(@Nullable IMicroQName iMicroQName, int n) {
        return StringParser.parseInt(this.getAttributeValue(iMicroQName), n);
    }

    default public long getAttributeValueAsLong(@Nullable String string, long l) {
        return StringParser.parseLong(this.getAttributeValue(string), l);
    }

    default public long getAttributeValueAsLong(@Nullable String string, @Nullable String string2, long l) {
        return StringParser.parseLong(this.getAttributeValue(string, string2), l);
    }

    default public long getAttributeValueAsLong(@Nullable IMicroQName iMicroQName, long l) {
        return StringParser.parseLong(this.getAttributeValue(iMicroQName), l);
    }

    @Nullable
    @ReturnsImmutableObject
    public Iterable<? extends IMicroAttribute> getAttributeObjs();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<? extends IMicroAttribute> getAllAttributeObjs();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedMap<IMicroQName, String> getAllQAttributes();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMicroQName> getAllAttributeQNames();

    public void forAllAttributes(@Nonnull Consumer<? super IMicroAttribute> var1);

    public void forAllAttributes(@Nonnull BiConsumer<? super IMicroQName, ? super String> var1);

    public void forAllAttributes(@Nonnull ITriConsumer<? super String, ? super String, ? super String> var1);

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, @Nullable String string2) {
        return this.setAttribute((IMicroQName)new MicroQName(string), string2);
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, @Nullable String string3) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), string3);
    }

    @Nonnull
    public IMPLTYPE setAttribute(@Nonnull IMicroQName var1, @Nullable String var2);

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string), iHasAttributeValue);
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), iHasAttributeValue);
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, @Nonnull IHasAttributeValue iHasAttributeValue) {
        ValueEnforcer.notNull(iHasAttributeValue, "AttrValueProvider");
        return this.setAttribute(iMicroQName, iHasAttributeValue.getAttrValue());
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, boolean bl) {
        return this.setAttribute(string, Boolean.toString(bl));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, boolean bl) {
        return this.setAttribute(string, string2, Boolean.toString(bl));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, boolean bl) {
        return this.setAttribute(iMicroQName, Boolean.toString(bl));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, double d) {
        return this.setAttribute(string, Double.toString(d));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, double d) {
        return this.setAttribute(string, string2, Double.toString(d));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, double d) {
        return this.setAttribute(iMicroQName, Double.toString(d));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, float f) {
        return this.setAttribute(string, Float.toString(f));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, float f) {
        return this.setAttribute(string, string2, Float.toString(f));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, float f) {
        return this.setAttribute(iMicroQName, Float.toString(f));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, int n) {
        return this.setAttribute(string, Integer.toString(n));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, int n) {
        return this.setAttribute(string, string2, Integer.toString(n));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, int n) {
        return this.setAttribute(iMicroQName, Integer.toString(n));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull String string, long l) {
        return this.setAttribute(string, Long.toString(l));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nullable String string, @Nonnull String string2, long l) {
        return this.setAttribute(string, string2, Long.toString(l));
    }

    @Nonnull
    default public IMPLTYPE setAttribute(@Nonnull IMicroQName iMicroQName, long l) {
        return this.setAttribute(iMicroQName, Long.toString(l));
    }

    @Nonnull
    default public IMPLTYPE setAttributeWithConversion(@Nonnull String string, @Nullable Object object) {
        return this.setAttributeWithConversion((IMicroQName)new MicroQName(string), object);
    }

    @Deprecated(forRemoval=false)
    @Nonnull
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttribute is enough")
    default public IMPLTYPE setAttributeWithConversion(@Nonnull String string, @Nullable String string2) {
        return this.setAttribute(string, string2);
    }

    @Nonnull
    default public IMPLTYPE setAttributeWithConversion(@Nullable String string, @Nonnull String string2, @Nullable Object object) {
        return this.setAttributeWithConversion((IMicroQName)new MicroQName(string, string2), object);
    }

    @Deprecated(forRemoval=false)
    @Nonnull
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttribute is enough")
    default public IMPLTYPE setAttributeWithConversion(@Nullable String string, @Nonnull String string2, @Nullable String string3) {
        return this.setAttribute(string, string2, string3);
    }

    @Nonnull
    default public IMPLTYPE setAttributeWithConversion(@Nonnull IMicroQName iMicroQName, @Nullable Object object) {
        String string = TypeConverter.convert(object, String.class);
        return this.setAttribute(iMicroQName, string);
    }

    @Deprecated(forRemoval=false)
    @Nonnull
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttribute is enough")
    default public IMPLTYPE setAttributeWithConversion(@Nonnull IMicroQName iMicroQName, @Nullable String string) {
        return this.setAttribute(iMicroQName, string);
    }

    @Nonnull
    default public EChange removeAttribute(@Nullable String string) {
        return this.removeAttribute(null, string);
    }

    @Nonnull
    default public EChange removeAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        return this.removeAttribute(new MicroQName(string, string2));
    }

    @Nonnull
    public EChange removeAttribute(@Nullable IMicroQName var1);

    @Nonnull
    public EChange removeAllAttributes();
}

