/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.xml.CXML;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.NamedNodeMapIterator;
import com.helger.xml.NodeListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final XMLHelper INSTANCE = new XMLHelper();

    private XMLHelper() {
    }

    @Nullable
    public static Document getOwnerDocument(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    @Nullable
    public static Element getDocumentElement(@Nullable Node node) {
        Document document = XMLHelper.getOwnerDocument(node);
        return document == null ? null : document.getDocumentElement();
    }

    @Nullable
    public static String getNamespaceURI(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getNamespaceURI(((Document)node).getDocumentElement());
        }
        if (node != null) {
            return node.getNamespaceURI();
        }
        return null;
    }

    @Nonnull
    public static String getLocalNameOrTagName(@Nonnull Element element) {
        String string = element.getLocalName();
        if (string == null) {
            string = element.getTagName();
        }
        return string;
    }

    @Nonnull
    public static String getLocalNameOrName(@Nonnull Attr attr) {
        String string = attr.getLocalName();
        if (string == null) {
            string = attr.getName();
        }
        return string;
    }

    @Nullable
    public static String getElementName(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getElementName(((Document)node).getDocumentElement());
        }
        if (node instanceof Element) {
            return XMLHelper.getLocalNameOrTagName((Element)node);
        }
        return null;
    }

    public static boolean hasNoNamespaceURI(@Nonnull Node node) {
        return StringHelper.hasNoText(node.getNamespaceURI());
    }

    public static boolean hasNamespaceURI(@Nullable Node node, @Nullable String string) {
        String string2 = node == null ? null : node.getNamespaceURI();
        return string2 != null && string2.equals(string);
    }

    public static boolean isInlineNode(@Nullable Node node) {
        return node instanceof Text || node instanceof EntityReference;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList nodeList) {
        return nodeList == null || nodeList.getLength() == 0;
    }

    @Nonnull
    public static Predicate<? super Node> filterNodeIsElement() {
        return node -> node != null && node.getNodeType() == 1;
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithNamespace() {
        return element -> element != null && StringHelper.hasText(element.getNamespaceURI());
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithoutNamespace() {
        return element -> element != null && XMLHelper.hasNoNamespaceURI(element);
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithNamespace(@Nullable String string) {
        return element -> element != null && XMLHelper.hasNamespaceURI(element, string);
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithNamespaceAndLocalName(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string2, "LocalName");
        return element -> element != null && XMLHelper.hasNamespaceURI(element, string) && element.getLocalName().equals(string2);
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithTagName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "TagName");
        return element -> EqualsHelper.equals(XMLHelper.getElementName(element), string);
    }

    @Nonnull
    public static Predicate<? super Element> filterElementWithTagNameNoNS(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "TagName");
        return element -> XMLHelper.hasNoNamespaceURI(element) && element.getTagName().equals(string);
    }

    @Nullable
    public static Element getFirstChildElement(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        return NodeListIterator.createChildNodeIterator(node).findFirstMapped(XMLHelper.filterNodeIsElement(), Element.class::cast);
    }

    public static boolean hasChildElementNodes(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        return NodeListIterator.createChildNodeIterator(node).containsAny(XMLHelper.filterNodeIsElement());
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nullable Node node, @Nonnull @Nonempty String string) {
        if (node == null) {
            return null;
        }
        return new ChildElementIterator(node).findFirst(XMLHelper.filterElementWithTagName(string));
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nullable Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        if (node == null) {
            return null;
        }
        return new ChildElementIterator(node).findFirst(XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    @Nullable
    public static Element getChildElementOfNames(@Nullable Element element, String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue(stringArray, "TagNames");
        Element element2 = element;
        if (element2 != null) {
            for (String string : stringArray) {
                if ((element2 = XMLHelper.getFirstChildElementOfName(element2, string)) != null) continue;
                return null;
            }
        }
        return element2;
    }

    @Nonnull
    public static Node append(@Nonnull Node node, @Nullable Object object) {
        ValueEnforcer.notNull(node, "ParentNode");
        if (object != null) {
            if (object instanceof Document) {
                XMLHelper.append(node, ((Document)object).getDocumentElement());
            } else if (object instanceof Node) {
                Node node2 = (Node)object;
                Document document = XMLHelper.getOwnerDocument(node);
                if (XMLHelper.getOwnerDocument(node2).equals(document)) {
                    node.appendChild(node2);
                } else {
                    node.appendChild(document.adoptNode(node2.cloneNode(true)));
                }
            } else if (object instanceof String) {
                node.appendChild(XMLHelper.getOwnerDocument(node).createTextNode((String)object));
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    XMLHelper.append(node, t);
                }
            } else if (ArrayHelper.isArray(object)) {
                for (Object object2 : (Object[])object) {
                    XMLHelper.append(node, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + object.getClass().getName() + ".");
            }
        }
        return node;
    }

    public static void append(@Nonnull Node node, @Nonnull Iterable<?> iterable) {
        ValueEnforcer.notNull(node, "ParentNode");
        for (Object obj : iterable) {
            XMLHelper.append(node, obj);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element));
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string, @Nonnull @Nonempty String string2) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string, string2));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIterator(@Nullable Node node) {
        return new ChildElementIterator(node);
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithoutNamespace());
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node, @Nonnull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagNameNoNS(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIterator(@Nullable Node node, @Nonnull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagName(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespace(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    public static boolean hasSameElementName(@Nonnull Element element, @Nonnull Element element2) {
        String string = element.getNamespaceURI();
        String string2 = element2.getNamespaceURI();
        if (StringHelper.hasText(string)) {
            return string.equals(string2) && element.getLocalName().equals(element2.getLocalName());
        }
        return StringHelper.hasNoText(string2) && element.getTagName().equals(element2.getTagName());
    }

    @Nonnull
    private static String _getPathToNode(@Nonnull Node node, @Nonnull String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, @Nullable NamespaceContext namespaceContext) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(string2, "Separator");
        Function<String, String> function = namespaceContext == null ? string -> "" : string -> {
            String string2;
            if (StringHelper.hasText(string) && StringHelper.hasText(string2 = namespaceContext.getPrefix((String)string))) {
                return string2 + ":";
            }
            return "";
        };
        StringBuilder stringBuilder = new StringBuilder(128);
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            if (bl && s == 9 && stringBuilder.length() > 0) {
                stringBuilder.insert(0, string2);
                break;
            }
            String string3 = node2.getNamespaceURI();
            StringBuilder stringBuilder2 = new StringBuilder();
            if (s == 2) {
                stringBuilder2.append('@');
            }
            if (StringHelper.hasText(string3)) {
                stringBuilder2.append(function.apply(string3));
                stringBuilder2.append(node2.getLocalName());
            } else {
                stringBuilder2.append(node2.getNodeName());
            }
            Node node3 = s == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
            if (node3 != null && s == 1) {
                if (node3.getNodeType() == 1) {
                    Element element = (Element)node2;
                    int n = 0;
                    int n2 = -1;
                    for (Element element2 : new ChildElementIterator(node3)) {
                        boolean bl6;
                        if (EqualsHelper.identityEqual(element2, node2)) {
                            n2 = n;
                        }
                        if (!(bl6 = bl5 ? XMLHelper.hasSameElementName(element2, element) : element2.getTagName().equals(element.getTagName()))) continue;
                        ++n;
                    }
                    if (n2 < 0) {
                        throw new IllegalStateException("Failed to find Node with name '" + element.getTagName() + "' at parent");
                    }
                    if (n > 1 || bl3) {
                        stringBuilder2.append('[').append(bl2 ? n2 : n2 + 1).append(']');
                    }
                } else if (bl3) {
                    stringBuilder2.append('[').append(bl2 ? 0 : 1).append(']');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string2);
            }
            stringBuilder.insert(0, stringBuilder2);
            node2 = node3;
        }
        if (bl4 && stringBuilder.length() > 0) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static PathToNodeBuilder pathToNodeBuilder() {
        return new PathToNodeBuilder();
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node node) {
        return XMLHelper.getPathToNode(node, "/");
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node node, @Nonnull String string) {
        return XMLHelper.pathToNodeBuilder().node(node).separator(string).includeDocumentNode().zeroBasedIndex().forceUseIndex(true).trailingSeparator(true).compareIncludingNamespaceURI(false).build();
    }

    @Nonnull
    public static String getPathToNode2(@Nonnull Node node) {
        return XMLHelper.getPathToNode2(node, "/");
    }

    @Nonnull
    public static String getPathToNode2(@Nonnull Node node, @Nonnull String string) {
        return XMLHelper.pathToNodeBuilder().node(node).separator(string).excludeDocumentNode().zeroBasedIndex().forceUseIndex(false).trailingSeparator(false).compareIncludingNamespaceURI(false).build();
    }

    public static void removeAllChildElements(@Nonnull Element element) {
        ValueEnforcer.notNull(element, "Element");
        while (element.getChildNodes().getLength() > 0) {
            element.removeChild(element.getChildNodes().item(0));
        }
    }

    @Nullable
    public static String getFirstChildText(@Nullable Node node2) {
        return NodeListIterator.createChildNodeIterator(node2).findFirstMapped(node -> node instanceof Text && !((Text)node).isElementContentWhitespace(), node -> ((Text)node).getData());
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string) {
        return XMLHelper.getAttributeValue(element, string, null);
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string, @Nullable String string2) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? string2 : attr.getValue();
    }

    @Nullable
    public static String getAttributeValueNS(@Nonnull Element element, @Nullable String string, @Nonnull String string2) {
        return XMLHelper.getAttributeValueNS(element, string, string2, null);
    }

    @Nullable
    public static String getAttributeValueNS(@Nonnull Element element, @Nullable String string, @Nonnull String string2, @Nullable String string3) {
        Attr attr = element.getAttributeNodeNS(string, string2);
        return attr == null ? string3 : attr.getValue();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Attr> getAllAttributesAsList(@Nullable Element element) {
        CommonsArrayList<Attr> commonsArrayList = new CommonsArrayList<Attr>();
        NamedNodeMapIterator.createAttributeIterator(element).forEach(node -> commonsArrayList.add((Attr)node));
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getAllAttributesAsMap(@Nullable Element element) {
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        XMLHelper.forAllAttributes(element, commonsLinkedHashMap::put);
        return commonsLinkedHashMap;
    }

    public static void forAllAttributes(@Nullable Element element, @Nonnull Consumer<? super Attr> consumer) {
        NamedNodeMapIterator.createAttributeIterator(element).forEach(node -> consumer.accept((Attr)node));
    }

    public static void forAllAttributes(@Nullable Element element, @Nonnull BiConsumer<? super String, ? super String> biConsumer) {
        XMLHelper.forAllAttributes(element, (? super Attr attr) -> biConsumer.accept(attr.getName(), attr.getValue()));
    }

    @Nonnull
    public static QName getXMLNSAttrQName(@Nullable String string) {
        if (string != null) {
            ValueEnforcer.isFalse(string.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR), () -> "prefix is invalid: " + string);
        }
        if (string == null || string.equals("")) {
            return new QName("http://www.w3.org/2000/xmlns/", "xmlns");
        }
        return new QName("http://www.w3.org/2000/xmlns/", string, "xmlns");
    }

    @Nonnull
    public static String getPrefix(@Nullable Element element) {
        String string = element == null ? null : element.getPrefix();
        return string == null ? "" : string;
    }

    @Nonnull
    public static QName getQName(@Nonnull Element element) {
        String string = element.getNamespaceURI();
        if (string == null) {
            return new QName(element.getTagName());
        }
        return new QName(string, element.getLocalName(), XMLHelper.getPrefix(element));
    }

    public static void iterateChildren(@Nonnull Node node, @Nonnull Consumer<? super Node> consumer) {
        ValueEnforcer.notNull(node, "Parent");
        ValueEnforcer.notNull(consumer, "Consumer");
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                consumer.accept(node2);
            }
        }
    }

    private static void _recursiveIterateChildren(@Nonnull Node node, @Nonnull Consumer<? super Node> consumer) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                consumer.accept(node2);
                XMLHelper._recursiveIterateChildren(node2, consumer);
            }
        }
    }

    public static void recursiveIterateChildren(@Nonnull Node node, @Nonnull Consumer<? super Node> consumer) {
        ValueEnforcer.notNull(node, "Parent");
        ValueEnforcer.notNull(consumer, "Consumer");
        XMLHelper._recursiveIterateChildren(node, consumer);
    }

    @NotThreadSafe
    public static class PathToNodeBuilder
    implements IBuilder<String> {
        private Node m_aNode;
        private String m_sSeperator;
        private boolean m_bExcludeDocumentNode;
        private boolean m_bZeroBasedIndex;
        private boolean m_bForceUseIndex;
        private boolean m_bTrailingSeparator;
        private boolean m_bCompareIncludingNamespaceURI;
        private NamespaceContext m_aNamespaceCtx;

        public PathToNodeBuilder() {
            this.separator("/");
            this.excludeDocumentNode(true);
            this.zeroBasedIndex(false);
            this.forceUseIndex(false);
            this.trailingSeparator(false);
            this.compareIncludingNamespaceURI(true);
        }

        @Nonnull
        public PathToNodeBuilder node(@Nullable Node node) {
            this.m_aNode = node;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder separator(char c) {
            return this.separator(Character.toString(c));
        }

        @Nonnull
        public PathToNodeBuilder separator(@Nullable String string) {
            this.m_sSeperator = string;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder excludeDocumentNode(boolean bl) {
            this.m_bExcludeDocumentNode = bl;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder excludeDocumentNode() {
            return this.excludeDocumentNode(true);
        }

        @Nonnull
        public PathToNodeBuilder includeDocumentNode() {
            return this.excludeDocumentNode(false);
        }

        @Nonnull
        public PathToNodeBuilder zeroBasedIndex(boolean bl) {
            this.m_bZeroBasedIndex = bl;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder zeroBasedIndex() {
            return this.zeroBasedIndex(true);
        }

        @Nonnull
        public PathToNodeBuilder oneBasedIndex() {
            return this.zeroBasedIndex(false);
        }

        @Nonnull
        public PathToNodeBuilder forceUseIndex(boolean bl) {
            this.m_bForceUseIndex = bl;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder trailingSeparator(boolean bl) {
            this.m_bTrailingSeparator = bl;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder compareIncludingNamespaceURI(boolean bl) {
            this.m_bCompareIncludingNamespaceURI = bl;
            return this;
        }

        @Nonnull
        public PathToNodeBuilder namespaceContext(@Nullable NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
            return this;
        }

        @Override
        @Nonnull
        public String build() {
            if (this.m_aNode == null) {
                throw new IllegalStateException("A source Node need to be provided");
            }
            if (this.m_sSeperator == null) {
                throw new IllegalStateException("A non-null separator needs to be provided");
            }
            return XMLHelper._getPathToNode(this.m_aNode, this.m_sSeperator, this.m_bExcludeDocumentNode, this.m_bZeroBasedIndex, this.m_bForceUseIndex, this.m_bTrailingSeparator, this.m_bCompareIncludingNamespaceURI, this.m_aNamespaceCtx);
        }
    }
}

