/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSVRLErrorLevelDeterminator
implements ISVRLErrorLevelDeterminator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSVRLErrorLevelDeterminator.class);
    public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;
    public static final Function<String, IErrorLevel> UNKNOWN_ERROR_LEVEL_HANDLER = string -> {
        if (string != null) {
            LOGGER.warn("Cannot convert the SVRL flag '" + string + "' to an error level. Using default error level instead!");
        }
        return DEFAULT_ERROR_LEVEL;
    };
    private final Function<String, ? extends IErrorLevel> m_aUnknwownErrorLevelHandler;

    public DefaultSVRLErrorLevelDeterminator() {
        this(UNKNOWN_ERROR_LEVEL_HANDLER);
    }

    public DefaultSVRLErrorLevelDeterminator(@Nonnull Function<String, ? extends IErrorLevel> function) {
        this.m_aUnknwownErrorLevelHandler = ValueEnforcer.notNull(function, "UnknwownErrorLevelHandler");
    }

    @Nonnull
    public Function<String, ? extends IErrorLevel> getUnknwownErrorLevelHandler() {
        return this.m_aUnknwownErrorLevelHandler;
    }

    @Nullable
    public static IErrorLevel getDefaultErrorLevelFromString(@Nullable String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("information") || string.equalsIgnoreCase("info") || string.equalsIgnoreCase("notice") || string.equalsIgnoreCase("note") || string.equalsIgnoreCase("caution") || string.equalsIgnoreCase("hint") || string.equalsIgnoreCase("trace") || string.equalsIgnoreCase("debug")) {
                return EErrorLevel.INFO;
            }
            if (string.equalsIgnoreCase("warning") || string.equalsIgnoreCase("warn")) {
                return EErrorLevel.WARN;
            }
            if (string.equalsIgnoreCase("error") || string.equalsIgnoreCase("err") || string.equalsIgnoreCase("nonfatal")) {
                return EErrorLevel.ERROR;
            }
            if (string.equalsIgnoreCase("fatal") || string.equalsIgnoreCase("fatal_error") || string.equalsIgnoreCase("fatal-error") || string.equalsIgnoreCase("fatalerror")) {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevelFromString(@Nullable String string) {
        IErrorLevel iErrorLevel = DefaultSVRLErrorLevelDeterminator.getDefaultErrorLevelFromString(string);
        if (iErrorLevel != null) {
            return iErrorLevel;
        }
        return this.m_aUnknwownErrorLevelHandler.apply(string);
    }
}

