/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang.priviledged;

import com.helger.commons.ValueEnforcer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AccessControllerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessControllerHelper.class);

    private AccessControllerHelper() {
    }

    @Nullable
    public static <T> T call(@Nonnull PrivilegedAction<T> privilegedAction) {
        ValueEnforcer.notNull(privilegedAction, "Action");
        try {
            return AccessController.doPrivileged(privilegedAction);
        }
        catch (AccessControlException accessControlException) {
            LOGGER.error("Failed to execute PrivilegedAction " + String.valueOf(privilegedAction), accessControlException);
            return null;
        }
    }

    public static <T> void run(@Nonnull PrivilegedAction<T> privilegedAction) {
        AccessControllerHelper.call(privilegedAction);
    }
}

