/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.string.StringParser;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ColorMicroTypeConverter
implements IMicroTypeConverter<Color> {
    private static final String ATTR_RED = "red";
    private static final String ATTR_GREEN = "green";
    private static final String ATTR_BLUE = "blue";
    private static final String ATTR_ALPHA = "alpha";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Color color, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_RED, color.getRed());
        microElement.setAttribute(ATTR_GREEN, color.getGreen());
        microElement.setAttribute(ATTR_BLUE, color.getBlue());
        microElement.setAttribute(ATTR_ALPHA, color.getAlpha());
        return microElement;
    }

    @Override
    @Nonnull
    public Color convertToNative(@Nonnull IMicroElement iMicroElement) {
        int n = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_RED), 0);
        int n2 = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_GREEN), 0);
        int n3 = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_BLUE), 0);
        int n4 = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_ALPHA), 255);
        return new Color(n, n2, n3, n4);
    }
}

