/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hierarchy.IHasChildrenRecursive;
import com.helger.commons.hierarchy.IHasChildrenSorted;
import com.helger.commons.hierarchy.IHasParent;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMicroNode
extends ICloneable<IMicroNode>,
IHasChildrenSorted<IMicroNode>,
IHasChildrenRecursive<IMicroNode>,
IHasParent<IMicroNode> {
    @Nonnull
    @Nonempty
    public String getNodeName();

    default public String getNodeValue() {
        return "";
    }

    @Override
    @Nullable
    public ICommonsList<IMicroNode> getAllChildren();

    default public boolean containsAnyChild(@Nonnull Predicate<? super IMicroNode> predicate) {
        ValueEnforcer.notNull(predicate, "Filter");
        if (this.hasNoChildren()) {
            return false;
        }
        return this.getAllChildren().containsAny(predicate);
    }

    @Override
    @Nullable
    public IMicroNode getFirstChild();

    @Override
    @Nullable
    public IMicroNode getLastChild();

    @Nullable
    default public ICommonsList<IMicroNode> getAllChildrenRecursive() {
        if (this.hasNoChildren()) {
            return null;
        }
        CommonsArrayList<IMicroNode> commonsArrayList = new CommonsArrayList<IMicroNode>();
        this.forAllChildrenRecursive(commonsArrayList::add);
        return commonsArrayList;
    }

    @Nullable
    public IMicroNode getPreviousSibling();

    @Nullable
    public IMicroNode getNextSibling();

    @Override
    public boolean hasParent();

    @Override
    @Nullable
    public IMicroNode getParent();

    @Nonnull
    public IMicroNode detachFromParent();

    @Nullable
    public IMicroElement findParentElement(@Nonnull Predicate<? super IMicroElement> var1);

    @Nullable
    default public IMicroElement getParentElementWithName(@Nullable String string) {
        return this.findParentElement(iMicroElement -> iMicroElement.getTagName().equals(string));
    }

    @Nullable
    default public IMicroElement getParentElementWithName(@Nullable String string, @Nullable String string2) {
        return this.findParentElement(iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.getTagName().equals(string2));
    }

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE var1);

    default public void appendChildren(IMicroNode ... iMicroNodeArray) {
        if (iMicroNodeArray != null) {
            for (IMicroNode iMicroNode : iMicroNodeArray) {
                this.appendChild(iMicroNode);
            }
        }
    }

    default public void appendChildren(@Nullable Iterable<? extends IMicroNode> iterable) {
        if (iterable != null) {
            for (IMicroNode iMicroNode : iterable) {
                this.appendChild(iMicroNode);
            }
        }
    }

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE var1, @Nonnull IMicroNode var2);

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE var1, @Nonnull IMicroNode var2);

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int var1, @Nullable NODETYPE var2);

    @Nonnull
    default public IMicroText appendText(boolean bl) {
        return this.appendText(Boolean.toString(bl));
    }

    @Nonnull
    default public IMicroText appendText(int n) {
        return this.appendText(Integer.toString(n));
    }

    @Nonnull
    default public IMicroText appendText(long l) {
        return this.appendText(Long.toString(l));
    }

    @Nonnull
    default public IMicroText appendText(@Nullable CharSequence charSequence) {
        return this.appendChild(new MicroText(charSequence, false));
    }

    @Nonnull
    default public IMicroText appendText(@Nonnull char[] cArray) {
        return this.appendText(cArray, 0, cArray.length);
    }

    @Nonnull
    default public IMicroText appendText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.appendChild(new MicroText(cArray, n, n2, false));
    }

    @Nonnull
    default public IMicroText appendTextWithConversion(@Nullable Object object) {
        String string = TypeConverter.convert(object, String.class);
        return this.appendText(string);
    }

    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        return this.appendChild(new MicroText(charSequence, true));
    }

    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray) {
        return this.appendIgnorableWhitespaceText(cArray, 0, cArray.length);
    }

    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.appendChild(new MicroText(cArray, n, n2, true));
    }

    @Nonnull
    default public IMicroCDATA appendCDATA(@Nullable CharSequence charSequence) {
        return this.appendChild(new MicroCDATA(charSequence));
    }

    @Nonnull
    default public IMicroCDATA appendCDATA(@Nonnull char[] cArray) {
        return this.appendCDATA(cArray, 0, cArray.length);
    }

    @Nonnull
    default public IMicroCDATA appendCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.appendChild(new MicroCDATA(cArray, n, n2));
    }

    @Nonnull
    default public IMicroCDATA appendCDATAWithConversion(@Nullable Object object) {
        String string = TypeConverter.convert(object, String.class);
        return this.appendCDATA(string);
    }

    @Nonnull
    default public IMicroComment appendComment(@Nullable CharSequence charSequence) {
        return this.appendChild(new MicroComment(charSequence));
    }

    @Nonnull
    default public IMicroComment appendComment(@Nonnull char[] cArray) {
        return this.appendComment(cArray, 0, cArray.length);
    }

    @Nonnull
    default public IMicroComment appendComment(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.appendChild(new MicroComment(cArray, n, n2));
    }

    @Nonnull
    default public IMicroComment appendCommentWithConversion(@Nullable Object object) {
        String string = TypeConverter.convert(object, String.class);
        return this.appendComment(string);
    }

    @Nonnull
    default public IMicroEntityReference appendEntityReference(@Nonnull String string) {
        return this.appendChild(new MicroEntityReference(string));
    }

    @Nonnull
    default public IMicroElement appendElement(@Nonnull @Nonempty String string) {
        return this.appendElement(null, string);
    }

    @Nonnull
    default public IMicroElement appendElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        return this.appendChild(new MicroElement(string, string2));
    }

    @Nonnull
    default public IMicroProcessingInstruction appendProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.appendChild(new MicroProcessingInstruction(string, string2));
    }

    @Nonnull
    default public IMicroContainer appendContainer() {
        return this.appendChild(new MicroContainer());
    }

    @Nonnull
    public EChange removeChild(@Nonnull IMicroNode var1);

    @Nonnull
    public EChange removeChildAtIndex(@Nonnegative int var1);

    @Nonnull
    public EChange removeAllChildren();

    @Nonnull
    default public EChange replaceChild(@Nonnull IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2) {
        ValueEnforcer.notNull(iMicroNode, "OldChild");
        ValueEnforcer.notNull(iMicroNode2, "NewChild");
        if (iMicroNode.equals(iMicroNode2)) {
            return EChange.UNCHANGED;
        }
        this.insertBefore(iMicroNode2, iMicroNode);
        this.removeChild(iMicroNode);
        return EChange.CHANGED;
    }

    @Nonnull
    public EMicroNodeType getType();

    public boolean isDocument();

    public boolean isDocumentType();

    public boolean isText();

    public boolean isCDATA();

    public boolean isComment();

    public boolean isEntityReference();

    public boolean isElement();

    public boolean isProcessingInstruction();

    public boolean isContainer();

    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EMicroEvent, CallbackList<IMicroEventTarget>> getAllEventTargets();

    @Nonnull
    @ReturnsMutableCopy
    public CallbackList<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent var1);

    public boolean isEqualContent(@Nullable IMicroNode var1);
}

