/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl23;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ubl23.UBL23Marshaller;
import jakarta.xml.bind.annotation.XmlSchema;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_23.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_23.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_23.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_23.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.businesscard_23.BusinessCardType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_23.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_23.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_23.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_23.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_23.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_23.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_23.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.commontransportationreport_23.CommonTransportationReportType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_23.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_23.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_23.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_23.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_23.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.digitalagreement_23.DigitalAgreementType;
import oasis.names.specification.ubl.schema.xsd.digitalcapability_23.DigitalCapabilityType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_23.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_23.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.enquiry_23.EnquiryType;
import oasis.names.specification.ubl.schema.xsd.enquiryresponse_23.EnquiryResponseType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_23.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_23.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.exportcustomsdeclaration_23.ExportCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestrequest_23.ExpressionOfInterestRequestType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestresponse_23.ExpressionOfInterestResponseType;
import oasis.names.specification.ubl.schema.xsd.forecast_23.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_23.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_23.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_23.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_23.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodscertificate_23.GoodsCertificateType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_23.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.goodsitempassport_23.GoodsItemPassportType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_23.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.importcustomsdeclaration_23.ImportCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_23.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_23.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_23.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_23.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.manifest_23.ManifestType;
import oasis.names.specification.ubl.schema.xsd.order_23.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_23.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_23.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_23.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_23.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_23.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_23.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_23.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportation_23.ProofOfReexportationType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportationreminder_23.ProofOfReexportationReminderType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportationrequest_23.ProofOfReexportationRequestType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationrequest_23.QualificationApplicationRequestType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationresponse_23.QualificationApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.quotation_23.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_23.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_23.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_23.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_23.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_23.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_23.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_23.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_23.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_23.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_23.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendercontract_23.TenderContractType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_23.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_23.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_23.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tenderstatus_23.TenderStatusType;
import oasis.names.specification.ubl.schema.xsd.tenderstatusrequest_23.TenderStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.tenderwithdrawal_23.TenderWithdrawalType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_23.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transitcustomsdeclaration_23.TransitCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_23.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_23.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_23.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_23.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_23.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_23.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_23.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_23.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_23.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedurerequest_23.UnsubscribeFromProcedureRequestType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedureresponse_23.UnsubscribeFromProcedureResponseType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_23.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_23.WaybillType;
import oasis.names.specification.ubl.schema.xsd.weightstatement_23.WeightStatementType;

public enum EUBL23DocumentType {
    APPLICATION_RESPONSE(ApplicationResponseType.class, UBL23Marshaller.getAllApplicationResponseXSDs()),
    ATTACHED_DOCUMENT(AttachedDocumentType.class, UBL23Marshaller.getAllAttachedDocumentXSDs()),
    AWARDED_NOTIFICATION(AwardedNotificationType.class, UBL23Marshaller.getAllAwardedNotificationXSDs()),
    BILL_OF_LADING(BillOfLadingType.class, UBL23Marshaller.getAllBillOfLadingXSDs()),
    BUSINESS_CARD(BusinessCardType.class, UBL23Marshaller.getAllBusinessCardXSDs()),
    CALL_FOR_TENDERS(CallForTendersType.class, UBL23Marshaller.getAllCallForTendersXSDs()),
    CATALOGUE(CatalogueType.class, UBL23Marshaller.getAllCatalogueXSDs()),
    CATALOGUE_DELETION(CatalogueDeletionType.class, UBL23Marshaller.getAllCatalogueDeletionXSDs()),
    CATALOGUE_ITEM_SPECIFICATION_UPDATE(CatalogueItemSpecificationUpdateType.class, UBL23Marshaller.getAllCatalogueItemSpecificationUpdateXSDs()),
    CATALOGUE_PRICING_UPDATE(CataloguePricingUpdateType.class, UBL23Marshaller.getAllCataloguePricingUpdateXSDs()),
    CATALOGUE_REQUEST(CatalogueRequestType.class, UBL23Marshaller.getAllCatalogueRequestXSDs()),
    CERTIFICATE_OF_ORIGIN(CertificateOfOriginType.class, UBL23Marshaller.getAllCertificateOfOriginXSDs()),
    COMMON_TRANSPORTATION_REPORT(CommonTransportationReportType.class, UBL23Marshaller.getAllCommonTransportationReportXSDs()),
    CONTRACT_AWARD_NOTICE(ContractAwardNoticeType.class, UBL23Marshaller.getAllContractAwardNoticeXSDs()),
    CONTRACT_NOTICE(ContractNoticeType.class, UBL23Marshaller.getAllContractNoticeXSDs()),
    CREDIT_NOTE(CreditNoteType.class, UBL23Marshaller.getAllCreditNoteXSDs()),
    DEBIT_NOTE(DebitNoteType.class, UBL23Marshaller.getAllDebitNoteXSDs()),
    DESPATCH_ADVICE(DespatchAdviceType.class, UBL23Marshaller.getAllDespatchAdviceXSDs()),
    DIGITAL_AGREEMENT(DigitalAgreementType.class, UBL23Marshaller.getAllDigitalAgreementXSDs()),
    DIGITAL_CAPABILITY(DigitalCapabilityType.class, UBL23Marshaller.getAllDigitalCapabilityXSDs()),
    DOCUMENT_STATUS(DocumentStatusType.class, UBL23Marshaller.getAllDocumentStatusXSDs()),
    DOCUMENT_STATUS_REQUEST(DocumentStatusRequestType.class, UBL23Marshaller.getAllDocumentStatusRequestXSDs()),
    ENQUIRY(EnquiryType.class, UBL23Marshaller.getAllEnquiryXSDs()),
    ENQUIRY_RESPONSE(EnquiryResponseType.class, UBL23Marshaller.getAllEnquiryResponseXSDs()),
    EXCEPTION_CRITERIA(ExceptionCriteriaType.class, UBL23Marshaller.getAllExceptionCriteriaXSDs()),
    EXCEPTION_NOTIFICATION(ExceptionNotificationType.class, UBL23Marshaller.getAllExceptionNotificationXSDs()),
    EXPORT_CUSTOMS_DECLARATION(ExportCustomsDeclarationType.class, UBL23Marshaller.getAllExportCustomsDeclarationXSDs()),
    EXPRESSION_OF_INTEREST_REQUEST(ExpressionOfInterestRequestType.class, UBL23Marshaller.getAllExpressionOfInterestRequestXSDs()),
    EXPRESSION_OF_INTEREST_RESPONSE(ExpressionOfInterestResponseType.class, UBL23Marshaller.getAllExpressionOfInterestResponseXSDs()),
    FORECAST(ForecastType.class, UBL23Marshaller.getAllForecastXSDs()),
    FORECAST_REVISION(ForecastRevisionType.class, UBL23Marshaller.getAllForecastRevisionXSDs()),
    FORWARDING_INSTRUCTIONS(ForwardingInstructionsType.class, UBL23Marshaller.getAllForwardingInstructionsXSDs()),
    FREIGHT_INVOICE(FreightInvoiceType.class, UBL23Marshaller.getAllFreightInvoiceXSDs()),
    FULFILMENT_CANCELLATION(FulfilmentCancellationType.class, UBL23Marshaller.getAllFulfilmentCancellationXSDs()),
    GOODS_CERTIFICATE(GoodsCertificateType.class, UBL23Marshaller.getAllGoodsCertificateXSDs()),
    GOODS_ITEM_ITINERARY(GoodsItemItineraryType.class, UBL23Marshaller.getAllGoodsItemItineraryXSDs()),
    GOODS_ITEM_PASSPORT(GoodsItemPassportType.class, UBL23Marshaller.getAllGoodsItemPassportXSDs()),
    GUARANTEE_CERTIFICATE(GuaranteeCertificateType.class, UBL23Marshaller.getAllGuaranteeCertificateXSDs()),
    IMPORT_CUSTOMS_DECLARATION(ImportCustomsDeclarationType.class, UBL23Marshaller.getAllImportCustomsDeclarationXSDs()),
    INSTRUCTION_FOR_RETURNS(InstructionForReturnsType.class, UBL23Marshaller.getAllInstructionForReturnsXSDs()),
    INVENTORY_REPORT(InventoryReportType.class, UBL23Marshaller.getAllInventoryReportXSDs()),
    INVOICE(InvoiceType.class, UBL23Marshaller.getAllInvoiceXSDs()),
    ITEM_INFORMATION_REQUEST(ItemInformationRequestType.class, UBL23Marshaller.getAllItemInformationRequestXSDs()),
    MANIFEST(ManifestType.class, UBL23Marshaller.getAllManifestXSDs()),
    ORDER(OrderType.class, UBL23Marshaller.getAllOrderXSDs()),
    ORDER_CANCELLATION(OrderCancellationType.class, UBL23Marshaller.getAllOrderCancellationXSDs()),
    ORDER_CHANGE(OrderChangeType.class, UBL23Marshaller.getAllOrderChangeXSDs()),
    ORDER_RESPONSE(OrderResponseType.class, UBL23Marshaller.getAllOrderResponseXSDs()),
    ORDER_RESPONSE_SIMPLE(OrderResponseSimpleType.class, UBL23Marshaller.getAllOrderResponseSimpleXSDs()),
    PACKING_LIST(PackingListType.class, UBL23Marshaller.getAllPackingListXSDs()),
    PRIOR_INFORMATION_NOTICE(PriorInformationNoticeType.class, UBL23Marshaller.getAllPriorInformationNoticeXSDs()),
    PRODUCT_ACTIVITY(ProductActivityType.class, UBL23Marshaller.getAllProductActivityXSDs()),
    PROOF_OF_REEXPORTATION(ProofOfReexportationType.class, UBL23Marshaller.getAllProofOfReexportationXSDs()),
    PROOF_OF_REEXPORTATION_REMINDER(ProofOfReexportationReminderType.class, UBL23Marshaller.getAllProofOfReexportationReminderXSDs()),
    PROOF_OF_REEXPORTATION_REQUEST(ProofOfReexportationRequestType.class, UBL23Marshaller.getAllProofOfReexportationRequestXSDs()),
    QUALIFICATION_APPLICATION_REQUEST(QualificationApplicationRequestType.class, UBL23Marshaller.getAllQualificationApplicationRequestXSDs()),
    QUALIFICATION_APPLICATION_RESPONSE(QualificationApplicationResponseType.class, UBL23Marshaller.getAllQualificationApplicationResponseXSDs()),
    QUOTATION(QuotationType.class, UBL23Marshaller.getAllQuotationXSDs()),
    RECEIPT_ADVICE(ReceiptAdviceType.class, UBL23Marshaller.getAllReceiptAdviceXSDs()),
    REMINDER(ReminderType.class, UBL23Marshaller.getAllReminderXSDs()),
    REMITTANCE_ADVICE(RemittanceAdviceType.class, UBL23Marshaller.getAllRemittanceAdviceXSDs()),
    REQUEST_FOR_QUOTATION(RequestForQuotationType.class, UBL23Marshaller.getAllRequestForQuotationXSDs()),
    RETAIL_EVENT(RetailEventType.class, UBL23Marshaller.getAllRetailEventXSDs()),
    SELF_BILLED_CREDIT_NOTE(SelfBilledCreditNoteType.class, UBL23Marshaller.getAllSelfBilledCreditNoteXSDs()),
    SELF_BILLED_INVOICE(SelfBilledInvoiceType.class, UBL23Marshaller.getAllSelfBilledInvoiceXSDs()),
    STATEMENT(StatementType.class, UBL23Marshaller.getAllStatementXSDs()),
    STOCK_AVAILABILITY_REPORT(StockAvailabilityReportType.class, UBL23Marshaller.getAllStockAvailabilityReportXSDs()),
    TENDER(TenderType.class, UBL23Marshaller.getAllTenderXSDs()),
    TENDER_CONTRACT(TenderContractType.class, UBL23Marshaller.getAllTenderContractXSDs()),
    TENDER_RECEIPT(TenderReceiptType.class, UBL23Marshaller.getAllTenderReceiptXSDs()),
    TENDER_STATUS(TenderStatusType.class, UBL23Marshaller.getAllTenderStatusXSDs()),
    TENDER_STATUS_REQUEST(TenderStatusRequestType.class, UBL23Marshaller.getAllTenderStatusRequestXSDs()),
    TENDER_WITHDRAWAL(TenderWithdrawalType.class, UBL23Marshaller.getAllTenderWithdrawalXSDs()),
    TENDERER_QUALIFICATION(TendererQualificationType.class, UBL23Marshaller.getAllTendererQualificationXSDs()),
    TENDERER_QUALIFICATION_RESPONSE(TendererQualificationResponseType.class, UBL23Marshaller.getAllTendererQualificationResponseXSDs()),
    TRADE_ITEM_LOCATION_PROFILE(TradeItemLocationProfileType.class, UBL23Marshaller.getAllTradeItemLocationProfileXSDs()),
    TRANSIT_CUSTOMS_DECLARATION(TransitCustomsDeclarationType.class, UBL23Marshaller.getAllTransitCustomsDeclarationXSDs()),
    TRANSPORT_EXECUTION_PLAN(TransportExecutionPlanType.class, UBL23Marshaller.getAllTransportExecutionPlanXSDs()),
    TRANSPORT_EXECUTION_PLAN_REQUEST(TransportExecutionPlanRequestType.class, UBL23Marshaller.getAllTransportExecutionPlanRequestXSDs()),
    TRANSPORT_PROGRESS_STATUS(TransportProgressStatusType.class, UBL23Marshaller.getAllTransportProgressStatusXSDs()),
    TRANSPORT_PROGRESS_STATUS_REQUEST(TransportProgressStatusRequestType.class, UBL23Marshaller.getAllTransportProgressStatusRequestXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION(TransportServiceDescriptionType.class, UBL23Marshaller.getAllTransportServiceDescriptionXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION_REQUEST(TransportServiceDescriptionRequestType.class, UBL23Marshaller.getAllTransportServiceDescriptionRequestXSDs()),
    TRANSPORTATION_STATUS(TransportationStatusType.class, UBL23Marshaller.getAllTransportationStatusXSDs()),
    TRANSPORTATION_STATUS_REQUEST(TransportationStatusRequestType.class, UBL23Marshaller.getAllTransportationStatusRequestXSDs()),
    UNAWARDED_NOTIFICATION(UnawardedNotificationType.class, UBL23Marshaller.getAllUnawardedNotificationXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_REQUEST(UnsubscribeFromProcedureRequestType.class, UBL23Marshaller.getAllUnsubscribeFromProcedureRequestXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_RESPONSE(UnsubscribeFromProcedureResponseType.class, UBL23Marshaller.getAllUnsubscribeFromProcedureResponseXSDs()),
    UTILITY_STATEMENT(UtilityStatementType.class, UBL23Marshaller.getAllUtilityStatementXSDs()),
    WAYBILL(WaybillType.class, UBL23Marshaller.getAllWaybillXSDs()),
    WEIGHT_STATEMENT(WeightStatementType.class, UBL23Marshaller.getAllWeightStatementXSDs());

    private final Class<?> m_aImplClass;
    private final ICommonsList<ClassPathResource> m_aXSDs;
    private final String m_sRootElementLocalName;
    private final String m_sRootElementNSURI;

    private EUBL23DocumentType(Class<?> clazz, ICommonsList<ClassPathResource> iCommonsList) {
        this.m_aImplClass = clazz;
        this.m_aXSDs = iCommonsList;
        this.m_sRootElementLocalName = StringHelper.trimEnd(ClassHelper.getClassLocalName(clazz), "Type");
        this.m_sRootElementNSURI = clazz.getPackage().getAnnotation(XmlSchema.class).namespace();
    }

    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aImplClass;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nonnull
    @Nonempty
    public String getRootElementLocalName() {
        return this.m_sRootElementLocalName;
    }

    @Nonnull
    @Nonempty
    public String getRootElementNamespaceURI() {
        return this.m_sRootElementNSURI;
    }
}

