/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl22;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ubl22.UBL22Marshaller;
import jakarta.xml.bind.annotation.XmlSchema;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_22.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_22.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_22.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_22.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.businesscard_22.BusinessCardType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_22.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_22.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_22.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_22.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_22.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_22.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_22.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_22.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_22.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_22.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_22.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_22.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.digitalagreement_22.DigitalAgreementType;
import oasis.names.specification.ubl.schema.xsd.digitalcapability_22.DigitalCapabilityType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_22.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_22.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.enquiry_22.EnquiryType;
import oasis.names.specification.ubl.schema.xsd.enquiryresponse_22.EnquiryResponseType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_22.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_22.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestrequest_22.ExpressionOfInterestRequestType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestresponse_22.ExpressionOfInterestResponseType;
import oasis.names.specification.ubl.schema.xsd.forecast_22.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_22.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_22.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_22.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_22.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_22.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_22.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_22.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_22.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_22.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_22.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.order_22.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_22.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_22.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_22.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_22.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_22.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_22.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_22.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationrequest_22.QualificationApplicationRequestType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationresponse_22.QualificationApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.quotation_22.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_22.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_22.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_22.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_22.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_22.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_22.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_22.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_22.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_22.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_22.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendercontract_22.TenderContractType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_22.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_22.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_22.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tenderstatus_22.TenderStatusType;
import oasis.names.specification.ubl.schema.xsd.tenderstatusrequest_22.TenderStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.tenderwithdrawal_22.TenderWithdrawalType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_22.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_22.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_22.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_22.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_22.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_22.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_22.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_22.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_22.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_22.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedurerequest_22.UnsubscribeFromProcedureRequestType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedureresponse_22.UnsubscribeFromProcedureResponseType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_22.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_22.WaybillType;
import oasis.names.specification.ubl.schema.xsd.weightstatement_22.WeightStatementType;

public enum EUBL22DocumentType {
    APPLICATION_RESPONSE(ApplicationResponseType.class, UBL22Marshaller.getAllApplicationResponseXSDs()),
    ATTACHED_DOCUMENT(AttachedDocumentType.class, UBL22Marshaller.getAllAttachedDocumentXSDs()),
    AWARDED_NOTIFICATION(AwardedNotificationType.class, UBL22Marshaller.getAllAwardedNotificationXSDs()),
    BILL_OF_LADING(BillOfLadingType.class, UBL22Marshaller.getAllBillOfLadingXSDs()),
    BUSINESS_CARD(BusinessCardType.class, UBL22Marshaller.getAllBusinessCardXSDs()),
    CALL_FOR_TENDERS(CallForTendersType.class, UBL22Marshaller.getAllCallForTendersXSDs()),
    CATALOGUE(CatalogueType.class, UBL22Marshaller.getAllCatalogueXSDs()),
    CATALOGUE_DELETION(CatalogueDeletionType.class, UBL22Marshaller.getAllCatalogueDeletionXSDs()),
    CATALOGUE_ITEM_SPECIFICATION_UPDATE(CatalogueItemSpecificationUpdateType.class, UBL22Marshaller.getAllCatalogueItemSpecificationUpdateXSDs()),
    CATALOGUE_PRICING_UPDATE(CataloguePricingUpdateType.class, UBL22Marshaller.getAllCataloguePricingUpdateXSDs()),
    CATALOGUE_REQUEST(CatalogueRequestType.class, UBL22Marshaller.getAllCatalogueRequestXSDs()),
    CERTIFICATE_OF_ORIGIN(CertificateOfOriginType.class, UBL22Marshaller.getAllCertificateOfOriginXSDs()),
    CONTRACT_AWARD_NOTICE(ContractAwardNoticeType.class, UBL22Marshaller.getAllContractAwardNoticeXSDs()),
    CONTRACT_NOTICE(ContractNoticeType.class, UBL22Marshaller.getAllContractNoticeXSDs()),
    CREDIT_NOTE(CreditNoteType.class, UBL22Marshaller.getAllCreditNoteXSDs()),
    DEBIT_NOTE(DebitNoteType.class, UBL22Marshaller.getAllDebitNoteXSDs()),
    DESPATCH_ADVICE(DespatchAdviceType.class, UBL22Marshaller.getAllDespatchAdviceXSDs()),
    DIGITAL_AGREEMENT(DigitalAgreementType.class, UBL22Marshaller.getAllDigitalAgreementXSDs()),
    DIGITAL_CAPABILITY(DigitalCapabilityType.class, UBL22Marshaller.getAllDigitalCapabilityXSDs()),
    DOCUMENT_STATUS(DocumentStatusType.class, UBL22Marshaller.getAllDocumentStatusXSDs()),
    DOCUMENT_STATUS_REQUEST(DocumentStatusRequestType.class, UBL22Marshaller.getAllDocumentStatusRequestXSDs()),
    ENQUIRY(EnquiryType.class, UBL22Marshaller.getAllEnquiryXSDs()),
    ENQUIRY_RESPONSE(EnquiryResponseType.class, UBL22Marshaller.getAllEnquiryResponseXSDs()),
    EXCEPTION_CRITERIA(ExceptionCriteriaType.class, UBL22Marshaller.getAllExceptionCriteriaXSDs()),
    EXCEPTION_NOTIFICATION(ExceptionNotificationType.class, UBL22Marshaller.getAllExceptionNotificationXSDs()),
    EXPRESSION_OF_INTEREST_REQUEST(ExpressionOfInterestRequestType.class, UBL22Marshaller.getAllExpressionOfInterestRequestXSDs()),
    EXPRESSION_OF_INTEREST_RESPONSE(ExpressionOfInterestResponseType.class, UBL22Marshaller.getAllExpressionOfInterestResponseXSDs()),
    FORECAST(ForecastType.class, UBL22Marshaller.getAllForecastXSDs()),
    FORECAST_REVISION(ForecastRevisionType.class, UBL22Marshaller.getAllForecastRevisionXSDs()),
    FORWARDING_INSTRUCTIONS(ForwardingInstructionsType.class, UBL22Marshaller.getAllForwardingInstructionsXSDs()),
    FREIGHT_INVOICE(FreightInvoiceType.class, UBL22Marshaller.getAllFreightInvoiceXSDs()),
    FULFILMENT_CANCELLATION(FulfilmentCancellationType.class, UBL22Marshaller.getAllFulfilmentCancellationXSDs()),
    GOODS_ITEM_ITINERARY(GoodsItemItineraryType.class, UBL22Marshaller.getAllGoodsItemItineraryXSDs()),
    GUARANTEE_CERTIFICATE(GuaranteeCertificateType.class, UBL22Marshaller.getAllGuaranteeCertificateXSDs()),
    INSTRUCTION_FOR_RETURNS(InstructionForReturnsType.class, UBL22Marshaller.getAllInstructionForReturnsXSDs()),
    INVENTORY_REPORT(InventoryReportType.class, UBL22Marshaller.getAllInventoryReportXSDs()),
    INVOICE(InvoiceType.class, UBL22Marshaller.getAllInvoiceXSDs()),
    ITEM_INFORMATION_REQUEST(ItemInformationRequestType.class, UBL22Marshaller.getAllItemInformationRequestXSDs()),
    ORDER(OrderType.class, UBL22Marshaller.getAllOrderXSDs()),
    ORDER_CANCELLATION(OrderCancellationType.class, UBL22Marshaller.getAllOrderCancellationXSDs()),
    ORDER_CHANGE(OrderChangeType.class, UBL22Marshaller.getAllOrderChangeXSDs()),
    ORDER_RESPONSE(OrderResponseType.class, UBL22Marshaller.getAllOrderResponseXSDs()),
    ORDER_RESPONSE_SIMPLE(OrderResponseSimpleType.class, UBL22Marshaller.getAllOrderResponseSimpleXSDs()),
    PACKING_LIST(PackingListType.class, UBL22Marshaller.getAllPackingListXSDs()),
    PRIOR_INFORMATION_NOTICE(PriorInformationNoticeType.class, UBL22Marshaller.getAllPriorInformationNoticeXSDs()),
    PRODUCT_ACTIVITY(ProductActivityType.class, UBL22Marshaller.getAllProductActivityXSDs()),
    QUALIFICATION_APPLICATION_REQUEST(QualificationApplicationRequestType.class, UBL22Marshaller.getAllQualificationApplicationRequestXSDs()),
    QUALIFICATION_APPLICATION_RESPONSE(QualificationApplicationResponseType.class, UBL22Marshaller.getAllQualificationApplicationResponseXSDs()),
    QUOTATION(QuotationType.class, UBL22Marshaller.getAllQuotationXSDs()),
    RECEIPT_ADVICE(ReceiptAdviceType.class, UBL22Marshaller.getAllReceiptAdviceXSDs()),
    REMINDER(ReminderType.class, UBL22Marshaller.getAllReminderXSDs()),
    REMITTANCE_ADVICE(RemittanceAdviceType.class, UBL22Marshaller.getAllRemittanceAdviceXSDs()),
    REQUEST_FOR_QUOTATION(RequestForQuotationType.class, UBL22Marshaller.getAllRequestForQuotationXSDs()),
    RETAIL_EVENT(RetailEventType.class, UBL22Marshaller.getAllRetailEventXSDs()),
    SELF_BILLED_CREDIT_NOTE(SelfBilledCreditNoteType.class, UBL22Marshaller.getAllSelfBilledCreditNoteXSDs()),
    SELF_BILLED_INVOICE(SelfBilledInvoiceType.class, UBL22Marshaller.getAllSelfBilledInvoiceXSDs()),
    STATEMENT(StatementType.class, UBL22Marshaller.getAllStatementXSDs()),
    STOCK_AVAILABILITY_REPORT(StockAvailabilityReportType.class, UBL22Marshaller.getAllStockAvailabilityReportXSDs()),
    TENDER(TenderType.class, UBL22Marshaller.getAllTenderXSDs()),
    TENDER_CONTRACT(TenderContractType.class, UBL22Marshaller.getAllTenderContractXSDs()),
    TENDER_RECEIPT(TenderReceiptType.class, UBL22Marshaller.getAllTenderReceiptXSDs()),
    TENDER_STATUS(TenderStatusType.class, UBL22Marshaller.getAllTenderStatusXSDs()),
    TENDER_STATUS_REQUEST(TenderStatusRequestType.class, UBL22Marshaller.getAllTenderStatusRequestXSDs()),
    TENDER_WITHDRAWAL(TenderWithdrawalType.class, UBL22Marshaller.getAllTenderWithdrawalXSDs()),
    TENDERER_QUALIFICATION(TendererQualificationType.class, UBL22Marshaller.getAllTendererQualificationXSDs()),
    TENDERER_QUALIFICATION_RESPONSE(TendererQualificationResponseType.class, UBL22Marshaller.getAllTendererQualificationResponseXSDs()),
    TRADE_ITEM_LOCATION_PROFILE(TradeItemLocationProfileType.class, UBL22Marshaller.getAllTradeItemLocationProfileXSDs()),
    TRANSPORT_EXECUTION_PLAN(TransportExecutionPlanType.class, UBL22Marshaller.getAllTransportExecutionPlanXSDs()),
    TRANSPORT_EXECUTION_PLAN_REQUEST(TransportExecutionPlanRequestType.class, UBL22Marshaller.getAllTransportExecutionPlanRequestXSDs()),
    TRANSPORT_PROGRESS_STATUS(TransportProgressStatusType.class, UBL22Marshaller.getAllTransportProgressStatusXSDs()),
    TRANSPORT_PROGRESS_STATUS_REQUEST(TransportProgressStatusRequestType.class, UBL22Marshaller.getAllTransportProgressStatusRequestXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION(TransportServiceDescriptionType.class, UBL22Marshaller.getAllTransportServiceDescriptionXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION_REQUEST(TransportServiceDescriptionRequestType.class, UBL22Marshaller.getAllTransportServiceDescriptionRequestXSDs()),
    TRANSPORTATION_STATUS(TransportationStatusType.class, UBL22Marshaller.getAllTransportationStatusXSDs()),
    TRANSPORTATION_STATUS_REQUEST(TransportationStatusRequestType.class, UBL22Marshaller.getAllTransportationStatusRequestXSDs()),
    UNAWARDED_NOTIFICATION(UnawardedNotificationType.class, UBL22Marshaller.getAllUnawardedNotificationXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_REQUEST(UnsubscribeFromProcedureRequestType.class, UBL22Marshaller.getAllUnsubscribeFromProcedureRequestXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_RESPONSE(UnsubscribeFromProcedureResponseType.class, UBL22Marshaller.getAllUnsubscribeFromProcedureResponseXSDs()),
    UTILITY_STATEMENT(UtilityStatementType.class, UBL22Marshaller.getAllUtilityStatementXSDs()),
    WAYBILL(WaybillType.class, UBL22Marshaller.getAllWaybillXSDs()),
    WEIGHT_STATEMENT(WeightStatementType.class, UBL22Marshaller.getAllWeightStatementXSDs());

    private final Class<?> m_aImplClass;
    private final ICommonsList<ClassPathResource> m_aXSDs;
    private final String m_sRootElementLocalName;
    private final String m_sRootElementNSURI;

    private EUBL22DocumentType(Class<?> clazz, ICommonsList<ClassPathResource> iCommonsList) {
        this.m_aImplClass = clazz;
        this.m_aXSDs = iCommonsList;
        this.m_sRootElementLocalName = StringHelper.trimEnd(ClassHelper.getClassLocalName(clazz), "Type");
        this.m_sRootElementNSURI = clazz.getPackage().getAnnotation(XmlSchema.class).namespace();
    }

    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aImplClass;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nonnull
    @Nonempty
    public String getRootElementLocalName() {
        return this.m_sRootElementLocalName;
    }

    @Nonnull
    @Nonempty
    public String getRootElementNamespaceURI() {
        return this.m_sRootElementNSURI;
    }
}

