/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.datetime.CPDT;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTHelper {
    private static final PDTHelper INSTANCE = new PDTHelper();

    private PDTHelper() {
    }

    public static boolean isNullValue(@Nullable LocalDate localDate) {
        return localDate == null || localDate == CPDT.NULL_LOCAL_DATE;
    }

    public static boolean isNullValue(@Nullable LocalTime localTime) {
        return localTime == null || localTime == CPDT.NULL_LOCAL_TIME;
    }

    public static boolean isNullValue(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null || localDateTime == CPDT.NULL_LOCAL_DATETIME;
    }

    public static boolean isNullValue(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null || zonedDateTime.equals(CPDT.NULL_DATETIME);
    }

    public static boolean isWeekendDay(DayOfWeek dayOfWeek) {
        return dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY;
    }

    public static boolean isWeekend(@Nonnull LocalDateTime localDateTime) {
        return PDTHelper.isWeekendDay(localDateTime.getDayOfWeek());
    }

    public static boolean isWeekend(@Nonnull LocalDate localDate) {
        return PDTHelper.isWeekendDay(localDate.getDayOfWeek());
    }

    public static boolean isFirstDayOfWeek(DayOfWeek dayOfWeek) {
        return dayOfWeek == CPDT.START_OF_WEEK_DAY;
    }

    public static boolean isFirstDayOfWeek(@Nonnull ZonedDateTime zonedDateTime) {
        return PDTHelper.isFirstDayOfWeek(zonedDateTime.getDayOfWeek());
    }

    public static boolean isFirstDayOfWeek(@Nonnull LocalDateTime localDateTime) {
        return PDTHelper.isFirstDayOfWeek(localDateTime.getDayOfWeek());
    }

    public static boolean isFirstDayOfWeek(@Nonnull LocalDate localDate) {
        return PDTHelper.isFirstDayOfWeek(localDate.getDayOfWeek());
    }

    public static boolean isLastDayOfWeek(DayOfWeek dayOfWeek) {
        return dayOfWeek == CPDT.END_OF_WEEK_DAY;
    }

    public static boolean isLastDayOfWeek(@Nonnull ZonedDateTime zonedDateTime) {
        return PDTHelper.isLastDayOfWeek(zonedDateTime.getDayOfWeek());
    }

    public static boolean isLastDayOfWeek(@Nonnull LocalDateTime localDateTime) {
        return PDTHelper.isLastDayOfWeek(localDateTime.getDayOfWeek());
    }

    public static boolean isLastDayOfWeek(@Nonnull LocalDate localDate) {
        return PDTHelper.isLastDayOfWeek(localDate.getDayOfWeek());
    }

    public static boolean isWorkDay(@Nonnull LocalDate localDate) {
        return !PDTHelper.isWeekend(localDate);
    }

    public static int getWeekDays(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        ValueEnforcer.notNull(localDate, "StartDate");
        ValueEnforcer.notNull(localDate2, "EndDate");
        boolean bl = localDate.isAfter(localDate2);
        LocalDate localDate3 = bl ? localDate2 : localDate;
        LocalDate localDate4 = bl ? localDate : localDate2;
        int n = 0;
        while (!localDate4.isBefore(localDate3)) {
            if (!PDTHelper.isWeekend(localDate3)) {
                ++n;
            }
            localDate3 = localDate3.plusDays(1L);
        }
        return bl ? -1 * n : n;
    }

    public static boolean isSameYearAndDay(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.getYear() == localDate2.getYear() && localDate.getDayOfYear() == localDate2.getDayOfYear();
    }

    public static boolean isSameYearAndWeek(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2, @Nonnull Locale locale) {
        return localDate.getYear() == localDate2.getYear() && PDTHelper.getWeekOfWeekBasedYear(localDate, locale) == PDTHelper.getWeekOfWeekBasedYear(localDate2, locale);
    }

    public static boolean isSameMonthAndDay(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.getMonth() == localDate2.getMonth() && localDate.getDayOfMonth() == localDate2.getDayOfMonth();
    }

    public static boolean isBetweenIncl(@Nullable LocalDate localDate, @Nullable LocalDate localDate2, @Nullable LocalDate localDate3) {
        if (localDate == null || localDate2 == null || localDate3 == null) {
            return false;
        }
        return !localDate2.isAfter(localDate) && !localDate.isAfter(localDate3);
    }

    public static int getWeekOfWeekBasedYear(@Nonnull TemporalAccessor temporalAccessor, @Nonnull Locale locale) {
        return temporalAccessor.get(WeekFields.of(locale).weekOfWeekBasedYear());
    }

    public static int getStartWeekOfMonth(@Nonnull LocalDateTime localDateTime, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(localDateTime.withDayOfMonth(1), locale);
    }

    public static int getStartWeekOfMonth(@Nonnull LocalDate localDate, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(localDate.withDayOfMonth(1), locale);
    }

    public static int getStartWeekOfMonth(@Nonnull ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(zonedDateTime.withDayOfMonth(1), locale);
    }

    public static int getEndWeekOfMonth(@Nonnull LocalDateTime localDateTime, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(localDateTime.plusMonths(1L).withDayOfMonth(1).minusDays(1L), locale);
    }

    public static int getEndWeekOfMonth(@Nonnull LocalDate localDate, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(localDate.plusMonths(1L).withDayOfMonth(1).minusDays(1L), locale);
    }

    public static int getEndWeekOfMonth(@Nonnull ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        return PDTHelper.getWeekOfWeekBasedYear(zonedDateTime.plusMonths(1L).withDayOfMonth(1).minusDays(1L), locale);
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWeekday(@Nonnull LocalDate localDate) {
        LocalDate localDate2 = localDate;
        while (PDTHelper.isWeekend(localDate2)) {
            localDate2 = localDate2.plusDays(1L);
        }
        return localDate2;
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWeekday() {
        return PDTHelper.getCurrentOrNextWeekday(PDTFactory.getCurrentLocalDate());
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWeekendkDay(@Nonnull LocalDate localDate) {
        LocalDate localDate2 = localDate;
        while (!PDTHelper.isWeekend(localDate2)) {
            localDate2 = localDate2.plusDays(1L);
        }
        return localDate2;
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWeekendkDay() {
        return PDTHelper.getCurrentOrNextWeekendkDay(PDTFactory.getCurrentLocalDate());
    }

    public static int birthdayCompare(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        if (EqualsHelper.identityEqual(localDate, localDate2)) {
            return 0;
        }
        if (localDate == null) {
            return -1;
        }
        if (localDate2 == null) {
            return 1;
        }
        int n = localDate.getMonth().compareTo(localDate2.getMonth());
        if (n == 0) {
            n = localDate.getDayOfMonth() - localDate2.getDayOfMonth();
        }
        return n;
    }

    public static boolean birthdayEquals(@Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        return PDTHelper.birthdayCompare(localDate, localDate2) == 0;
    }

    public static boolean isNewYearsEve(@Nonnull LocalDate localDate) {
        ValueEnforcer.notNull(localDate, "Date");
        return localDate.getMonth() == Month.DECEMBER && localDate.getDayOfMonth() == 31;
    }

    @Nonnull
    public static LocalDate getMax(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.isAfter(localDate2) ? localDate : localDate2;
    }

    @Nonnull
    public static LocalTime getMax(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.isAfter(localTime2) ? localTime : localTime2;
    }

    @Nonnull
    public static LocalDateTime getMax(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.isAfter(localDateTime2) ? localDateTime : localDateTime2;
    }

    @Nonnull
    public static ZonedDateTime getMax(@Nonnull ZonedDateTime zonedDateTime, @Nonnull ZonedDateTime zonedDateTime2) {
        return zonedDateTime.isAfter(zonedDateTime2) ? zonedDateTime : zonedDateTime2;
    }

    @Nonnull
    public static OffsetDateTime getMax(@Nonnull OffsetDateTime offsetDateTime, @Nonnull OffsetDateTime offsetDateTime2) {
        return offsetDateTime.isAfter(offsetDateTime2) ? offsetDateTime : offsetDateTime2;
    }

    @Nonnull
    public static LocalDate getMin(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) {
        return localDate.isBefore(localDate2) ? localDate : localDate2;
    }

    @Nonnull
    public static LocalTime getMin(@Nonnull LocalTime localTime, @Nonnull LocalTime localTime2) {
        return localTime.isBefore(localTime2) ? localTime : localTime2;
    }

    @Nonnull
    public static LocalDateTime getMin(@Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2) {
        return localDateTime.isBefore(localDateTime2) ? localDateTime : localDateTime2;
    }

    @Nonnull
    public static ZonedDateTime getMin(@Nonnull ZonedDateTime zonedDateTime, @Nonnull ZonedDateTime zonedDateTime2) {
        return zonedDateTime.isBefore(zonedDateTime2) ? zonedDateTime : zonedDateTime2;
    }

    @Nonnull
    public static OffsetDateTime getMin(@Nonnull OffsetDateTime offsetDateTime, @Nonnull OffsetDateTime offsetDateTime2) {
        return offsetDateTime.isBefore(offsetDateTime2) ? offsetDateTime : offsetDateTime2;
    }

    public static long getDaysBetween(@Nonnull Temporal temporal, @Nonnull Temporal temporal2) {
        return ChronoUnit.DAYS.between(temporal, temporal2);
    }

    @Nonnull
    public static DayOfWeek getAsDayOfWeek(int n) {
        ValueEnforcer.isBetweenInclusive(n, "DayOfWeek", 1, 7);
        int n2 = (n + 6) % 7;
        return DayOfWeek.of(n2 == 0 ? 7 : n2);
    }

    public static int getCalendarDayOfWeek(@Nonnull DayOfWeek dayOfWeek) {
        ValueEnforcer.notNull(dayOfWeek, "DayOfWeek");
        return dayOfWeek.getValue() % 7 + 1;
    }

    @Nullable
    public static Month getAsMonth(int n) {
        if (n < 1 || n > 12) {
            return null;
        }
        return Month.of(n);
    }
}

