/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.wrapped;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.wrapped.IWrappedReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractWrappedReadableResource
implements IWrappedReadableResource {
    private final IReadableResource m_aBaseResource;

    protected AbstractWrappedReadableResource(@Nonnull IReadableResource iReadableResource) {
        this.m_aBaseResource = ValueEnforcer.notNull(iReadableResource, "BaseResource");
    }

    @Override
    @Nonnull
    public IReadableResource getWrappedReadableResource() {
        return this.m_aBaseResource;
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.m_aBaseResource.getResourceID();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_aBaseResource.getPath();
    }

    @Override
    public boolean exists() {
        return this.m_aBaseResource.exists();
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return this.m_aBaseResource.getAsURL();
    }

    @Override
    @Nullable
    public File getAsFile() {
        return this.m_aBaseResource.getAsFile();
    }

    public String toString() {
        return new ToStringGenerator(this).append("BaseResource", this.m_aBaseResource).getToString();
    }
}

