/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.IErrorTextProvider;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ErrorTextProvider
implements IErrorTextProvider,
ICloneable<ErrorTextProvider> {
    public static final char PLACEHOLDER = '$';
    public static final String PLACEHOLDER_STR = Character.toString('$');
    public static final IErrorTextProvider DEFAULT = new ErrorTextProvider().addItem(EField.ERROR_DATETIME, "[$]").addItem(EField.ERROR_LEVEL, "[$]").addItem(EField.ERROR_ID, "[$]").addItem(EField.ERROR_FIELD_NAME, "in [$]").addItem(EField.ERROR_LOCATION, "@ $").addItem(EField.ERROR_TEXT, "$").addItem(EField.ERROR_LINKED_EXCEPTION_CLASS, "($:").addItem(EField.ERROR_LINKED_EXCEPTION_MESSAGE, "$)").setFieldSeparator(" ");
    private final ICommonsList<IFormattableItem> m_aItems;
    private String m_sFieldSep = " ";

    public ErrorTextProvider() {
        this.m_aItems = new CommonsArrayList<IFormattableItem>();
    }

    public ErrorTextProvider(@Nonnull ErrorTextProvider errorTextProvider) {
        this.m_aItems = (ICommonsList)errorTextProvider.m_aItems.getClone();
        this.m_sFieldSep = errorTextProvider.m_sFieldSep;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFormattableItem> getAllItems() {
        return (ICommonsList)this.m_aItems.getClone();
    }

    @Nonnull
    public ErrorTextProvider addItem(@Nonnull EField eField, @Nonnull @Nonempty String string) {
        return this.addItem(new FormattableItem(eField, string));
    }

    @Nonnull
    public ErrorTextProvider addItem(@Nonnull IFormattableItem iFormattableItem) {
        ValueEnforcer.notNull(iFormattableItem, "Item");
        this.m_aItems.add(iFormattableItem);
        return this;
    }

    @Nonnull
    public String getFieldSeparator() {
        return this.m_sFieldSep;
    }

    @Nonnull
    public ErrorTextProvider setFieldSeparator(@Nonnull String string) {
        this.m_sFieldSep = ValueEnforcer.notNull(string, "FieldSep");
        return this;
    }

    @Override
    @Nonnull
    public String getErrorText(@Nonnull IError iError, @Nonnull Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        block15: for (IFormattableItem iFormattableItem : this.m_aItems) {
            switch (iFormattableItem.getField().ordinal()) {
                case 0: {
                    stringBuilder.append(iFormattableItem.getUnformattedText());
                    continue block15;
                }
                case 1: {
                    if (!iError.hasErrorDateTime()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorDateTime().toString()));
                    continue block15;
                }
                case 2: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)iError.getErrorLevel().getID()));
                    continue block15;
                }
                case 3: {
                    if (!iError.hasErrorID()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorID()));
                    continue block15;
                }
                case 4: {
                    if (!iError.hasErrorFieldName()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorFieldName()));
                    continue block15;
                }
                case 5: {
                    Object object = iError.getErrorLocation();
                    if (!object.isAnyInformationPresent()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object.getAsString()));
                    continue block15;
                }
                case 6: {
                    Object object = iError.getErrorText(locale);
                    if (!StringHelper.hasText((String)object)) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object));
                    continue block15;
                }
                case 7: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object.getClass().getName()));
                    continue block15;
                }
                case 8: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    Object object2 = StringHelper.getNotNull(((Throwable)object).getMessage(), "");
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object2));
                    continue block15;
                }
                case 9: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object)));
                    continue block15;
                }
                case 10: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object2.getClass().getName()));
                    continue block15;
                }
                case 11: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    String string = StringHelper.getNotNull(((Throwable)object2).getMessage());
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(string));
                    continue block15;
                }
                case 12: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object2)));
                    continue block15;
                }
            }
            throw new IllegalStateException("Unsupported error field " + String.valueOf(iFormattableItem.getField()));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorTextProvider getClone() {
        return new ErrorTextProvider(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Items", this.m_aItems).append("FieldSeparator", this.m_sFieldSep).getToString();
    }

    @Immutable
    public static class FormattableItem
    implements IFormattableItem {
        private final EField m_eField;
        private final String m_sText;

        public FormattableItem(@Nonnull EField eField, @Nonnull @Nonempty String string) {
            this.m_eField = ValueEnforcer.notNull(eField, "Field");
            this.m_sText = ValueEnforcer.notEmpty(string, "Text");
            if (eField.isPlaceholderRequired()) {
                ValueEnforcer.isTrue(this.m_sText.contains(PLACEHOLDER_STR), () -> "Text '" + string + "' is missing placeholder '$'");
            }
        }

        @Override
        @Nonnull
        public final EField getField() {
            return this.m_eField;
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnformattedText() {
            return this.m_sText;
        }

        @Override
        @Nonnull
        public String getFormattedText(@Nonnull String string) {
            return StringHelper.replaceAll(this.m_sText, PLACEHOLDER_STR, string);
        }

        public String toString() {
            return new ToStringGenerator(this).append("Field", this.m_eField).append("Text", this.m_sText).getToString();
        }
    }

    public static enum EField implements IHasID<String>
    {
        CONSTANT("const"),
        ERROR_DATETIME("datetime"),
        ERROR_LEVEL("level"),
        ERROR_ID("id"),
        ERROR_FIELD_NAME("fieldname"),
        ERROR_LOCATION("location"),
        ERROR_TEXT("text"),
        ERROR_LINKED_EXCEPTION_CLASS("%lec"),
        ERROR_LINKED_EXCEPTION_MESSAGE("%lem"),
        ERROR_LINKED_EXCEPTION_STACK_TRACE("%lest"),
        ERROR_LINKED_EXCEPTION_CAUSE_CLASS("%lecc"),
        ERROR_LINKED_EXCEPTION_CAUSE_MESSAGE("%lecm"),
        ERROR_LINKED_EXCEPTION_CAUSE_STACK_TRACE("%lecst");

        private final String m_sID;

        private EField(String string2) {
            this.m_sID = string2;
        }

        @Override
        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        public boolean isPlaceholderRequired() {
            return this != CONSTANT;
        }

        @Nullable
        public static EField getFromIDOrNull(@Nullable String string) {
            return EnumHelper.getFromIDOrNull(EField.class, string);
        }
    }

    public static interface IFormattableItem {
        @Nonnull
        public EField getField();

        @Nonnull
        public String getUnformattedText();

        @Nonnull
        public String getFormattedText(@Nonnull String var1);
    }
}

