/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import org.mustangproject.Invoice;
import org.mustangproject.ZUGFeRD.TransactionCalculator;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class CalculatedInvoice
extends Invoice
implements Serializable {
    protected BigDecimal lineTotalAmount = null;
    protected BigDecimal duePayable = null;
    protected BigDecimal grandTotal = null;
    protected BigDecimal taxBasis = null;
    protected TransactionCalculator tc = null;

    public void calculate() {
        this.tc = new TransactionCalculator(this);
        this.grandTotal = this.tc.getGrandTotal();
        this.lineTotalAmount = this.tc.getValue();
        this.duePayable = this.tc.getDuePayable();
        this.taxBasis = this.tc.getTaxBasis();
    }

    public BigDecimal getGrandTotal() {
        if (this.grandTotal == null) {
            this.calculate();
        }
        return this.grandTotal;
    }

    public CalculatedInvoice setGrandTotal(BigDecimal grand) {
        this.grandTotal = grand;
        return this;
    }

    public BigDecimal getTaxBasis() {
        if (this.taxBasis == null) {
            this.calculate();
        }
        return this.taxBasis;
    }

    public CalculatedInvoice setTaxBasis(BigDecimal basis) {
        this.taxBasis = basis;
        return this;
    }

    public BigDecimal getDuePayable() {
        if (this.duePayable == null) {
            this.calculate();
        }
        return this.duePayable;
    }

    public CalculatedInvoice setDuePayable(BigDecimal due) {
        this.duePayable = due;
        return this;
    }

    public BigDecimal getLineTotalAmount() {
        if (this.lineTotalAmount == null) {
            this.calculate();
        }
        return this.lineTotalAmount;
    }

    public CalculatedInvoice setLineTotalAmount(BigDecimal total) {
        this.lineTotalAmount = total;
        return this;
    }

    public TransactionCalculator getCalculation() {
        return this.tc;
    }
}

