/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import com.helger.commons.io.stream.StreamHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.mustangproject.ClasspathResolverURIAdapter;
import org.mustangproject.EStandard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ZUGFeRDVisualizer {
    static final ClassLoader CLASS_LOADER = ZUGFeRDVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDVisualizer.class);
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltXRTemplate = null;
    private Templates mXsltUBLTemplate = null;
    private Templates mXsltCIOTemplate = null;
    private EnumMap<Language, Templates> mXsltHTMLTemplates = null;
    private Templates mXsltPDFTemplate = null;
    private Templates mXsltZF1HTMLTemplate = null;

    public ZUGFeRDVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    private EStandard findOutStandardFromRootNode(InputStream fis) throws ParserConfigurationException {
        String zf1Signature = "CrossIndustryDocument";
        String zf2Signature = "CrossIndustryInvoice";
        String ublSignature = "Invoice";
        String ublCreditNoteSignature = "CreditNote";
        String cioSignature = "SCRDMCCBDACIOMessageStructure";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", RESOURCE_PATH);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", RESOURCE_PATH);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(fis));
            Element root = doc.getDocumentElement();
            if (root.getLocalName().equals(zf1Signature)) {
                return EStandard.zugferd;
            }
            if (root.getLocalName().equals(zf2Signature)) {
                return EStandard.facturx;
            }
            if (root.getLocalName().equals(ublSignature)) {
                return EStandard.ubl;
            }
            if (root.getLocalName().equals(ublCreditNoteSignature)) {
                return EStandard.ubl_creditnote;
            }
            if (root.getLocalName().equals(cioSignature)) {
                return EStandard.orderx;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to recognize standard", e);
        }
        return null;
    }

    public String visualize(String xmlFilename, Language lang) throws IOException, TransformerException, ParserConfigurationException {
        try (FileInputStream fis = new FileInputStream(xmlFilename);){
            String string = this.visualize(fis, lang);
            return string;
        }
    }

    public String visualize(InputStream inputXml, Language lang) throws IOException, TransformerException, ParserConfigurationException {
        this.initTemplates(lang);
        String fileContent = new String(IOUtils.toByteArray(inputXml), StandardCharsets.UTF_8);
        EStandard thestandard = this.findOutStandardFromRootNode(new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream htmlOutput = new ByteArrayOutputStream();
        ByteArrayInputStream xmlContentStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
        if (thestandard == EStandard.zugferd) {
            this.applyZF1XSLT(xmlContentStream, htmlOutput);
            return htmlOutput.toString(StandardCharsets.UTF_8);
        }
        if (thestandard == EStandard.facturx) {
            this.applyZF2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.ubl) {
            this.applyUBL2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.orderx) {
            this.applyCIO2XSLT(xmlContentStream, htmlOutput);
        } else {
            throw new IllegalArgumentException("File does not look like CII or UBL");
        }
        Optional<InputStream> in = this.copyStream(htmlOutput);
        ByteArrayOutputStream htmlOutStream = new ByteArrayOutputStream();
        if (in.isPresent()) {
            this.applyXSLTToHTML(in.get(), htmlOutStream, lang);
        }
        return htmlOutStream.toString(StandardCharsets.UTF_8);
    }

    private Optional<InputStream> copyStream(ByteArrayOutputStream byteArrayOutputStream) {
        PipedInputStream in = new PipedInputStream();
        try {
            PipedOutputStream out = new PipedOutputStream(in);
            new Thread(() -> {
                try {
                    byteArrayOutputStream.writeTo(out);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write to stream", e);
                }
                finally {
                    StreamHelper.close(out);
                }
            }).start();
        }
        catch (IOException e1) {
            LOGGER.error("Failed to create HTML", e1);
            return Optional.empty();
        }
        return Optional.of(in);
    }

    private void initTemplates(Language lang) throws TransformerConfigurationException {
        if (this.mXsltXRTemplate == null) {
            this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
        }
        if (this.mXsltHTMLTemplates == null) {
            this.mXsltHTMLTemplates = new EnumMap(Language.class);
        }
        if (this.mXsltHTMLTemplates.get((Object)lang) == null) {
            Templates mXsltHTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xrechnung-html." + lang.name().toLowerCase() + ".xsl")));
            this.mXsltHTMLTemplates.put(lang, mXsltHTMLTemplate);
        }
        if (this.mXsltZF1HTMLTemplate == null) {
            this.mXsltZF1HTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ZUGFeRD_1p0_c1p0_s1p0.xslt")));
        }
    }

    protected String toFOP(String xmlFilename) throws IOException, TransformerException, ParserConfigurationException {
        EStandard theStandard;
        try (FileInputStream fis = new FileInputStream(xmlFilename);){
            theStandard = this.findOutStandardFromRootNode(fis);
        }
        fis = new FileInputStream(xmlFilename);
        try {
            String string = this.toFOP(fis, theStandard);
            return string;
        }
        finally {
            fis.close();
        }
    }

    protected String toFOP(InputStream is, EStandard theStandard) throws TransformerException, IOException {
        try {
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Failed to init XSLT templates", ex);
        }
        ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        if (theStandard == EStandard.facturx) {
            this.applyZF2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl) {
            this.applyUBL2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(is, iaos);
        }
        Optional<InputStream> in = this.copyStream(iaos);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (in.isPresent()) {
            this.applyXSLTToPDF(in.get(), baos);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    public void toPDF(String xmlFilename, String pdfFilename) {
        File XMLinputFile = new File(xmlFilename);
        String fopInput = null;
        try {
            fopInput = this.toFOP(XMLinputFile.getAbsolutePath());
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            LOGGER.error("Failed to apply FOP", e);
        }
        this.toPDFfromFOP(fopInput, () -> {
            try {
                return new FileOutputStream(pdfFilename);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Failed to create PDF", e);
                return null;
            }
        }, out -> {});
    }

    public byte[] toPDF(String xmlContent) {
        String fopInput = null;
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8));
            EStandard theStandard = this.findOutStandardFromRootNode(fis);
            fis = new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8));
            fopInput = this.toFOP(fis, theStandard);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            LOGGER.error("Failed to apply FOP", e);
        }
        AtomicReference byteHolder = new AtomicReference();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.toPDFfromFOP(fopInput, () -> new BufferedOutputStream(os), out -> {
            try {
                out.flush();
            }
            catch (IOException e) {
                LOGGER.error("Failed to create PDF", e);
            }
            byteHolder.set(os.toByteArray());
        });
        return (byte[])byteHolder.get();
    }

    private void toPDFfromFOP(String fopInput, Supplier<OutputStream> outputStreamDelegate, Consumer<OutputStream> consumerDelegate) {
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        DefaultConfiguration cfg = null;
        try {
            cfg = cfgBuilder.build(CLASS_LOADER.getResourceAsStream("fop-config.xconf"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI(), new ClasspathResolverURIAdapter()).setConfiguration(cfg);
        FopFactory fopFactory = builder.build();
        fopFactory.getFontManager().setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(new File(".").toURI(), new ClasspathResolverURIAdapter()));
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.getRendererOptions().put("pdf-a-mode", "PDF/A-3b");
        try (BufferedOutputStream out = new BufferedOutputStream(outputStreamDelegate.get());){
            Fop fop = fopFactory.newFop("application/pdf", userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(new ByteArrayInputStream(fopInput.getBytes(StandardCharsets.UTF_8)));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            consumerDelegate.accept(out);
        }
        catch (IOException | TransformerException | FOPException e) {
            LOGGER.error("Failed to create PDF", e);
        }
    }

    protected void applyZF2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltXRTemplate == null) {
            this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
        }
        Transformer transformer = this.mXsltXRTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyCIO2XSLT(InputStream xmlFile, OutputStream htmlOutstream) throws TransformerException {
        if (this.mXsltCIOTemplate == null) {
            this.mXsltCIOTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cio-xr.xsl")));
        }
        Transformer transformer = this.mXsltCIOTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutstream));
    }

    protected void applyUBL2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-invoice-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyUBLCreditNote2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-creditnote-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyZF1XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        Transformer transformer = this.mXsltZF1HTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyXSLTToHTML(InputStream xmlFile, OutputStream htmlOutStream, Language lang) throws TransformerException, IOException {
        Transformer transformer = this.mXsltHTMLTemplates.get((Object)lang).newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
        xmlFile.close();
    }

    protected void applyXSLTToPDF(InputStream xmlFile, OutputStream PDFOutstream) throws TransformerException, IOException {
        Transformer transformer = this.mXsltPDFTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(PDFOutstream));
        xmlFile.close();
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

