/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class VATAmount {
    protected BigDecimal basis;
    protected BigDecimal calculated;
    protected BigDecimal applicablePercent;
    protected String categoryCode;
    protected String vatExemptionReasonText;
    protected String dueDateTypeCode;

    public VATAmount(BigDecimal basis, BigDecimal calculated, String categoryCode) {
        this.basis = basis;
        this.calculated = calculated;
        this.categoryCode = categoryCode;
        this.dueDateTypeCode = null;
    }

    public VATAmount(BigDecimal basis, BigDecimal calculated, String categoryCode, String dueDateTypeCode) {
        this.basis = basis;
        this.calculated = calculated;
        this.categoryCode = categoryCode;
        this.dueDateTypeCode = dueDateTypeCode;
    }

    public VATAmount(BigDecimal basis, BigDecimal calculated, String categoryCode, String dueDateTypeCode, BigDecimal applicablePercent) {
        this.basis = basis;
        this.calculated = calculated;
        this.categoryCode = categoryCode;
        this.dueDateTypeCode = dueDateTypeCode;
        this.applicablePercent = applicablePercent;
    }

    public BigDecimal getApplicablePercent() {
        return this.applicablePercent;
    }

    public VATAmount setApplicablePercent(BigDecimal applicablePercent) {
        this.applicablePercent = applicablePercent;
        return this;
    }

    public BigDecimal getBasis() {
        return this.basis;
    }

    public VATAmount setBasis(BigDecimal basis) {
        this.basis = basis.setScale(2, RoundingMode.HALF_UP);
        return this;
    }

    public BigDecimal getCalculated() {
        return this.calculated;
    }

    public VATAmount setCalculated(BigDecimal calculated) {
        this.calculated = calculated;
        return this;
    }

    public String getVatExemptionReasonText() {
        return this.vatExemptionReasonText;
    }

    public VATAmount setVatExemptionReasonText(String theText) {
        this.vatExemptionReasonText = theText;
        return this;
    }

    @Deprecated
    public String getDocumentCode() {
        return this.categoryCode;
    }

    @Deprecated
    public VATAmount setDocumentCode(String documentCode) {
        this.categoryCode = documentCode;
        return this;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public VATAmount setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
        return this;
    }

    public String getDueDateTypeCode() {
        return this.dueDateTypeCode;
    }

    public VATAmount setDueDateTypeCode(String dueDateTypeCode) {
        this.dueDateTypeCode = dueDateTypeCode;
        return this;
    }

    public VATAmount add(VATAmount v) {
        return new VATAmount(this.basis.add(v.getBasis()), this.calculated.add(v.getCalculated()), this.categoryCode, this.dueDateTypeCode).setVatExemptionReasonText(v.getVatExemptionReasonText() != null ? v.getVatExemptionReasonText() : this.vatExemptionReasonText);
    }

    public VATAmount subtract(VATAmount v) {
        return new VATAmount(this.basis.subtract(v.getBasis()), this.calculated.subtract(v.getCalculated()), this.categoryCode, this.dueDateTypeCode).setVatExemptionReasonText(v.getVatExemptionReasonText());
    }
}

