/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import org.mustangproject.Charge;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Allowance
extends Charge {
    public Allowance() {
    }

    public Allowance(BigDecimal totalAmount) {
        super(totalAmount);
    }

    @Override
    public BigDecimal getTotalAmount(IAbsoluteValueProvider currentItem) {
        if (this.totalAmount != null) {
            return this.totalAmount;
        }
        if (this.percent != null) {
            BigDecimal singlePrice = currentItem.getValue().multiply(BigDecimal.ONE.subtract(this.getPercent().divide(new BigDecimal(100))));
            BigDecimal singlePriceDiff = currentItem.getValue().subtract(singlePrice);
            return singlePriceDiff.multiply(currentItem.getQuantity());
        }
        throw new RuntimeException("percent must be set");
    }

    @Override
    @JsonIgnore
    public boolean isCharge() {
        return false;
    }
}

