/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.transform.TransformSourceFactory;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

@Immutable
public final class XMLSchemaValidationHelper {
    private static final XMLSchemaValidationHelper INSTANCE = new XMLSchemaValidationHelper();

    private XMLSchemaValidationHelper() {
    }

    @Nonnull
    public static IErrorList validate(@Nonnull IReadableResource iReadableResource, @Nonnull IReadableResource iReadableResource2) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, iReadableResource2);
    }

    @Nonnull
    public static IErrorList validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "XML");
        return XMLSchemaValidationHelper.validate(iReadableResourceArray, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IErrorList validate(@Nonnull Schema schema, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "XML");
        return XMLSchemaValidationHelper.validate(schema, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IErrorList validate(@Nonnull @Nonempty IReadableResource iReadableResource, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, source);
    }

    @Nonnull
    public static IErrorList validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(XMLSchemaCache.getInstance().getSchema(iReadableResourceArray), source);
    }

    @Nonnull
    public static IErrorList validate(@Nonnull Schema schema, @Nonnull Source source) {
        ErrorList errorList = new ErrorList();
        XMLSchemaValidationHelper.validate(schema, source, errorList);
        return errorList;
    }

    public static void validate(@Nonnull Schema schema, @Nonnull Source source, @Nonnull ErrorList errorList) {
        XMLSchemaValidationHelper.validate(schema, source, errorList, null);
    }

    public static void validate(@Nonnull Schema schema, @Nonnull Source source, @Nonnull ErrorList errorList, @Nullable Locale locale) {
        ValueEnforcer.notNull(schema, "Schema");
        ValueEnforcer.notNull(source, "XML");
        ValueEnforcer.notNull(errorList, "ErrorList");
        Validator validator = schema.newValidator();
        if (locale != null) {
            EXMLParserProperty.GENERAL_LOCALE.applyTo(validator, (Object)locale);
        }
        validator.setErrorHandler(new WrappedCollectingSAXErrorHandler(errorList));
        try {
            validator.validate(source, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to validate the XML " + String.valueOf(source) + " against " + String.valueOf(schema), exception);
        }
    }
}

