/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocumentType
extends AbstractMicroNode
implements IMicroDocumentType {
    public static final String NODE_NAME = "#doctype";
    private final String m_sQualifiedName;
    private final String m_sPublicID;
    private final String m_sSystemID;

    public MicroDocumentType(@Nonnull IMicroDocumentType iMicroDocumentType) {
        this(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    public MicroDocumentType(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notEmpty(string, "QualifiedName");
        this.m_sQualifiedName = string;
        this.m_sPublicID = string2;
        this.m_sSystemID = string3;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT_TYPE;
    }

    @Override
    @Nonnull
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    @Nonnull
    public String getQualifiedName() {
        return this.m_sQualifiedName;
    }

    @Override
    @Nullable
    public String getPublicID() {
        return this.m_sPublicID;
    }

    @Override
    @Nullable
    public String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    @Nonnull
    public IMicroDocumentType getClone() {
        return new MicroDocumentType(this);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroDocumentType microDocumentType = (MicroDocumentType)iMicroNode;
        return this.m_sQualifiedName.equals(microDocumentType.m_sQualifiedName) && EqualsHelper.equals(this.m_sPublicID, microDocumentType.m_sPublicID) && EqualsHelper.equals(this.m_sSystemID, microDocumentType.m_sSystemID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("qualifiedName", this.m_sQualifiedName).append("publicID", this.m_sPublicID).append("systemID", this.m_sSystemID).getToString();
    }
}

