/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.xml.bind.ValidationEventHandler;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBBuilderDefaultSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBBuilderDefaultSettings.class);
    public static final boolean DEFAULT_USE_CONTEXT_CACHE = true;
    public static final ValidationEventHandler DEFAULT_VALIDATION_EVENT_HANDLER = LoggingValidationEventHandler.DEFAULT_INSTANCE;
    public static final boolean DEFAULT_FORMATTED_OUTPUT = false;
    public static final Charset DEFAULT_CHARSET = XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ;
    public static final boolean DEFAULT_USE_SCHEMA = true;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseContextCache = true;
    @GuardedBy(value="RW_LOCK")
    private static ValidationEventHandler s_aEventHandler = DEFAULT_VALIDATION_EVENT_HANDLER;
    @GuardedBy(value="RW_LOCK")
    private static NamespaceContext s_aNamespaceContext;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bFormattedOutput;
    @GuardedBy(value="RW_LOCK")
    private static Charset s_aCharset;
    @GuardedBy(value="RW_LOCK")
    private static String s_sIndentString;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseSchema;
    @GuardedBy(value="RW_LOCK")
    private static String s_sSchemaLocation;
    @GuardedBy(value="RW_LOCK")
    private static String s_sNoNamespaceSchemaLocation;

    private JAXBBuilderDefaultSettings() {
    }

    public static boolean isDefaultUseContextCache() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseContextCache);
    }

    public static void setDefaultUseContextCache(boolean bl) {
        LOGGER.info("The default JAXB Context Cache is now " + (bl ? "enabled" : "disabled"));
        RW_LOCK.writeLocked(() -> {
            s_bUseContextCache = bl;
        });
    }

    @Nullable
    public static ValidationEventHandler getDefaultValidationEventHandler() {
        return RW_LOCK.readLockedGet(() -> s_aEventHandler);
    }

    public static void setDefaultValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        LOGGER.info("The default JAXB Validation Event Handler is now " + String.valueOf(validationEventHandler));
        RW_LOCK.writeLocked(() -> {
            s_aEventHandler = validationEventHandler;
        });
    }

    @Nullable
    public static NamespaceContext getDefaultNamespaceContext() {
        return RW_LOCK.readLockedGet(() -> s_aNamespaceContext);
    }

    public static void setDefaultNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        LOGGER.info("The default JAXB XML Namespace Context is now " + String.valueOf(namespaceContext));
        RW_LOCK.writeLocked(() -> {
            s_aNamespaceContext = namespaceContext;
        });
    }

    public static boolean isDefaultFormattedOutput() {
        return RW_LOCK.readLockedBoolean(() -> s_bFormattedOutput);
    }

    public static void setDefaultFormattedOutput(boolean bl) {
        LOGGER.info("The default JAXB XML output is now " + (bl ? "formatted" : "unformatted"));
        RW_LOCK.writeLocked(() -> {
            s_bFormattedOutput = bl;
        });
    }

    @Nullable
    public static Charset getDefaultCharset() {
        return RW_LOCK.readLockedGet(() -> s_aCharset);
    }

    public static void setDefaultCharset(@Nullable Charset charset) {
        LOGGER.info("The default JAXB Charset is now " + (String)(charset == null ? "null" : "'" + charset.name() + "'"));
        RW_LOCK.writeLocked(() -> {
            s_aCharset = charset;
        });
    }

    @Nullable
    public static String getDefaultIndentString() {
        return RW_LOCK.readLockedGet(() -> s_sIndentString);
    }

    @Nullable
    private static String _getNice(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 3);
        for (char c : cArray) {
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void setDefaultIndentString(@Nullable String string) {
        LOGGER.info("The default JAXB Indent String is now '" + JAXBBuilderDefaultSettings._getNice(string) + "'");
        RW_LOCK.writeLocked(() -> {
            s_sIndentString = string;
        });
    }

    public static boolean isDefaultUseSchema() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseSchema);
    }

    public static void setDefaultUseSchema(boolean bl) {
        LOGGER.info("The default JAXB XML Schema usage is now " + (bl ? "enabled" : "disabled"));
        RW_LOCK.writeLocked(() -> {
            s_bUseSchema = bl;
        });
    }

    @Nullable
    public static String getDefaultSchemaLocation() {
        return RW_LOCK.readLockedGet(() -> s_sSchemaLocation);
    }

    public static void setDefaultSchemaLocation(@Nullable String string) {
        LOGGER.info("The default JAXB XML Schema Location is now " + (String)(string == null ? "null" : "'" + string + "'"));
        RW_LOCK.writeLocked(() -> {
            s_sSchemaLocation = string;
        });
    }

    @Nullable
    public static String getDefaultNoNamespaceSchemaLocation() {
        return RW_LOCK.readLockedGet(() -> s_sNoNamespaceSchemaLocation);
    }

    public static void setDefaultNoNamespaceSchemaLocation(@Nullable String string) {
        LOGGER.info("The default JAXB XML Schema No-Namespace Schema Location is now " + (String)(string == null ? "null" : "'" + string + "'"));
        RW_LOCK.writeLocked(() -> {
            s_sNoNamespaceSchemaLocation = string;
        });
    }

    static {
        s_bFormattedOutput = false;
        s_aCharset = DEFAULT_CHARSET;
        s_bUseSchema = true;
    }
}

